/*
 *	@(#)socket.h	1.1	(Alex Crain)	6/20/89
 *
 *  socket.h - socket related definitions
 *
 *  Written by Alex Crain.
 *
 *  This file is loosly based in the Berkeley header file of the 
 *  same name, but is *not* guarenteed to be in any way compatable. It is
 *  close enough to the berkeley code that the following applies...
 *
 *  Copyright (c) 1982, 1986, 1988 Regents of the University of California.
 *  All rights reserved.
 * 
 *  Redistribution and use in source and binary forms are permitted
 *  provided that this notice is preserved and that due credit is given
 *  to the University of California at Berkeley. The name of the University
 *  may not be used to endorse or promote products derived from this
 *  software without specific prior written permission. This software
 *  is provided "as is" without express or implied warranty.
 *
 */

#ifndef _socket_h_
#define _socket_h_

#include <uipc/conf.h>

/*
 *  Socket types
 */

#define SOCK_STREAM	1		/* stream socket	*/
#define SOCK_DGRAM	2		/* datagram socket	*/
#ifdef notdef
#define SOCK_RAW	3		/* raw socket		*/
#endif

/*
 *  Socket option flags
 */

#define SO_DEBUG	0x0001
#define SO_ACCEPTCONN	0x0002
#define SO_REUSEADDR	0x0004
#define SO_KEEPALIVE	0x0008
#define SO_DONTROUTE	0x0010
#define SO_BROADCAST	0x0020
#define SO_USELOOPBACK	0x0040
#define SO_LINGER	0x0080
#define SO_OOBINLINE	0x0100
/*
 *  Extra socket options
 */

#define SO_SNDBUF	0x1001
#define SO_RCVBUF	0x1002
#define SO_SNDLOWAT	0x1003
#define SO_RCVLOWAT	0x1004
#define SO_SNDTIMEO	0x1005
#define SO_RCVTIMEO	0x1006
#define SO_ERROR	0x1007
#define SO_TYPE		0x1008

/*
 *  Linger structure
 */

struct linger {
   int	l_onoff;
   int	l_linger;
};

#define SOL_SOCKET	0xffff

/*
 *  Address families
 */

#define AF_UNSPEC	0
#define AF_UNIX		1
#define AF_INIT		2

#define AF_MAX		3

/*
 *  Structure for address specs.
 */

struct sockaddr {
   u_short	sa_family;		/* address family	*/
   char		sa_data[14];		/* address spec		*/
};

/*
 *  Protocol families
 */

#define PF_UNSPEC	AF_UNSPEC
#define PF_UNIX		AF_UNIX
#define PF_INET		AF_INET

#define PF_MAX		AF_MAX

/*
 *  maximum queue length for listen ()
 */

#define SOMAXCONN	5


/*
 *  message header for recvmsg and sendmsg calls.
 */

struct msghdr {
   caddr_t	msg_name;
   int		msg_namelen;
   caddr_t	msg_accrights;
   int		msg_accrightslen;
};

#define MSG_OOB		0x01		/* flag for out-of-band data	*/
#define MSG_PEEK	0x02		/* peek at incomming message	*/
#define MSG_DONTROUTE	0x04		/* send without routing tables	*/

#endif /* _socket_h_ */
