/*
 * NAME
 * 	prwopen - modified popen(3) to work with pty's instead of 
 * 		  pipes, and also provide both read and write 
 * 		  capabilities to the child process.
 *
 * SYNOPSIS
 *	#include <stdio.h>
 *	
 * 	int prwopen( cmd, streams )
 *	char *cmd;
 *	FILE streams[2];
 *
 * AUTHOR (actually, merger!)
 *	John Ioannidis, ioannidis@cs.columbia.edu
 * 
 * SEE ALSO
 *	popen(3), after which this call is modelled.
 *
 * UNIX SOURCES USED
 * 	popen(3), script(1)
 *
 */
#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <sgtty.h>

static	int	pip_pid[ 20 ];

int
prwopen( cmd, streams )
char *cmd;
FILE *streams[];
{
	int pty, pid, j;
	struct stat stb;
	char c;
	static char *line = "/dev/ptyp0";

        for( c = 'p'; c <= 's'; c++ )
        {
                line[strlen("/dev/pty")] = c;
                line[strlen("/dev/ptyp")] = '0';
                if( stat( line, &stb ) < 0 )
                        break;
                for( j = 0; j < 16; j++ )
                {
                        line[strlen("/dev/ptyp")] = "0123456789abcdef"[j];
                        if( ( pty = open( line, 2 )) > 0 )
			goto opened;
                }
        }
        return( -1 );

opened:
	switch( pid = fork() )
	{
	case -1:
		return( -1 );
	
	case 0:
		{
			int t, tty;
			struct sgttyb bf;
			t=open( "/dev/tty", 2 );
			if( t >= 0 )
			{
				ioctl( t, TIOCNOTTY, (char *)0 );
				close( t );
			}
			line[strlen("/dev/")] = 't';
			tty = open( line, 2 );
			close( pty );
			ioctl( tty, TIOCGETP, &bf );
			bf.sg_flags &= ~ECHO;
			ioctl( tty, TIOCSETP, &bf );
			dup2( tty, 0 );
			dup2( tty, 1 );
			dup2( tty, 2 );
			close( tty );

			execl( "/bin/sh", "sh", "-c", cmd, 0 );
			_exit(1);
		}
	}
	
	pip_pid[pty]=pid;

	if( (streams[0] = fdopen( pty, "r" )) == NULL ||
	    (streams[1] = fdopen( pty, "w" )) == NULL )
	{
		return( -1 );
	}	
	setbuf( streams[0], NULL );
	setbuf( streams[1], NULL );
	return( 0 );
}

prwclose( streams )
FILE *streams[];
{
        register f, r, (*hstat)(), (*istat)(), (*qstat)();
        int status;

        f = fileno(streams[1]);
        fclose(streams[0]);
        fclose(streams[1]);
        istat = signal(SIGINT, SIG_IGN);
        qstat = signal(SIGQUIT, SIG_IGN);
        hstat = signal(SIGHUP, SIG_IGN);
        while((r = wait(&status)) != pip_pid[f] && r != -1)
                ;
        if(r == -1)
                status = -1;
        signal(SIGINT, istat);
        signal(SIGQUIT, qstat);
        signal(SIGHUP, hstat);
        return(status);
}

