#include	<sys/types.h>
#include	<sys/sysmacros.h>
#include	<sys/conf.h>
#include	<sys/tty.h>

int (*real_linesw_read)(), (*real_linesw_write)();
int (*real_linesw_l_input)();
int so_linesw_read(), so_linesw_write();
int so_linesw_l_input();

/* stuff to wake up on */
extern int select_sleep, select_sleep_addr;

/* unsigned addr_win_tty = 384636; /* */

so_linesw_read(tp)
struct tty *tp;
{
	extern int (*real_linesw_read) ();

	/* next check us for wakeup maybe? */
	if(select_sleep) {
		select_sleep = 0;
		wakeup((caddr_t) &select_sleep_addr);
	}
	(*real_linesw_read)(tp);
}
so_linesw_write(tp)
struct tty *tp;
{
	extern int (*real_linesw_write) ();

	/* next check us for wakeup maybe? */
	if(select_sleep) {
		select_sleep = 0;
		wakeup((caddr_t) &select_sleep_addr);
	}
	(*real_linesw_write)(tp);
}
so_linesw_l_input(tp)
struct tty *tp;
{

	/* next check us for wakeup maybe? */
	if(select_sleep) {
		select_sleep = 0;
		wakeup((caddr_t) &select_sleep_addr);
	}
	/* first call real input routine */
	(*real_linesw_l_input)(tp);
}
so_linesw_setup()
{
	extern int (*real_linesw_write) ();
	extern int (*real_linesw_read) ();
	extern int (*real_linesw_l_input) ();

	/* setup to route tty ouput to here */
	real_linesw_read = linesw[0].l_read;
	linesw[0].l_read = so_linesw_read;
	real_linesw_write = linesw[0].l_write;
	linesw[0].l_write = so_linesw_write;
	real_linesw_l_input = linesw[0].l_input;
	linesw[0].l_input = so_linesw_l_input;

}
so_linesw_release()
{
	extern int (*real_linesw_write) ();
	extern int (*real_linesw_read) ();

	/* setup to route tty ouput to here */
	linesw[0].l_read = real_linesw_read;
	linesw[0].l_write = real_linesw_write;
	linesw[0].l_input = real_linesw_l_input;

}
