#ifndef LINT
static char * sccsdef = "@(#)domain.c	1.1	(Alex Crain) 6/20/89";
#endif

/*
 *  domain.c - routines for handling domains
 *
 *  Written by Alex Crain.
 *
 *  This file is loosly based in the Berkeley file uipc_domain.c,
 *  but is *not* guarenteed to be in any way compatable. It is
 *  close enough to the Berkeley code that the following applies...
 *
 *  Copyright (c) 1982, 1986, 1988 Regents of the University of California.
 *  All rights reserved.
 * 
 *  Redistribution and use in source and binary forms are permitted
 *  provided that this notice is preserved and that due credit is given
 *  to the University of California at Berkeley. The name of the University
 *  may not be used to endorse or promote products derived from this
 *  software without specific prior written permission. This software
 *  is provided "as is" without express or implied warranty.
 *
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <uipc/socketvar.h>
#include <uipc/socket.h>
#include <uipc/protosw.h>
#include <uipc/domain.h>
#include <uipc/mbuf.h>
#include <uipc/fproto.h>

#ifndef __STDC__
#define ADDDOMAIN(x) \
 {  extern struct domain x/**/domain;	\
    x/**/domain.dom_next = domains;	\
    domains = &x/**/domain; }
#else
#define ADDDOMAIN(x) \
 {  extern struct domain x ## domain;	\
    x ## domain.dom_next = domains;	\
    domains = &x ## domain; }
#endif

void
domaininit ()
{
   register struct domain * dp;
   register struct protosw * pr;

   ADDDOMAIN (unix);

#ifdef INET
   ADDDOMAIN (inet);
#endif
   
   for (dp = domains; dp; dp = dp->dom_next)
    {
       if (dp->dom_init)
	   (* dp->dom_init) ();
       for (pr = dp->dom_protosw; pr < dp->dom_protoswNPROTOSW; pr++)
	   if (pr->pr_init)
	       (* pr->pr_init) ();
    }
}
	    
struct protosw *
pffindtype (family, type)
  int family, type;
{
   register struct domain * dp;
   register struct protosw * pr;
   
   for (dp = domains; dp; dp = dp->dom_next)
       if (dp->dom_family == family)
	   goto found;
   return 0;
 found:
   for (pr = dp->dom_protosw; pr < dp->dom_protoswNPROTOSW; pr++)
       if (pr->pr_type && pr->pr_type == type)
	   return pr;
   return 0;
}

struct protosw *
pffindproto (family, protocol, type)
  int family, protocol, type;
{
   register struct domain * dp;
   register struct protosw * pr;
   struct protosw * maybe = 0;

   for (dp = domains; dp; dp = dp->dom_next)
       if (dp->dom_family == family)
	   goto found;
   return 0;
 found:
   for (pr = dp->dom_protosw; pr < dp->dom_protoswNPROTOSW; pr++)
    {
       if ((pr->pr_protocol == protocol) && (pr->pr_type == type))
	   return pr;

#ifdef SOCK_RAW
       if ((type == SOCK_RAW && pr->pr_type == SOCK_RAW &&
	    pr->pr_protocol == 0 && maybe = (struct protosw *) 0))
	   maybe = pr;
#endif
    }
   return maybe;
}
