#
		text
		asciz	"@(#)syserr.s	1.1	(Alex Crain) 6/19/89"

#
#  System error messages for uipc perror() function.
#

ERROR0:		asciz	"Error 0"			# 0

#
#  Standard unix errors
#

EPERM:		asciz	"Not super-user"		# 1
ENOENT:		asciz	"No such file or directory"	# 2
ESRCH:		asciz	"No such process"		# 3
EINTR:		asciz	"interrupted system call"	# 4
EIO:		asciz	"I/O error"			# 5
ENXIO:		asciz	"No such device or address"	# 6
E2BIG:		asciz	"Arg list too long"		# 7
ENOEXEC:	asciz	"Exec format error"		# 8
EBADF:		asciz	"Bad file number"		# 9
ECHILD:		asciz	"No children"			# 10
EAGAIN:		asciz	"No more processes"		# 11
ENOMEM:		asciz	"Not enough core"		# 12
EACCES:		asciz	"Permission denied"		# 13
EFAULT:		asciz	"Bad address"			# 14
ENOTBLK:	asciz	"Block device required"		# 15
EBUSY:		asciz	"Mount device busy"		# 16
EEXIST:		asciz	"File exists"			# 17
EXDEV:		asciz	"Cross-device link"		# 18
ENODEV:		asciz	"No such device"		# 19
ENOTDIR:	asciz	"Not a directory"		# 20
EISDIR:		asciz	"Is a directory"		# 21
EINVAL:		asciz	"Invalid argument"		# 22
ENFILE:		asciz	"File table overflow"		# 23
EMFILE:		asciz	"Too many open files"		# 24
ENOTTY:		asciz	"Not a typewriter"		# 25
ETXTBSY:	asciz	"Text file busy"		# 26
EFBIG:		asciz	"File too large"		# 27
ENOSPC:		asciz	"No space left on device"	# 28
ESPIPE:		asciz	"Illegal seek"			# 29
EROFS:		asciz	"Read only file system"		# 30
EMLINK:		asciz	"Too many links"		# 31
EPIPE:		asciz	"Broken pipe"			# 32
EDOM:		asciz	"Math arg out of domain of func"# 33
ERANGE:		asciz	"Math result not representable"	# 34
ENOMSG:		asciz	"No message of desired type"	# 35
EIDRM:		asciz	"Identifier removed"		# 36
ECHRNG:		asciz	"Channel number out of range"	# 37
EL2NSYNC:	asciz	"Level 2 not synchronized"	# 38
EL3HLT:		asciz	"Level 3 halted"		# 39
EL3RST:		asciz	"Level 3 reset"			# 40
ELNRNG:		asciz	"Link number out of range"	# 41
EUNATCH:	asciz	"Protocol driver not attached"	# 42
ENOCSI:		asciz	"No CSI structure available"	# 43
EL2HLT:		asciz	"Level 2 halted"		# 44

#
#  filler messages
#

ERROR45:	asciz	"Error 45"			# 45
ERROR46:	asciz	"Error 46"			# 46
ERROR47:	asciz	"Error 47"			# 47
ERROR48:	asciz	"Error 48"			# 48
ERROR49:	asciz	"Error 49"			# 49

#
#  Convergent Errors
#

EBADE:		asciz	"invalid exchange"		# 50
EBADR:		asciz	"invalid request descriptor"	# 51
EXFULL:		asciz	"exchange full"			# 52
ENOANO:		asciz	"no anode"			# 53
EBADRQC:	asciz	"invalid request code"		# 54
EBADSLT:	asciz	"invalid slot"			# 55
EDEADLOCK:	asciz	"file locking deadlock error"	# 56
EBFONT:		asciz	"bad font file fmt"		# 57

# For BASSLOCKING

ENOLCK:		asciz	"no more locks available"	# 58
EDEADLK:	asciz	"file locking deadlock error"	# 59

#
# Hardware specific errors 
#

ENOHDW:		asciz	"No hardware available for operation"	# -32
EBADFS:		asciz	"bitmapped filesystem is marked dirty"	# -31

#
#  4.[23] BSD error numbers & messages
#
#  errors for non-blocking I/O.
#

EWOULDBLOCK:	asciz	"Operation would block"			# -30
EINPROGRESS:	asciz	"Operation now in progress"		# -29
EALREADY:	asciz	"Operation already in progress"		# -28

#
#  Uipc errors
#
#  Argument errors
#

ENOTSOCK:	asciz	"Socket operation on non-socket"	# -27
EDESTADDRREQ:	asciz	"Destination address required"		# -26
EMSGSIZE:	asciz	"Message too long"			# -25
EPROTOTYPE:	asciz	"Protocol wrong type for socket"	# -24
EPROTONOSUPPORT:	asciz	"Protocol not supported"	# -23
ESOCKTNOSUPPORT:	asciz	"Socket type not supported"	# -22
EOPNOTSUPP:	asciz	"Operation not supported on socket"	# -21
EPFNOSUPPORT:	asciz	"Protocol family not supported"		# -20
EAFNOSUPPORT:	asciz	"Address family not supported by protocol family" # -19
EADDRINUSE:	asciz	"Address already in use"		# -18
EADDRNOTAVAIL:	asciz	"Can't assign requested address"	# -17

#
#  Network errors
#

ENETDOWN:	asciz	"Network is down"			# -16
ENETUNREACH:	asciz	"Network is unreachable"		# -15
ENETRESET:	asciz	"Network dropped connection on reset"	# -14
ECONNABORTED:	asciz	"Software caused connection abort"	# -13
ECONNRESET:	asciz	"Connection reset by peer"		# -12
ENOBUFS:	asciz	"No buffer space available"		# -11
EISCONN:	asciz	"Socket is already connected"		# -10
ENOTCONN:	asciz	"Socket is not connected"		# -9
ESHUTDOWN:	asciz	"Can't send after socket shutdown"	# -8
ETOOMANYREFS:	asciz	"Too many references: can't splice"	# -7
ETIMEDOUT:	asciz	"Connection timed out"			# -6
ECONNREFUSED:	asciz	"Connection refused"			# -5
EHOSTDOWN:	asciz	"Host is down"				# -4
EHOSTUNREACH:	asciz	"No route to host"			# -3
ENOPROTOOPT:	asciz	"Protocol not available"		# -2

ERROR_1:	asciz	"Error -1"				# -1

#
#  The system error table
#
	data
	even

	long	ENOHDW
	long	EBADFS
	long	EWOULDBLOCK
	long	EINPROGRESS
	long	EALREADY
	long	ENOTSOCK
	long	EDESTADDRREQ
	long	EMSGSIZE
	long	EPROTOTYPE
	long	EPROTONOSUPPORT
	long	ESOCKTNOSUPPORT
	long	EOPNOTSUPP
	long	EPFNOSUPPORT
	long	EAFNOSUPPORT
	long	EADDRINUSE
	long	EADDRNOTAVAIL
	long	ENETDOWN
	long	ENETUNREACH
	long	ENETRESET
	long	ECONNABORTED
	long	ECONNRESET
	long	ENOBUFS
	long	EISCONN
	long	ENOTCONN
	long	ESHUTDOWN
	long	ETOOMANYREFS
	long	ETIMEDOUT
	long	ECONNREFUSED
	long	EHOSTDOWN
	long	EHOSTUNREACH
	long	ENOPROTOOPT
	long	ERROR_1

	global uipc_errlist
uipc_errlist:
	long	ERROR0
	long	EPERM
	long	ENOENT
	long	ESRCH
	long	EINTR
	long	EIO
	long	ENXIO
	long	E2BIG
	long	ENOEXEC
	long	EBADF
	long	ECHILD
	long	EAGAIN
	long	ENOMEM
	long	EACCES
	long	EFAULT
	long	ENOTBLK
	long	EBUSY
	long	EEXIST
	long	EXDEV
	long	ENODEV
	long	ENOTDIR
	long	EISDIR
	long	EINVAL
	long	ENFILE
	long	EMFILE
	long	ENOTTY
	long	ETXTBSY
	long	EFBIG
	long	ENOSPC
	long	ESPIPE
	long	EROFS
	long	EMLINK
	long	EPIPE
	long	EDOM
	long	ERANGE
	long	ENOMSG
	long	EIDRM
	long	ECHRNG
	long	EL2NSYNC
	long	EL3HLT
	long	EL3RST
	long	ELNRNG
	long	EUNATCH
	long	ENOCSI
	long	EL2HLT
	long	ERROR45
	long	ERROR46
	long	ERROR47
	long	ERROR48
	long	ERROR49
	long	EBADE
	long	EBADR
	long	EXFULL
	long	ENOANO
	long	EBADRQC
	long	EBADSLT
	long	EDEADLOCK
	long	EBFONT
	long	ENOLCK
	long	EDEADLK

	even

	global uipc_firsterr
uipc_firsterr:
	long	-32

	global uipc_lasterr
uipc_lasterr:
	long	59

