#ifndef LINT
static char * sccsdef = "@(#)perror.c	1.1	(Alex Crain) 6/19/89";
#endif

/*
 *
 * Replace ment for the perror(3c) subroutine. Note that sys_errlist and
 * sys_nerr have been renamed to uipc_errlist and uipc_lasterr, and that 
 * uipc_firsterr has been added. uipc_firsterr and uipc_lasterr represent
 * the maximum negative and posative offsets to uipc_errlist, respectively.
 *
 * Note also that we don't check for overflow of the print buffer, but 1024
 * should be enough.
 */

void
perror(str)
  char * str;
{
   extern int errno;
   extern int uipc_lasterr;
   extern int uipc_firsterr;
   extern char * uipc_errlist[];
   int offset = (int) ((char) errno);
   char buffer[1024];

   if (str && strlen (str))
    {
       strcpy (buffer, str);
       strcat (buffer, ": ");
    }
   else
       buffer[0] = '\0';

   if (offset == 0 ||
       (offset < 0 && offset >= uipc_firsterr) ||
       (offset > 0 && offset <= uipc_lasterr))

    {
       strcat (buffer, uipc_errlist[offset]);
       strcat (buffer, ".\n");
    }
   else
       sprintf (&buffer[strlen (buffer)], "Unknown error # %d.\n", errno);

   write (2, buffer, strlen (buffer));
   return;
}
