/*
 * vt - A termcap driven VT100 emulator for BSD Unix
 *
 * Version 2.0
 *
 * Public domain software.
 * Written by Leif Samuelsson (leif@erisun) in December, 1985
 *
 *
 *
 * Modified  to work on SYS-5 Unix and to handle alternate character
 * set on the Unix-pc by 
 * Muhammad S. Benten
 * benten@boulder.colorado.edu
 * December, 1988
 *
 */

#include "vtem.h"
#include <sys/wait.h>

int master, slave, child1,child2;
char linec, linen;
struct termio termio;
int file_pipe[2];


done()
{
union wait status;

	if (wait(&status) != child1)
		return;
	kill(child2,SIGTERM);
	setup_term(0);
	exit(0);
}

main()
{
	/* Strategy: Start three processes, one for input, one for output
         * and one shell.
         */
        pipe(file_pipe);

	setup_term(TRUE);
        setup_pty();
	if ( (child1 = fork())  == 0 ) {
	   close(master);
	   start_shell();
           exit(1);
	}

	if ( (child2 = fork()) == 0 ) {
                close(0);
                dup(file_pipe[0]);
		handle_output();
        }

	signal(SIGCLD, done);
	handle_input();
}

handle_input()
{
	char buf[BUFSIZ];
	int i,j,k;
	int bitmask;
	long t, ti;
	char *ctime();

	/* j=open(ttyname(0),4); /* */
	j=open(ttyname(0),2); /* */
	t = 10;
	while (1)  {
		bitmask = 1 << master;
		bitmask |= 1 << j;
		i = select(32, &bitmask, 0, 0, 0);
		if(i)
		{
			if(bitmask & (1 << master)) {
				i = read(master,buf,BUFSIZ);
				if ( i > 0 )
				   write(file_pipe[1], buf, i);
			}
			if(bitmask & (1 << j)) {
				i = read(j, buf, BUFSIZ) ;
				if ( i > 0 )
				   write(master, buf, i);
			}
		}
	}
}


start_shell()
{
int t;
char *cp, shellname[20],shellpgm[100], *strrchr();

	if ((cp = getenv("SHELL")) == (char *)0)
		strcpy(shellpgm, "sh");
	else
		strcpy(shellpgm, cp);
	if ((cp = (char *) strrchr(shellpgm,'/')) == (char *)0)
		strcpy(shellname, shellpgm);
	else
		strcpy(shellname, &cp[1]);
	close(0);
	dup(slave);
	close(1);
	dup(slave);
	close(2);
	dup(slave);
	close(slave);
	signal(SIGINT,SIG_DFL);
	signal(SIGQUIT,SIG_DFL);
	printf("Welcome to the vt100 emulator\n");
	execlp(shellpgm, shellname,0);
	printf("vtem: Cannot start the shell '%s' \nvtem: Please cheack the SHELL environment variable\n",shellpgm);
        sleep(1);
}



setup_pty()
{
char line[11];

    for (linec = 'p'; linec <= 'q'; linec++) {
	sprintf(line, "/dev/pty%c0", linec);
	if (access(line, 0) != 0)
	    break;
	for (linen = 0; linen < 16; linen++) {
	    sprintf(line, "/dev/pty%c%1x", linec, linen);
	    master = open(line, 2|4); /* */
	    /* master = open(line, 2); /* */
	    if (master >= 0) {
               sprintf(line, "/dev/tty%c%1x", linec, linen);
               slave = open(line, 2);
               if (slave < 0) {
	           perror(line);
                   setup_term(0);
                   exit(1);
               }
               ioctl(master, TCSETA, (char *)&oldtermio);
	       return;
	    }
	}
    }
    
    perror("pty in setup_pty\n");
    setup_term(0);
    exit(1);
}


perror(x)
char *x;
{
   fprintf(stderr,"vtem: Unknown problem with %s\n\r",x);
}
