/*
 * vt - A termcap driven VT100 emulator for BSD Unix
 *
 * Version 2.0
 *
 * Public domain software.
 * Written by Leif Samuelsson (leif@erisun) in December, 1985
 *
 *
 *
 * Modified  to work on SYS-5 Unix and to handle alternate character set by 
 * Muhammad S. Benten
 * benten@boulder.colorado.edu
 * December, 1988
 *
 */


/* This module contains termcap and tty routines */

#include "vtem.h"
extern int shiftit;
int shiftit;

extern char *tgetstr(), *tgoto();

/* Variables for saving original terminal parameters */
#ifndef SYSV	/* V7 style */
  struct sgttyb oldb, newb;
#else
  struct termio oldtermio,newtermio;
#endif
  int oldlb, newlb, oldl, newl;

/* Terminal attributes */
char tbuf[1024];
Bool BS;
int CO, LI;
char	*AL, *BC, *BL, *CD, *CL, *CE, *CM, *CR, *CS, *DL, *DO,
	*KE, *KS, *MB, *MD, *ME, *MR, *ND, *NL, *SE, *SO, *SR,
	*TI, *TE, *UE, *UP, *US, *MAL, *MDL;
 
putchar_x(c)
char c;
{
    putchar(c);
}

ttycbreak()
{
#ifdef SYSV
    ioctl(0, TCGETA, &oldtermio);
    ioctl(0, TCGETA, &newtermio);
    newtermio.c_oflag=0;
    newtermio.c_lflag &= ~(ICANON|ECHO);
    newtermio.c_cc[4] = 1;	/* at least 1 char */
    newtermio.c_cc[5] = -1;	/* wait for ever? */
    ioctl(0, TCSETA, &newtermio);
#else
    ioctl(0, TIOCGETP, &newb);
    newb.sg_flags |= RAW;
    newb.sg_flags &= ~(ECHO);
    ioctl(0, TIOCSETP, &newb);
#endif


    signal(SIGINT,SIG_IGN);
    signal(SIGQUIT,SIG_IGN);	/* */
}


/* gettermtype - Finds terminal type and reads termcap entry for it.
 */
gettermtype()
{
char tptr[1024];
char *termtyp;
char *tbufptr;

    termtyp=getenv("TERM");
    switch(tgetent(tptr,termtyp)) {
	case -1:
	    printf("Can't read termcap\n");
	    exit(1);
	case 0:
	    printf("Can't find your terminal type (%s) in termcap\n", termtyp);
	    exit(1);
    }
    tbufptr=tbuf;
    AL = tgetstr("al", &tbufptr);
    BC = tgetstr("bc", &tbufptr);
    BL = tgetstr("bl", &tbufptr);
    if (!BL)
	BL = "\007";
    BS = tgetflag("bs",&tbufptr);
    if (!BC && BS)
	BC = "\b";
    CD = tgetstr("cd", &tbufptr);
    CL = tgetstr("cl", &tbufptr);
    CE = tgetstr("ce", &tbufptr);
    CM = tgetstr("cm", &tbufptr);
    CR = tgetstr("cr", &tbufptr);
    if (!CR)
	CR = "\r";
    CS = tgetstr("cs", &tbufptr);
    DL = tgetstr("dl", &tbufptr);
    DO = tgetstr("do", &tbufptr);
    if (!DO)
	DO = "\n";
    KE = tgetstr("ke", &tbufptr);
    KS = tgetstr("ks", &tbufptr);
    MB = tgetstr("mb", &tbufptr);
    ME = tgetstr("me", &tbufptr);
    MR = tgetstr("mr", &tbufptr);
    ND = tgetstr("nd", &tbufptr);
    NL = tgetstr("nl", &tbufptr);
    if (!NL)
	NL = "\n";
    SO = tgetstr("so", &tbufptr);
    SE = tgetstr("se", &tbufptr);
    SR = tgetstr("sr", &tbufptr);
    TI = tgetstr("ti", &tbufptr);
    TE = tgetstr("te", &tbufptr);
    UE = tgetstr("ue", &tbufptr);
    UP = tgetstr("up", &tbufptr);
    US = tgetstr("us", &tbufptr);
    MAL = tgetstr("AL", &tbufptr);
    MDL = tgetstr("DL", &tbufptr);
    CO = tgetnum("co");
    LI = tgetnum("li");
    if(!TI) {
	    TI = tgetstr("vs", &tbufptr);
	    TE = tgetstr("ve", &tbufptr);
    }

    if (CO < 80 || LI < 24) {
	printf("Sorry, but vtem requires 24 by 80 lines.\r\n");
	exit(1);
    }
    if (!CM) {
	printf("Sorry, but vtem requires cursor motion capability (cm).\r\n");
	exit(1);
    }
    if (!CL) {
	printf("Sorry, but vtem requires clear screen capability (cl).\r\n");
	exit(1);
    }
    if (!UP) {
	printf("Sorry, but vtem requires cursor up capability (up).\r\n");
	exit(1);
    }
}

setup_term(flg)			/* If flg==TRUE, set line in cbreak mode and */
Bool flg;			/* initialize the terminal,otherwise restore */
{
    if (flg) {
	ttycbreak();
	if (TI)
	    tputs_x(TI);	/* start CM mode */
    }
    else {
	if (KE)
	    tputs_x(KE);	/* Restores Keypad */
	if (TE)
	    tputs_x(TE);	/* exit CM mode */
#ifndef SYSV
	ioctl(0, TIOCSETP, &oldb);
#else
        ioctl(0, TCSETA, &oldtermio);
#endif
    }
}

/* clear_bos - clear from beginning of screen to cursor
 */
clear_bos(c,r)
int c,r;
{
register int i;

    for (i=0; i<r; i++) {
	tputs_x(tgoto(CM, 0, i));
	tputs_x(CE);
    }
    clear_bol(c,r);
}

/* clear_eos - Clear from cursor to end of screen.
 */
clear_eos()
{
    tputs_x(CD);
}

/* clear_bol - Clear from beginning of line to cursor.
 */
clear_bol(c,r)
int c,r;
{
register int i;

    tputs_x(tgoto(CM, 0, r));
    for (i=0; i<c; i++)
	putchar(' ');
}

/* clear_eol - Clear from cursor to end of line.
 */
clear_eol(c, r)
int c, r;
{
register int i;

    if (CE)
	tputs_x(CE);
    else {
	for (i=c; i < ((r==23)?79:80); i++)
	    putchar(' ');
	set_cursor(c, r);
    }
}


cursor_up()
{
    tputs_x(UP); 
}


cursor_down()
{
    tputs_x(DO); 
}


cursor_right()
{
    tputs_x(ND); 
}


reverse_lf()
{
    cursor_up();		/* We hope */
}


/* start_reverse - Set terminal in reverse video mode.
 */
start_reverse()
{
    if (MR)
	tputs_x(MR);
    else
	tputs_x(SO);
}


start_blink()
{
    tputs_x(MB);
}


start_underline()
{
    tputs_x(US);
}


start_bold()
{
    if (MD)
	tputs_x(MD);
    else
	tputs_x(SO);
}


ring_bell()
{
    tputs_x(BL);
}



scroll_region(lin1, lin2, upward)      /* Scroll region between lin1 and */
int lin1, lin2;			       /* lin2 inclusive one line up or down */
{
    /* Use scroll region if available - otherwise use insert/delete line*/
    if (CS && SR) {
	tputs_x(tgoto(CS,lin2,lin1));
	if (upward) {
	    set_cursor(0,lin2);
	    tputs_x(NL);
	}
	else {
	    set_cursor(0,lin1);
	    tputs_x(SR);
	}
	tputs_x(tgoto(CS,23,0));
    }
    else if (DL && AL) {
	if (upward) {
	    set_cursor(0,lin1);
	    tputs_x(DL);
	    set_cursor(0,lin2);
	    tputs_x(AL);
	}
	else {
	    set_cursor(0,lin2);
	    tputs_x(DL);
	    set_cursor(0,lin1);
	    tputs_x(AL);
	}
    }
}


/* The following are routines for VT102 compatibility
 */

do_insert_line()
{
tputs_x(AL);
}

do_delete_line()
{
tputs_x(DL);
}

/* end_attributes - Reset terminal attributes to normal.
 */
end_attributes()
{
    if (ME) {
	tputs_x(ME);
        if ( shiftit )
           tputs_x("\016");
    }
    else {
	tputs_x(SE);
	tputs_x(UE);
    }
}
