/*
 * vt - A termcap driven VT100 emulator for BSD Unix
 *
 * Version 2.0
 *
 * Public domain software.
 * Written by Leif Samuelsson (leif@erisun) in December, 1985
 * 
 * 
 * 
 * Modified to handle alternate character set and for SYS-5 by
 * Muhammad S. Benten
 * University of Colorado
 * Boulder.
 * December, 1988
 * 
 */

#include "vtem.h"
extern int shiftit;
typedef Bool int;

static int	row, col, save_row, save_col, top_margin, bottom_margin;
static Bool	blink, bold, reverse, underline, save_blink, save_bold,
		save_reverse, save_underline, origin_mode, vt52_mode, wrap;

static short tabs[80];
static int arg[10], argno;

/* arow is absolute row, taking top_margin into account */
#define arow	(row + (origin_mode ? (top_margin - 1) : 0))


/* nextch - read output and interpret control characters.
 *	    Return first non-control character.
 */
int nextch()
{
	register char ch; /* */
/* register int ch; /* */

    /* while ((ch = getc(stdin)) != EOF) {	/* */
    while(1) { ch = nextchar(); /* */
	switch (ch) {
	    case '\177':
	    case '\0':
		    break;
	    case '\007':		/* Bell */
		ring_bell(); break;
	    case '\b':			/* BackSpace */
		    if (col > 1) {
			col--;
			backspace();
		    } break;
	    case '\t':			/* Tab */
		while (col < 80 && (tabs[col++] == 0) );
		set_cursor(col-1, arow-1); break;

	    case '\n':			/* Line Feed */
		    do_linefeed(); break;
	    case '\r':			/* Carriage Return */
		if (col > 1) {
		    col = 1;
		    cr();
		} break;
	    case '\016':		/* Ignore shift in/out */
		     shiftit=1;
		    putchar(ch);
	        break;
	    case '\017':
		     shiftit=0;
		    putchar(ch);
	        break;
	    default:
		    return(ch);
	}
	if (stdin->_cnt == 0)
	    fflush(stdout);
    }
    return(ch);
}
int next_cnt = -1;
int next_end = 0;
char next_buffer[BUFSIZ];

nextchar()
{
	int ret, rfd;

	next_cnt++;
	if(next_cnt == next_end) { /* need to read */
		rfd = 1; /* stdin */
		/* current select doesn't work on pipes */
		/* ret = select(8, &rfd, 0, 0, 0); /* */
		next_end = read(0, next_buffer, BUFSIZ);
		next_cnt = 0;
	}
	/* have some already */
	return(next_buffer[next_cnt]);
}
		

/* handle_output - Main loop of output process.
 *		   Reads and dispatches characters from output stream.
 */
handle_output()
{
register int ch;

    gettermtype();
    do_reset();
    while ((ch = nextch()) != EOF) {
	if (ch == '\033') {		/* Escape character */
	    if (vt52_mode)
		do_vt52_escape();
	    else
		do_ansi_escape();
	}
	else if (ch >= ' ') {		/* Printing character */
	    if (col == 81) {
		if (wrap) {
		    col = 1;
		    set_cursor(col-1, arow-1);
		    do_linefeed();
		}
		else {
		    col = 80;
		    set_cursor(col-1, arow-1);
		}
	    }
	    if (col == 80) {
		if (arow != 24)
		    putchar(ch);	/* Must ignore last pos */
		set_cursor(col-1, arow-1);
		if (wrap)
		    col++;
	    }
	    else {
		putchar(ch);
		col++;
	    }
	}
	if (stdin->_cnt == 0)
	    fflush(stdout);
    }
    exit(0);
}

/* do_ansi_escape - reads and interprets an ANSI escape sequence
 */

do_ansi_escape()
{
register int ch;

    if ((ch = nextch()) == EOF)
	return;
    switch (ch) {
	case '#':
	    do_hash();
	    break;
	case '(':
	    do_character_sets(0); break;
	case ')':
	    do_character_sets(1); break;
	case '7':
	    save_row = row;
	    save_col = col;
	    save_blink = blink;
	    save_bold = bold;
	    save_reverse = reverse;
	    save_underline = underline;
	    break;
	case '8':
	    if (save_row > 0) {
		row = save_row;
		col = save_col;
		set_cursor(col-1, arow-1);
		if (blink = save_blink)
		    start_blink();
		if (bold = save_bold)
		    start_bold();
		if (reverse = save_reverse)
		    start_reverse();
		if (underline = save_underline)
		    start_underline();
	    } break;

	case 'D':
	    do_linefeed(); break;

	case 'E':
	    if (col > 1) {
		col = 1;
		cr();
	    }
	    do_linefeed(); break;

	case 'H':
	    tabs[col-1] = 1; break;

	case 'M':
	    do_reverse_lf(); break;

	case '[':
	    do_csi(); break;

	case 'c':
	    do_reset(); break;
    }
}

/* do_csi - the real ANSI interpreter
 */
do_csi()
{
register int i, ch;
int private;

    if ((ch = nextch()) == EOF)
	return;

    /* Check if private VT100 esc sequence */
    private = 0;
    if (ch == '?') {
	private++;
	if ((ch = nextch()) == EOF)
	    return;
    }

    /* Parse arguments */
    argno = 0;
    while ((ch >= '0' && ch <= '9') || ch == ';') {
	arg[argno] = 0;
	while (ch >= '0' && ch <= '9') {
	    arg[argno] = arg[argno] * 10 + (ch - '0');
	    if ((ch = nextch()) == EOF)
		return;
	}
	if (ch == ';')
	    if ((ch = nextch()) == EOF)
		return;
	argno++;
    }

    if (private) {
	if (argno != 1)
	    return;
	switch (ch) {
	    case 'h':
		switch (arg[0]) {
		    case 6:
			origin_mode++; break;
		    case 7:
			wrap++; break;
		} break;
	    case 'l':
		switch (arg[0]) {
		    case 2:
			vt52_mode = 1; break;
		    case 6:
			origin_mode = 0; break;
		    case 7:
			wrap = 0; break;
		} break;
	}
    }
    else {
	switch (ch) {
	    case 'A':
		i = (argno == 1 && arg[0] > 0) ? arg[0] : 1;
		while (i-- && row > 1) {
		    cursor_up();
		    row--;
		} break;

	    case 'B':
		i = (argno == 1 && arg[0] > 0) ? arg[0] : 1;
		while (i-- && row < bottom_margin-top_margin+1) {
		    cursor_down();
		    row++;
		} break;

	    case 'C':
		i = (argno == 1 && arg[0] > 0) ? arg[0] : 1;
		while (i-- && col < 80) {
		    cursor_right();
		    col++;
		} break;

	    case 'D':
		i = (argno == 1 && arg[0] > 0) ? arg[0] : 1;
		while (i-- && col > 1) {
		    backspace();
		    col--;
		} break;

	    case 'H':
	    case 'f':
		do_set_cursor(); break;
	    case 'J':
		do_erase_in_display(); break;
	    case 'K':
		do_erase_in_line(); break;
	    case 'L':
		do_insert_line(); break;
	    case 'M':
		do_delete_line(); break;
	    case 'g':
	        do_clear_tabs(); break;
	    case 'm':
		do_attributes(); break;
	    case 'r':
		do_set_scroll_region();
	}
    }
}

/* do_vt52_escape - interprets VT52 escape sequences
 */
do_vt52_escape()
{
register int ch;

    if ((ch = nextch()) == EOF)
	return;
    switch (ch) {
	case '<':
		vt52_mode = 0; break;
	case 'A':
		if (row > 1) {
		    cursor_up();
		    row--;
		} break;
	case 'B':
		if (row < bottom_margin-top_margin+1) {
		    cursor_down();
		    row++;
		} break;
	case 'C':
		if (col < 80) {
		    cursor_right();
		    col++;
		} break;
	case 'D':
		if (col > 1) {
		    backspace();
		    col--;
		} break;
	case 'H':
		row = col = 1;
		set_cursor(col-1, arow-1); break;
	case 'I':
		do_reverse_lf(); break;
	case 'J':
		clear_eos(); break;
	case 'K':
		clear_eol(col-1, arow-1); break;
	case 'Y':
		do_vt52_set_cursor(); break;
    }
}


do_set_cursor()
{
    if (arg[0] == 0)
	arg[0]++;
    if (arg[1] == 0)
	arg[1]++;
    switch (argno) {
	case 0:
	    arg[0] = 1;
	    argno++;
	    /* Fall through */

	case 1:
	    arg[1] = 1;		/* Correct? */
	    argno++;
	    /* Fall through... */

	case 2:
	    row = arg[0];
	    col = arg[1];
	    set_cursor(col-1, arow-1);
	    break;
    }
}

do_vt52_set_cursor()
{
register int ch1, ch2;

    if ((ch1 = nextch()) == EOF)
	return;
    if ((ch2 = nextch()) == EOF)
	return;
    ch1 -= 0x1f;
    ch2 -= 0x1f;
    if (ch1 >= 1 && ch1 <= 24 && ch2 >= 1 && ch2 <= 80) {
	    row = ch1;
	    col = ch2;
	    set_cursor(col-1, arow-1);
    }
}

do_erase_in_display()
{
    switch (argno) {
	case 0:
	    arg[0] = 0;
	    argno++;
	    /* Fall through */
	case 1:
	    switch (arg[0]) {
		case 0:
		    clear_eos();
		    break;
		case 1:
		    clear_bos(col-1, arow-1);
		    break;
		case 2:
		    clear_screen();
		    set_cursor(col-1, arow-1);
		    break;
	    }
	    break;
    }
}

do_erase_in_line()
{
    switch(argno) {
	case 0:
	    arg[0] = 0;
	    argno++;
	    /* fall through */
	case 1:
	    switch (arg[0]) {
		case 0:
		    clear_eol(col-1, arow-1);
		    break;
		case 1:
		    clear_bol(col-1, arow-1);
		    break;
		case 2:
		    cr();
		    clear_eol(0, arow-1);
		    set_cursor(col-1, arow-1);
		    break;
	    } break;
    }
}

do_clear_tabs()
{
register int i;

    if (argno == 0)
	arg[argno++] = 0;
    switch (arg[0]) {
	case 0:
	    tabs[col-1] = 0; break;
	case 3:
	    for (i = 0; i<80; i++)
		tabs[i] = 0; break;
    } 
}

do_attributes()
{
register int i;

    if (argno == 0) {
	arg[0] = 0;
	argno++;
    }
    for (i=0; i<argno; i++) {
	switch (arg[i]) {
	    case 0:
		end_attributes();
		bold = underline = blink = reverse = 0;
		break;
	    case 1:
		start_bold();
		bold++; break;

	    case 4:
		start_underline();
		underline++; break;

	    case 5:
		start_blink();
		blink++; break;

	    case 7:
		start_reverse();
		reverse++; break;
	}
    }
}

do_set_scroll_region()
{
    if (arg[0] == 0)
	arg[0]++;
    if (arg[1] == 0)
	arg[1]++;
    switch (argno) {
	case 0:
	    arg[0] = 1;
	    arg[1] = 24;
	    argno = 2;
	    /* Fall through */

	case 2:
	    top_margin = arg[0];
	    bottom_margin = arg[1];
	    col = row = 1;
	    set_cursor(col-1, arow-1);
	    break;
    }
}

do_linefeed()
{
    if (arow == bottom_margin) {
	    scroll_region(top_margin-1, bottom_margin-1, TRUE);
	    set_cursor(col-1, arow-1);
    }
    else if (arow < 24) {
	row++;
	linefeed();
    }
}

do_reverse_lf()
{
    if (arow == top_margin) {
	scroll_region(top_margin-1, bottom_margin-1, FALSE);
	set_cursor(col-1, arow-1);
    }
    else if (arow > 1) {
	row--;
	reverse_lf();
    }
}

do_hash()
{
register int ch, i, j;

    if ((ch = nextch()) == EOF)
	return;
    switch(ch) {
	case '8':
	    for (i=1; i<=24; i++) {
		set_cursor(0, i-1);
		for (j=1; j <= ((i==24)?79:80); j++)
		    putchar('E');
	    }
	    row = col = 1;
	    set_cursor(col-1, arow-1);		/* Correct? */
	    break;
    }		 
}
# ifdef UNIXPC
#include <sys/window.h>
#define UK	"/usr/lib/wfont/UK.ft"
#define US	"/usr/lib/wfont/system.8.ft"
#define LD	"/usr/lib/wfont/SCLD.ft"
#define RC	"/usr/lib/wfont/ROMC.ft"
#define RG	"/usr/lib/wfont/ROMG.ft"
#endif
/* do_characters_sets - Not implemented
 */
do_character_sets(slot)
int slot;
{
#ifdef UNIXPC
char ch;
struct {
         short uf_slot;
         char uf_name[60];
       } ufdata;

    sprintf(ufdata.uf_name,US);
    ufdata.uf_slot = 0;
    ch = nextch();			/* Ignore for now */
    switch(ch) {
         case 'A':
		sprintf(ufdata.uf_name,UK);
		ufdata.uf_slot = slot;
                break;
         case 'B':
		sprintf(ufdata.uf_name,US);
		ufdata.uf_slot = slot;
                break;
         case '0':
		sprintf(ufdata.uf_name,LD);
		ufdata.uf_slot = slot;
                break;
         case '1':
		sprintf(ufdata.uf_name,RC);
		ufdata.uf_slot = slot;
                break;
         case '2':
		sprintf(ufdata.uf_name,RG);
		ufdata.uf_slot = slot;
                break;
               }
         ioctl(1,WIOCLFONT,&ufdata);
#endif
}

/* do_reset - Reset emulator and screen
 */
do_reset()
{
register int i;

    clear_screen();
    row = 1;
    col = 1;
    top_margin = 1;
    bottom_margin = 24;
    origin_mode = 0;
    vt52_mode = 0;
    wrap = 1;
    save_row = -1;			/* So we know we haven't saved */
    for (i=0; i<80; i++)
	if  ((i/8)*8 == i)
	    tabs[i] =1;
        else
	    tabs[i] =0;
}
