/*
 *	@(#)socketvar.h	1.1	(Alex Crain)	6/20/89
 *
 *  socketvar.h - socket related definitions
 *
 *  Written by Alex Crain.
 *
 *  This file is loosly based in the Berkeley header file of the 
 *  same name, but is *not* guarenteed to be in any way compatable. It is
 *  close enough to the berkeley code that the following applies...
 *
 *  Copyright (c) 1982, 1986, 1988 Regents of the University of California.
 *  All rights reserved.
 * 
 *  Redistribution and use in source and binary forms are permitted
 *  provided that this notice is preserved and that due credit is given
 *  to the University of California at Berkeley. The name of the University
 *  may not be used to endorse or promote products derived from this
 *  software without specific prior written permission. This software
 *  is provided "as is" without express or implied warranty.
 *
 */

#ifndef _socketvar_h_
#define _socketvar_h_

#include <uipc/conf.h>

/*
 *  structure describing a socket.
 */

typedef ushort socketptr;

struct socket {
   short	so_type;
   short	so_options;
   short	so_linger;
   short	so_state;
   caddr_t	so_pcb;
   struct	protosw * so_proto;

   struct	socket * so_head;
   struct	socket * so_q0;
   struct	socket * so_q;
   short	so_q0len;
   short	so_qlen;
   short	so_qlimit;
   short	so_timeo;
   ushort	so_error;
   short	so_pgrp;
   u_long	so_oobmark;

   struct	sockbuf {
      u_long	sb_cc;
      u_long	sb_hiwat;
      u_long	sb_mbcnt;
      u_long	sb_mbmax;
      u_long	sb_lowat;
      struct	mbuf * sb_mb;
      struct	proc * sb_sel;
      short	sb_timeo;
      short	sb_flags;
   } so_rcv, so_snd;

#define SB_MAX		(64 * 1024)
#define SB_LOCK		0x01
#define SB_WANT		0x02
#define SB_WAIT		0x04
#define SB_SEL		0x08
#ifdef notdef
#define SB_COLL		0x10
#endif
};

/*
 *  Socket states
 */
#define SS_NOFDREF		0x001
#define SS_ISCONNECTED		0x002
#define SS_ISCONNECTING		0x004
#define SS_ISDISCONNECTING	0x008
#define SS_CANTSENDMORE		0x010
#define SS_CANTRCVMORE		0x020
#define SS_RCVATMARK		0x040

#define SS_PRIV			0x080
#define SS_NBIO			0x100
#define SS_ASYNC		0x200

/*
 *  Socket macros
 */
   
#define sbspace(sb) \
 (MIN ((long) ((sb)->sb_hiwat - (sb)->sb_cc), \
       (long) ((sb)->sb_mbmax - (sb)->sb_mbcnt)))

#define sendallatonce(so) \
 ((so)->so_proto->pr_flags & PR_ATOMIC)

#define soreadable(so) \
 ((so)->so_rcv.sb_cc || ((so)->so_state & SS_CANTRCVMORE) || \
  (so)->so_qlen || (so)->so_error)

#define sowriteable(so) \
 (sbspace (&(so)->so_snd) > 0 && \
  (((so)->so_state & SS_ISCONNECTED) || \
   ((so)->so_proto->pr_flags & PR_CONNREQUIRED) == 0) || \
  ((so)->so_state & SS_CANTSENDMORE) || \
  (so)->so_error)

#define sballoc(sb, m) \
{  (sb)->sb_cc += (m)->m_len; \
   (sb)->sb_mbcnt += MSIZE; }

#define sbfree(sb, m) \
{  (sb)->sb_cc -= (m)->m_len; \
   (sb)->sb_mbcnt -= MSIZE; }

#define sblock(sb) \
{   while ((sb)->sb_flags & SB_LOCK) \
     {  (sb)->sb_flags |= SB_WANT; \
	 (void) sleep ((caddr_t) &(sb)->sb_flags, PZERO+1); } \
    (sb)->sb_flags |= SB_LOCK; }

#define sbunlock(sb) \
{  (sb)->sb_flags &= ~SB_LOCK; \
   if ((sb)->sb_flags & SB_WANT) \
    {  (sb)->sb_flags &= ~SB_WANT; \
       wakeup ((caddr_t) &(sb)->sb_flags); }}

#define sorwakeup(so)	sowakeup (so, &(so)->so_rcv)
#define sowwakeup(so)	sowakeup (so, &(so)->so_snd)

#ifdef KERNEL
#ifdef __STDC__
struct socket * sonewconn (struct socket *);
#else  /* __STDC__ */
struct socket * sonewconn ();
#endif /* __STDC__ */
#endif KERNAL

#endif /* _socketvar_h_ */
