/*
 *	@(#)fproto.h	1.1	(Alex Crain)	6/20/89
 *
 *  fproto.h - function prototypes for uipc driver.
 *
 *  Written by Alex Crain.
 *
 *  This file contains ANSI function prototypes for the entire uipc 
 *  package and many of the existing system entry points. The prototypes 
 *  are blocked within a "#ifdef __STDC__" construct, the with an alternate
 *  "#else" block of old-style function declarations.
 */

#ifndef _fproto_h_
#define _fproto_h_

#ifdef __STDC__
/*
 *  Declarations from debug.c
 */

void dump_mbuf (struct mbuf *m);

/*
 *  Declarations from domain.c
 */

void domaininit (void);
struct protosw *pffindtype (int family, int type);
struct protosw *pffindproto (int family, int protocol, int type);

/*
 *  Declarations from interface.c
 */

void uipcinit (void);
void dosyscall(void);
int uipcrelease (void);
void uipc_write (void);
void uipc_read (void);
void uipc_close (off_t sp);
void bzero (char *s, int n);
int ufavail (void);

/*
 *  Declarations from mbuf.c
 */

void mbinit(void);
struct mbuf *m_get (int canwait, int type);
struct mbuf *m_getclr (int canwait, int type);
struct mbuf *m_free (struct mbuf *m);
struct mbuf *m_more (int canwait, int type);
void m_freem (struct mbuf *m);
struct mbuf *m_copy (struct mbuf *m, int off, int len);

/*
 *  Declarations from socket.c
 */

int socreate (int domain, struct socket ** sop, int type, int proto);
int sobind (struct socket *so, struct mbuf *nam);
int solisten (struct socket *so, int backlog);
void sofree (struct socket *so);
int soclose (struct socket *so);
int soabort (struct socket *so);
int soaccept (struct socket *so, struct mbuf *nam);
int soconnect (struct socket *so, struct mbuf *nam);
int soconnect2 (struct socket *so1, struct socket *so2);
int sodisconnect (struct socket *so);
int sosend (struct socket *so, struct mbuf *nam, int flags, struct mbuf *rights);
int soreceive (struct socket *so, struct mbuf **nam, int flags, struct mbuf **rights);
void sorflush (struct socket *so);
int sosetopt (struct socket *so, int level, int optname, struct mbuf *m0);
int sogetopt (struct socket *so, int level, int optname, struct mbuf **mp);
void sohasoutofband (struct socket *so);

/*
 *  Declarations from socket2.c
 */


void soisconnecting (struct socket *so);
void soisconnected (struct socket *so);
void soisdisconnecting (struct socket *so);
void soisdisconnected (struct socket *so);
struct socket *sonewconn (struct socket *head);
void soinsque (struct socket *head, struct socket *so, int q);
int soqremque (struct socket *so, int q);
void socantsendmore (struct socket *so);
void socantrcvmore (struct socket *so);
void sbselqueue (struct sockbuf *sb);
void sbwait (struct sockbuf *sb);
void sbwakeup (struct sockbuf *sb);
void sowakeup (struct socket *so, struct sockbuf *sb);
int soreserve (struct socket *so, int sndcc, int rcvcc);
int sbreserve (struct sockbuf *sb, int cc);
void sbrelease (struct sockbuf *sb);
void sbappend (struct sockbuf *sb, struct mbuf *m);
void sbappendrecord (struct sockbuf *sb, struct mbuf *m0);
int sbappendaddr (struct sockbuf *sb, struct sockaddr *asa, struct mbuf *m0, struct mbuf *rights0);
int sbappendrights (struct sockbuf *sb, struct mbuf *m0, struct mbuf *rights);
void sbcompress (struct sockbuf *sb, struct mbuf *m, struct mbuf *n);
void sbflush (struct sockbuf *sb);
void sbdrop (struct sockbuf *sb, int len);
void sbdroprecord (struct sockbuf *sb);

/*
 *  Declarations from syscalls.c
 */

void socket (void);
void bind (void);
void listen (void);
void accept (void);
void connect (void);
void socketpair (void);
void sendto (void);
void send (void);
void sendmsg (void);
void sendit (int s, struct msghdr * mp, int flags);
void recvfrom (void);
void recv (void);
void recvmsg (void);
void recvit (int s, struct msghdr * mp, int flags, caddr_t np, caddr_t rp);
void setsockopt (void);
void getsockopt (void);
void sockpipe (void);
void getsockname (void);
int sockargs (struct mbuf **aname, caddr_t name, int namelen, int type);
struct file *getsock (int fd);

/*
 *  Declarations from usrreq.c
 */

int uipc_usrreq (struct socket *so, int req, struct mbuf *m, struct mbuf *nam, struct mbuf *rights);
int unp_attach (struct socket *so);
void unp_detach (struct unpcb *unp);
int unp_bind (struct unpcb *unp, struct mbuf *nam);
int unp_connect (struct socket *so, struct mbuf *nam);
int unp_connect2 (struct socket *so1, struct socket *so2);
void unp_disconnect (struct unpcb *unp);
void unp_usrclosed (struct unpcb *unp);
void unp_drop (struct unpcb *unp, int errno);
int unp_externalize (struct mbuf *rights);
int unp_internalize (struct mbuf *rights);
void unp_gc (void);
void unp_dispose (struct mbuf *m);
void unp_scan (struct mbuf *m0, int (*op)());
void unp_mark (struct file *fp);
void unp_discard (struct file *fp);

/*
 *  declarations left out of systm.h
 */

int suser (void);
int fuword (int * addr);
int useracc (caddr_t address, int length, int flag);

short spl7 (void);
short spl6 (void);
short spl5 (void);
short spl4 (void);
short spl3 (void);
short spl2 (void);
short spl1 (void);
short splx (short sp);

int sleep (caddr_t addr, int p);
int wakeup (caddr_t addr);
void signal (int pgrp, int sig);
void psignal (struct proc * p, int sig);
int setjmp (label_t env);
void longjmp (label_t env, int val);

void panic (caddr_t msg);
void printf();
void eprintf();

int access (struct inode * ip, int mode);
extern struct inode * iget ();
void iput (struct inode * ip);
void prele (struct inode * ip);
int ufalloc (int fp);
void closef (struct file * fp);
void locsys ();

#else ! __STDC__

/*
 *  Declarations from debug.c
 */

void dump_mbuf ();

/*
 *  Declarations from domain.c
 */

void domaininit ();
struct protosw *pffindtype ();
struct protosw *pffindproto ();

/*
 *  Declarations from interface.c
 */

void uipcinit ();
void dosyscall();
int uipcrelease ();
void uipc_write ();
void uipc_read ();
void uipc_close ();
void bzero ();
int ufavail ();

/*
 *  Declarations from mbuf.c
 */

void mbinit();
struct mbuf *m_get ();
struct mbuf *m_getclr ();
struct mbuf *m_free ();
struct mbuf *m_more ();
void m_freem ();
struct mbuf *m_copy ();

/*
 *  Declarations from socket.c
 */

int socreate ();
int sobind ();
int solisten ();
void sofree ();
int soclose ();
int soabort ();
int soaccept ();
int soconnect ();
int soconnect2 ();
int sodisconnect ();
int sosend ();
int soreceive ();
void sorflush ();
int sosetopt ();
int sogetopt ();
void sohasoutofband ();

/*
 *  Declarations from socket2.c
 */


void soisconnecting ();
void soisconnected ();
void soisdisconnecting ();
void soisdisconnected ();
struct socket *sonewconn ();
void soinsque ();
int soqremque ();
void socantsendmore ();
void socantrcvmore ();
void sbselqueue ();
void sbwait ();
void sbwakeup ();
void sowakeup ();
int soreserve ();
int sbreserve ();
void sbrelease ();
void sbappend ();
void sbappendrecord ();
int sbappendaddr ();
int sbappendrights ();
void sbcompress ();
void sbflush ();
void sbdrop ();
void sbdroprecord ();

/*
 *  Declarations from syscalls.c
 */

void socket ();
void bind ();
void listen ();
void accept ();
void connect ();
void socketpair ();
void sockpipe ();
void getsockname ();
int sockargs ();
struct file *getsock ();

/*
 *  Declarations from usrreq.c
 */

int uipc_usrreq ();
int unp_attach ();
void unp_detach ();
int unp_bind ();
int unp_connect ();
int unp_connect2 ();
void unp_disconnect ();
void unp_usrclosed ();
int unp_drop ();
int unp_externalize ();
int unp_internalize ();
void unp_gc ();
void unp_dispose ();
void unp_scan ();
void unp_mark ();
void unp_discard ();

/*
 *  declarations left out of systm.h
 */

short spl7 ();
short spl6 ();
short spl5 ();
short spl4 ();
short spl3 ();
short spl2 ();
short spl1 ();
short splx ();

int sleep ();
int wakeup ();

void panic ();
void eprintf();
void signal ();
void psignal ();

int setjmp ();
void longjmp ();

int suser ();

#endif __STDC__
#endif _fproto_h_
