/*
 *	@(#)domain.h	1.1	(Alex Crain)	6/20/89
 *
 *  domain.h - domain stucture definitions.
 *
 *  Written by Alex Crain.
 *
 *  This file is based in the Berkeley header file of the same
 *  name, but is *not* guarenteed to be in any way compatable. It is
 *  close enough to the berkeley code that the following applies...
 *
 *  Copyright (c) 1982, 1986, 1988 Regents of the University of California.
 *  All rights reserved.
 * 
 *  Redistribution and use in source and binary forms are permitted
 *  provided that this notice is preserved and that due credit is given
 *  to the University of California at Berkeley. The name of the University
 *  may not be used to endorse or promote products derived from this
 *  software without specific prior written permission. This software
 *  is provided "as is" without express or implied warranty.
 *
 */

#ifndef _domain_h_
#define _domain_h_

#include <uipc/conf.h>

struct domain {
   int 		dom_family;
   char 	* dom_name;
   int		(* dom_init) ();
   int		(* dom_externalize) ();
   int		(* dom_dispose) ();
   struct	protosw * dom_protosw, * dom_protoswNPROTOSW;
   struct 	domain * dom_next;
};

#ifdef KERNEL
struct domain * domains;
#endif

#endif _domain_h_
