/*
**  USEFUL.H -- Some useful stuff.
**
**	@(#)useful.h	4.2		10/22/87
*/

# ifndef makedev
# include <sys/types.h>
# endif

/* support for bool type */
typedef char	bool;
# define TRUE	1
# define FALSE	0

# ifndef NULL
# define NULL	0
# endif NULL

/* bit hacking */
# define bitset(bit, word)	(((word) & (bit)) != 0)

/* some simple functions */
# ifndef max
# define max(a, b)	((a) > (b) ? (a) : (b))
# define min(a, b)	((a) < (b) ? (a) : (b))
# endif max

/* assertions */
# ifndef NASSERT
# define ASSERT(expr, msg, parm)\
	if (!(expr))\
	{\
		fprintf(stderr, "assertion botch: %s:%d: ", __FILE__, __LINE__);\
		fprintf(stderr, msg, parm);\
	}
# else NASSERT
# define ASSERT(expr, msg, parm)
# endif NASSERT

/* sccs id's */
# ifndef lint
# define SCCSID(arg)	static char SccsId[] = "arg";
# else lint
# define SCCSID(arg)
# endif lint

#ifdef	UNIXPC
typedef unsigned short	u_short;
typedef unsigned long	u_long;
typedef unsigned char	u_char;
#define rindex		strrchr
#define index		strchr
#define bcopy(s,d,l)	memcpy(d,s,l)
#define bzero(p,l)	memset(p,'\0',l)
#define sleep		zsleep
#define message		zmessage
#endif

/* define the types of some common functions */
extern char	*strcpy(), *strncpy();
extern char	*strcat(), *strncat();
extern char	*malloc();
extern char	*index(), *rindex();
extern int	errno;
extern time_t	time();
extern char	*ctime();
# ifndef V6
extern char	*getenv();
# endif V6
# ifndef VMUNIX
#ifndef USG
typedef unsigned short	u_short;
typedef long		u_long;
typedef char		u_char;
typedef int		void;
#endif
# endif VMUNIX
