/*
  kernal.h - interesting kernal addresses from various header files.

  This file is probably extremly dependant on the OS version. As distributed
  is was created from the 3.51 header files. I did my best to be accurate, but
  there may be typos (i did check).

  If you are running some other version than 3.51, you can either

	a) define symboltab_TABLE_SIZE as 0 (not use the table)
	b) use this file and hope for the best
	c) painstakingly peruse user.h and the hardware headers (hardware.h
	and iohw.h) to verify that all the numbers are correct. Its doubtful
	that u will be found anywhere but 0x70000 in any OS version, so it
	basicaly means counting the offsets.

  If anyone does (c) for any version, please drop me a note either confirming
  that these numbers are correct or noting the differences so as to save 
  others this pain. Posting to the net might be nice, too.

*/

#define specialtab_TABLE_SIZE 142

struct symbol specialtab[] = {
   {0x70000, "VPG_BASE"},
   {0x70900, "u.u_rsav"},
   {0x70934, "u.u_qsav"},
   {0x70968, "u.u_ssav"},
   {0x7099C, "u.u_segflg"},
   {0x7099D, "u.u_error"},
   {0x7099E, "u.u_uid"},
   {0x709A0, "u.u_gid"},
   {0x709A2, "u.u_ruid"},
   {0x709A4, "u.u_rgid"},
   {0x709A6, "u.u_procp"},
   {0x709AA, "u.u_ap"},
   {0x709AE, "u.u_rval1"},
   {0x709B2, "u.u_rval2"},
   {0x709B6, "u.u_base"},
   {0x709BA, "u.u_count"},
   {0x709BE, "u.u_offset"},
   {0x709C2, "u.u_fmode"},
   {0x709C4, "u.u_pbsize"},
   {0x709C6, "u.u_pboff"},
   {0x709C8, "u.u_pbdev"},
   {0x709CA, "u.u_rablock"},
   {0x709CE, "u.u_errcnt"},
   {0x709D0, "u.u_cdir"},
   {0x709D4, "u.u_rdir"},
   {0x709D8, "u.u_dirp"},
   {0x709DC, "u.u_dent.d_ino"},
   {0x709DE, "u.u_dent.d_name"},
   {0x707EC, "u.u_pdir"},
   {0x709F0, "u.u_ofile"},
   {0x709F4, "u.u_pofile"},
   {0x709f8, "u.FillerYUK"},
   {0x70A54, "u.u_arg"},
   {0x70A7C, "u_tsize"},
   {0x70A80, "u_dsize"},
   {0x70A84, "u_ssize"},
   {0x70A88, "u_lsize"},
   {0x70A8C, "u.u_signal"},
   {0x70B0C, "u.u_utime"},
   {0x70B10, "u.u_stime"},
   {0x70B14, "u.u_cutime"},
   {0x70B18, "u.u_cstime"},
   {0x70B1C, "u.u_ar0"},
   {0x70B20, "u.u_prof.pr_base"},
   {0x70B24, "u.u_prof.pr_size"},
   {0x70B28, "u.u_prof.pr_off"},
   {0x70B2C, "u.u_prof.pr_scale"},
   {0x70B30, "u.u_ttyp"},
   {0x70B34, "u.u_ttyd"},
   {0x70B36, "u.u_exdata.ux_mag"},
   {0x70B38, "u.u_exdata.ux_stamp"},
   {0x70B3A, "u.u_exdata.ux_tsize"},
   {0x70B3E, "u.u_exdata.ux_dsize"},
   {0x70B42, "u.u_exdata.ux_bsize"},
   {0x70B46, "u.u_exdata.ux_ssize"},
   {0x70B4A, "u.u_exdata.ux_entloc"},
   {0x70B4E, "u.u_exdata.ux_unused"},
   {0x70B52, "u.u_exdata.ux_relflag"},
   {0x70B56, "u.u_xlsize"},
   {0x70B5A, "u.u_comm"},
   {0x70B68, "u.u_start"},
   {0x70B6C, "u.u_ticks"},
   {0x70B70, "u.u_mem"},
   {0x70B74, "u.u_ior"},
   {0x70B78, "u.u_iow"},
   {0x70B7C, "u.u_iosw"},
   {0x70B80, "u.u_ioch"},
   {0x70B84, "u.u_acflag"},
   {0x70B86, "u.u_cmask"},
   {0x70B88, "u.u_limit"},
   {0x70B90, "u.u_limit[LIM_NORAISE]"},
   {0x70B90, "u.u_limit[LIM_FSIZE]"},
   {0x70B90, "u.u_limit[LIM_CPU]"},
   {0x70B90, "u.u_limit[LIM_DATA]"},
   {0x70B90, "u.u_limit[LIM_STACK]"},
   {0x70B90, "u.u_limit[LIM_CORE]"},
   {0x70B90, "u.u_limit[LIM_MAXRSS]"},
   {0x70ba4, "u.u_dmap"},
   {0x70bca, "u.u_smap"},
   {0x70bf0, "u.u_cdmap"},
   {0x70C16, "u.u_csmap"},
   {0x70C3C, "u.u_outtime"},
   {0x70C40, "u.u_usize"},
   {0x70C42, "u.u_lock"},
   {0x70E00, "VPTE_BASE"},
   {0x400000, "PG_BASE"},
   {0x4000C0, "DMA_MAP"},
   {0x4000DC, "DMA_UPTR"},
   {0x4000E0, "UPTE"},
   {0x400100, "USER_MAP"},
   {0x400600, "MAP_TOP"},
   {0x410000, "GSR_ADDR"},
   {0x420000, "VIDMEM"},	
   {0x430000, "BUS0_ADDR"},
   {0x440000, "BUS1_ADDR"},
   {0x450000, "PHONE_STATUS"},
   {0x460000, "DMA_CNT"},
   {0x470000, "LP_STATUS_ADDR"},
   {0x480000, "RTC_WRITE_ADDRESS"},
   {0x490000, "HNDSET_RELAY"},
   {0x491000, "LINE_SELECT"},
   {0x492000, "HOOK1_RELAY"},
   {0x493000, "HOOK2_RELAY"},
   {0x494000, "LINE1_ACTIVE"},
   {0x495000, "LINE2_ACTIVE"},
   {0x496000, "A_LEAD1_RELAY"},
   {0x497000, "A_LEAD2_RELAY"},
   {0x4A0000, "MCR_ADDR"},
   {0x4B0000, "A_BAUD_ADDR"},
   {0x4B0400, "DIALER_LOWER"},
   {0x4B0800, "DIALER_HIGHER"},
   {0x4C0000, "CSR_ADDR"},
   {0x4D0000, "DMA_LOADDR"},
   {0x4D4000, "DMA_HIADDR"},
   {0x4E0000, "DISK_CNTRL"},
   {0x4f0000, "LP_DATA_ADDR"},
   {0xE00000, "HD_BASE"},
   {0xE10000, "FD_BASE"},
   {0xE20000, "MCR2_ADDR"},
   {0xE30000, "RTC_READ_ADDDR"},
   {0xE40000, "SYSERR_GCR_ADDR"},
   {0xE41000, "PE_INT_GCR_ADDR"},
   {0xE42000, "PE_FRC_GCR_ADDR"},
   {0xE43000, "ROM_GCR_ADDR"},
   {0xE44000, "L1MD_GCR_ADDR"},
   {0xE45000, "L2MD_GCR_ADDR"},
   {0xE46000, "DNCT_GCR_ADDR"},
   {0xE50000, "A_DATA_ADDR"},
   {0xE50002, "B_DATA_ADDR"},
   {0xE50004, "A_CMND_ADDR"},
   {0xE50006, "B_CMND_ADDR"},
   {0xE60000, "SCM_0W_Control"},
   {0xE61000, "SCM_1W_Control"},
   {0xE62000, "SCM_2R_Control"},
   {0xE63000, "SCM_3R_Control"},
   {0xE64000, "SCM_4W_Control"},
   {0xE65000, "SCM_5W_Control"},
   {0xE66000, "SCM_6W_Control"},
   {0xE68000, "SCM_8W_Control"},
   {0xE69000, "SCM_9W_Control"},
   {0xE6A000, "SCM_10R_Control"},
   {0xE70000, "C_CMND_ADDR"},
   {0xE70002, "C_DATA_ADDR"},
   {0x7fffffff, "CDLIMIT"},
};
