/*
  *  constant.c - lookup constant values from shared libraries or kernel 
  *	addresses
  *
  */
 
#include "unc.h"
 
 struct symbol {
    int address;
    char * name;
 };

/*
 *  Lookup shared library symbols. For symbol addresses between 0x300000 and
 *  0x380000, return either the shlib symbol or an offset from the nearest
 *  one. For other addresses, return NULL.
 */

#include "shlib.h"

char *
 lookup_address(n)
long int n;
{
   struct symbol * lo = symtab,
   * hi = &symtab[symtab_TABLE_SIZE-1],
   * mid;
   char * new;
   
   if (n < 0x300000 || n > 0x380000)
    return (char *) 0;
   
   while (lo <= hi)
    {
       mid = lo + (hi - lo)/2;
       if (n == mid->address)
	return mid->name;
       else if (n > mid->address)
	lo = mid + 1;
       else
	hi = mid - 1;
    }
   mid = (hi > lo ? lo : hi);
   new = malloc ((unsigned) strlen (mid->name) + 10);
   (void) sprintf(new, "%s+0x%x", mid->name, n - mid->address);
   return new;
}

/*
 *  Lookup kernel symbols. This is a two stage process, first we search the
 *  generated table from unix.sym, then our special, hand crafted, table. If
 *  we still can't find te address, we generate a string in the form of an
 *  offset from its nearest cousin in unix.sym.
 */

#include "unix.h"
#include "kspecial.h"

char *
 lookup_kernel_address(n)
long int n;
{
   struct symbol * lo = unixtab,
   * hi = &unixtab[unixtab_TABLE_SIZE-1],
   * mid, * last;
   char * new;
   
   while (lo <= hi)
    {
       mid = lo + (hi - lo)/2;
       if (n == mid->address)
	return mid->name;
       else if (n > mid->address)
	lo = mid + 1;
       else
	hi = mid - 1;
    }
   last = (hi > lo ? lo : hi);
   
   lo = specialtab;
   hi = &specialtab[specialtab_TABLE_SIZE-1];
   while (lo <= hi)
    {
       mid = lo + (hi - lo)/2;
       if (n == mid->address)
	return mid->name;
       else if (n > mid->address)
	lo = mid + 1;
       else
	hi = mid - 1;
    }
   
   if (n < 0 || n >= 0x80000)
    return (char *) 0;
   
   new = malloc ((unsigned) strlen (last->name) + 12);
   (void) sprintf(new, "%s+0x%x", last->name, n - last->address);
   return new;
}

