/********************************************************/
/*							*/
/*	ro.h		General header file for ro	*/
/*							*/
/*	ro version 1.00					*/
/*							*/
/*	Portions copyright (c) 1989 by Ted A. Campbell	*/
/*		Bywater Software			*/
/*		P. O. Box 4023				*/
/*		Duke Station				*/
/*		Durham, NC  27706			*/
/*							*/
/*	Contains portions of ROFF4, Version 1.60	*/
/*      (c) 1983, 4 by Ernest E. Bergmann               */
/*		Physics, Building #16			*/
/*		Lehigh University			*/
/*		Bethlehem, Pa. 18015			*/
/*							*/
/*	Contains portions of ROFF4, Version 1.61	*/
/*      (c) 1985 by Konrad Kwok                         */
/*		20 3rd Street, Section M		*/
/*		Fariview Park,				*/
/*		Hong Kong				*/
/*							*/
/*	ro and its predecessor ROFF4 are based on 	*/
/*	the ROFF text processor described in Kernigan	*/
/*	and Plauger's now-classic text <Software Tools> */
/*							*/
/* Permission is hereby granted for all commercial and	*/
/* Non-commercial reproduction and distribution of this */
/* Material provided this notice is included.		*/
/*							*/
/********************************************************/

/************* INCLUDE FILES ****************************/

#include "stdio.h"
#include "ctype.h"
#include "time.h"

#ifdef __STDC__
#include "stdlib.h"
#include "malloc.h"
#else
#define size_t  int
#define time_t  long
#endif

/****** PROGRAM DEFINITIONS *****************************/

/***	User-Definable Options ***/

#define NONROFF			/* allow non-nroff-standard features */

/***	End of User-Definable Options ***/

#define	ro_	X		/* shorten names for limited compilers */

#define MAXLINE 255
#define TRUE 1
#define FALSE 0
#define ERROR (-1)
#define OK 0

#define	TBUFSIZE	4096	/* Size of temporary holding buffer */
#define BACKSIZE        4096	/* Size of backup buffer */
#define STKSIZ          4
#define DEBUG           ( debug != 0 )
#define HUGE            135	/* generally large number */
#define LSZ             511	/* line buffer size */
#define COMMAND         '.'	/* all commands starts with this */

#define UNKNOWN         -1	/* returned if doesn't recg. command */
#define NO_VAL          -32760	/* returned when no argument w/commad */
#define WE_HAVE_A_WORD   1	/* returned by getwrd func. */
#define NO              0
#define YES             1
#define UNDERLINE       '\137'

/***	Character Definitions */

#define CR              0x0D
#define BACKSPACE       '\b'
#define BELL    	'\007'
#define NUMSIGN         '#'	/* for title strings */
#define NEWLINE         '\n'
#define TAB             '\t'
#define BLANK           ' '
#define FORMF           0x0C	/* formfeed for printer */
#define	ESCAPE		0x1b	/* escape character */
#define SQUOTE          0x27	/* single quote */
#define DQUOTE          0x22	/* double quote */
#define	BACKSLASH	0x5c	/* backslash */
#define	PASSBACK	0xeee	/* a random large number to pass a literal
			 * backslash back into the input stream */

/**	Single-character printer code designations ***/

#define	ROMAN		'R'	/* Restore "roman" or "regular" font */
 /* Should turn off Bold and Italic */
#define	ITALIC		'I'	/* Switch to italics or underline */
#define	BOLD		'B'	/* Switch to bold */
#define	HALFUP		'u'	/* Half-line up */
#define	HALFDOWN	'd'	/* Half-line down */

#define TRANSLATE 	2	/* May 23, 1983 */
#define BLACK 		1
#define WHITE 		0
#define CONTROL 	-1
#define SENTINEL 	-2
#define HTAB    	-3
#define OTHERS 		-4
#define XCHAR 		'-'
#define UCHAR 		'_'

/* Defaults for global parameters */

#define FI_DEF          1
#define LS_DEF          1
#define IN_DEF          0
#define RM_DEF          70
#define TI_DEF          0
#define CE_DEF          1
#define UL_DEF          -1
#define M1_DEF          2
#define M2_DEF          2
#define M3_DEF          2
#define M4_DEF          2
#define PL_DEF          66
#define FF_DEF          YES	/* .ff defaults to "on" */
#define FF_INI          NO	/* initial setting */
#define SC_INI          BLANK
#define TS_DEF          8	/* standard tabsize */
#define TC_DEF          '~'	/* translation flag default */
#define CF_DEF          '^'	/* Dec 4 */
#define IC_DEF          '\\'
#define CW_DEF          12	/* 12/120" */
#define JU_INI          YES	/* right adjust (justification) */
#define	PO_DEF		0	/* page offset */
#define REGDEF          0	/* default for register var. */
 /* When .rg has no numeric arg */

#define REVSCROLL       FALSE
#define CANBS           FALSE

#define FMAX            8	/* # of additional files open */

/* Defaults for global parameters */

#define FI_DEF          1
#define LS_DEF          1
#define IN_DEF          0
#define RM_DEF          70
#define TI_DEF          0
#define CE_DEF          1
#define UL_DEF          -1
#define M1_DEF          2
#define M2_DEF          2
#define M3_DEF          2
#define M4_DEF          2
#define PL_DEF          66
#define FF_DEF          YES	/* .ff defaults to "on" */
#define FF_INI          NO	/* initial setting */
#define SC_INI          BLANK
#define TS_DEF          8	/* standard tabsize */
#define TC_DEF          '~'	/* translation flag default */
#define CF_DEF          '^'	/* Dec 4 */
#define IC_DEF          '\\'
#define CW_DEF          12	/* 12/120" */
#define JU_INI          YES	/* right justification */
#define REGDEF          0	/* default for register var. */
 /* When .rg has no numeric arg */

#define REVSCROLL       FALSE
#define CANBS           FALSE

#define FMAX            8	/* # of additional files open */

#define FI              1	/* fill lines */
#define TI              2	/* temporary indent */
#define BP              3	/* begin page  */
#define BR              4	/* causes break */
#define CE              5	/* center line(s) */
#define IN              7	/* left indent */
#define LS              8	/* line spacing */
#define NF              9	/* no fill */
#define PL              10	/* set page length */
#define LL              11	/* set line length (right margin) */
#define SP              12	/* add blank line(s) */
#define ST              13	/* stop(pause) at page start? */
#define FO              14	/* footer title */
#define HE              15	/* header title */
#define M1              16	/* top margin */
#define M2              17	/* second top margin */
#define M3              18	/* first bottom margin */
#define M4              19	/* bottom-most margin       */
#define IG              20	/* "ignore";comments,Nov 6,82 */
#define NE              21	/* "need";Nov 7,82 */
#define FF              22	/* "formfeed";Nov 10 */
#define SC              23	/* "space character";Nov13 */
#define TA              25	/* "tabsize";Nov 13 */
#define EH              26	/* "even headers";Nov 14 */
#define OH              27	/* "odd headers" */
#define EF              28	/* "even footers" */
#define OF              29	/* "odd footers" */
#define EX              30	/* exit ("abort") */
#define DB              31	/* "debug" */
#define TC              32	/* "translation flag char" */
#define TR              33	/* "def translation string" */
#define CF              34	/* Dec 4:control flag char */
#define IC              35	/* insert character */
#define AD              37	/* adjust (justify) output lines */
#define NA              38	/* no adjust of output lines */
#define WH              39	/* whole line spacing code */
#define FR              40	/* fractional spacing,code */
#define DS              41	/* define string */
#define DE              42	/* define macro */
#define EM              43	/* end macro */
#define NR              44	/* register variable */
#define DI              45	/* diversion */
#define SO              47	/* "source", include */
#define PC              48	/* printer control definition */
#define TM              49	/* send inline msg to terminal */
#define BJ              50	/* break with right justification of current
			 * line */
#define	PM		51	/* print macro names */
#define	FT		52	/* set font */
#define	PO		53	/* page offset */
#define SS              54	/* show strings */
#define SR              55	/* show registers */

/****** GLOBAL VARIABLES ********************************/

/* Defines for short names conflicts */
#define ro_outbuf ro_obuf
#define ro_outwrds ro_owrds
#define ro_lastch ro_endch
#define ro_mcnt2 ro_2mcnt
#define ro_firstpage ro_1page

PUBLIC FILE *_dobuf, *instream;	/* i/o buffer used for direction  */
PUBLIC int debug;		/* Boolean:  debug mode on/off */
PUBLIC int ro_verbose;		/* Boolean:  verbose mode on/off */
PUBLIC int ro_pagestop;
PUBLIC int ro_adjust;
PUBLIC int ro_useff;
PUBLIC int ro_firstpage, ro_lastpage;	/* for selectively printing output */
PUBLIC int ro_suppress;		/* if true,no output is passed by putchar() */
PUBLIC int ro_tival;		/* temporary indent -> default  0 */
PUBLIC int ro_ceval;		/* set equal to number of lines to be
			 * centered  */
PUBLIC int ro_spval;		/* blank lines to be spaced down */
PUBLIC int ro_curpag;		/* current output page number; init = 0 */
PUBLIC int ro_newpag;		/* next output page number; init = 1 */
PUBLIC int ro_vlineno;		/* virtual (intended) line advances on page,
			 * see vadv() */
PUBLIC int ro_vflineno;		/* + line fraction */
PUBLIC int ro_plineno;		/* printer's actual line advances on page,
			 * see padv() */
PUBLIC int ro_pflineno;		/* + line fraction */
PUBLIC int ro_bottom;		/* end of text area in lines;start of M3+M4 */
PUBLIC int ro_sentence;		/* Nov 20 */
PUBLIC int ro_poval;		/* page offset */

/***	Stack variables

  The following variables are assigned to a stack and when
  a new value is assigned, it is "pushed" onto the stack,
  and when read, "popped" off.  The stack is read from
  the bottom.  						***/

PUBLIC int ro_fill[STKSIZ];	/* set to YES or NO  */
PUBLIC int ro_lsval[STKSIZ];	/* line spacing value -> default will be 1  */
PUBLIC int ro_inval[STKSIZ];	/* left indent -> default  0  */
PUBLIC int ro_rmval[STKSIZ];	/* right margin -> default  PAGEWIDTH  */
PUBLIC int ro_tcval[STKSIZ];	/* translation flag char  */
PUBLIC int ro_plval[STKSIZ];	/* page length in lines  */
PUBLIC int ro_m1val[STKSIZ];	/* margin before& including header in lines */
PUBLIC int ro_m2val[STKSIZ];	/* margin after header in lines */
PUBLIC int ro_m3val[STKSIZ];	/* margin after last text line in lines */
PUBLIC int ro_m4val[STKSIZ];	/* bottom margin, including footer in lines */
PUBLIC int ro_scval[STKSIZ];	/* space character  */
PUBLIC int ro_tabsiz[STKSIZ];	/* spacing of tabstops  */
PUBLIC int ro_cfval[STKSIZ];	/* Dec 4:control flag character value  */
PUBLIC int ro_icval[STKSIZ];	/* insert character */

PUBLIC char ro_curline[LSZ];	/* input line buffer, Nov 26 */
PUBLIC char ro_ehead[LSZ], ro_eh2[LSZ], ro_eh3[LSZ];	/* even header title  */
PUBLIC char ro_ohead[LSZ], ro_oh2[LSZ], ro_oh3[LSZ];	/* odd header title  */
PUBLIC char ro_efoot[LSZ], ro_ef2[LSZ], ro_ef3[LSZ];	/* even footer title  */
PUBLIC char ro_ofoot[LSZ], ro_of2[LSZ], ro_of3[LSZ];	/* even footer title  */

PUBLIC struct divfd {		/* diversion file descriptor	 */
  char nm[36];			/* name  */
  char fn[64];			/* name of diversion file (not source file) */
  int cs;			/* character count  */
  int ls;			/* line count  */
  int val;			/* value for register  */
  char *mstr;			/* pointer to macro character string  */
  FILE *bf;			/* to instream if open, FALSE otherwise  */
  struct divfd *prev;
};

PUBLIC char tbuf[TBUFSIZE];	/* a temporary buffer */
PUBLIC int ro_dir;		/* for "spreading" of lines     */
PUBLIC int ro_outwrds;		/* no. words in ro_outbuf; init = 0  */
PUBLIC char ro_outbuf[LSZ];	/* lines to be filled collected here  */
PUBLIC int ro_outw;		/* current display width of ro_outbuf */
PUBLIC int ro_outpos;		/* =strlen(ro_outbuf)  */
PUBLIC int ro_wtop, ro_ltop, ro_outtop;	/* zero|negative;levels of subscripts */
PUBLIC int ro_wbot, ro_lbot, ro_outbot;	/* zero|positive;levels of subscripts */
PUBLIC int ro_oldln;		/* position of previous main line */
PUBLIC int ro_oldbot;		/* ro_outbot for previous line;reset each
			 * page */
PUBLIC int ro_frq, ro_frval;	/* fractional line?, what fraction size */
PUBLIC char *ro_frstring;	/* ^ to code for fractional spacing */
PUBLIC char *ro_whstring;	/* ^ to code for whole line spacing */
PUBLIC char *ro_cptr[128 - ' '];/* pointer table for print control */
PUBLIC char *ro_tptr[128 - ' '];/* pointer table for translation strings for
			 * char; initialize to null  */

PUBLIC struct divfd *dlink;	/* points to head of diversion list  */
PUBLIC struct divfd *rlink;	/* points to head of register variable list  */
PUBLIC struct divfd *slink;	/* points to head of linked string list  */
PUBLIC struct divfd *mlink;	/* points to head of linked macro list  */

/*following added for buffered and formatted output:   */

PUBLIC char ro_out2buf[LSZ];	/* for line to be output in fancy fmt */
PUBLIC int ro_bpos, ro_cp, ro_pp;	/* buffer,column,printer positions */
PUBLIC char ro_xbuf[LSZ];	/* strikout buffer */
PUBLIC int ro_xf, ro_xcol;	/* " flag and column  */
PUBLIC char ro_ubuf[LSZ];	/* underline buffer */
PUBLIC int ro_uf, ro_ucol;	/* " flag and column  */
PUBLIC int ro_first;		/* flag for first pass */
PUBLIC char ro_dbuf[LSZ];	/* double strike buffer */
PUBLIC int ro_dpos;
PUBLIC int ro_ocnt;
PUBLIC int ro_mcnt;
PUBLIC int ro_blkcnt;

PUBLIC int ro_newxf, ro_newuf, ro_newmcnt;	/* 3rd Mar,85 ; Conrad Kwok  */
PUBLIC char ro_lastch;		/* 5th Mar,85  ;  Conrad Kwok  */

PUBLIC char ro_backbuf[BACKSIZE];	/* Backup buffer  */
PUBLIC int ro_binp;		/* Position in above;init to 0  */
PUBLIC char ro_keybd;		/* boolean & prompt for keyboard input */
PUBLIC char ro_kline[MAXLINE];	/* keyboard line input buffer */
PUBLIC char *ro_kptr;		/* pointer for above */

PUBLIC int ro_fptr;
PUBLIC FILE *ro_fstack[FMAX];
PUBLIC int ro_tflag;		/* added for start(), complete() */
PUBLIC int ro_xf2, ro_uf2, ro_mcnt2;

/****** DECLARATIONS FOR EXTERNAL FUNCTIONS ************ */

/*      Declarations of externals
 *
 *
 */

#ifndef __STDC__
extern char *malloc();
#endif
extern char *macq();
extern struct divfd *find2();
extern char ro_getch();

/******** END OF FILE ***********************************/
