/* width.c - computes width of a string in a given font and size 
   Attention: in some lines, XPOS means the x position times 10.  This is
   ugly code, but faster and smaller than flaoting point arithmetic.
   It is necessary, because the resolution of one point is not enough.
*/

#include <stdio.h>

#define WIDTH_C

#include "mroff.h"

public int width(s) unsigned char *s;
{
  int state,w,winc,noinc;
  
  state=0; w=0; noinc=0;
  while (*s)
  {
    switch (state)
    {
      case 0:
      {
        if (*s==CCVAL) { winc=0; state=1; }
        else winc = *(widths+*s-' ');
        break;
      }
      case 1:
      {
	switch (*s)
	{
	  case '\\': winc= *(widths+'\\'-' '); state=0; break;
	  case 'e': winc= *(widths+CCVAL-' '); state=0; break;
	  case ' ': winc= *(widths+' '-' '); state=0; break;
	  case '0': winc= *(widths+'0'-' '); state=0; break;
	  case '|': winc=PSVAL/6; state=0; break;
	  case '^': winc=PSVAL/12; break;
	  case '&': winc=0; break;
	  case '\'': winc= *(widths+'\''-' '); break;
	  case '`': winc= *(widths+'`'-' '); break;
	  case '-': winc= *(widths+MINUS-' '); break;
	  case 'z': noinc=2; winc=0; break;
	  case '%': winc= *(widths+'-'-' '); break;
	  case '"': winc=0; *--s='\0'; s--; break;
	  case 't':
	  {
	    winc=(ADVAL=='l' || ((ADVAL=='b' || ADVAL=='r') && !FILL) ? tabpos(XPOS+w)-XPOS-w : 0);
            break;
          }
          case 'f':
          {
            switch (*++s)
            {
              case 'R': pushvar(FONTVAL,&ftstack); changewidths(0); break;
              case 'B': pushvar(FONTVAL,&ftstack); changewidths(1); break;
              case 'I': pushvar(FONTVAL,&ftstack); changewidths(2); break;
              case 'S': pushvar(FONTVAL,&ftstack); changewidths(3); break;
              case 'P': changewidths(popvar(&ftstack)); break;
              case '0':
              case '1':
              case '2':
              case '3':
              case '4': pushvar(FONTVAL,&ftstack); changewidths(*s-'0'); break;
            }
            winc=0;
            break;
          }
          
          case 's' :
          {
            int n;
            char sign;
            
            sign=' '; n=0;
            if (*(s+1)=='+' || *(s+1)=='-') sign = *++s;
            while (*(s+1)<='9' && *(s+1)>='0') n=n*10+*++s-'0';
            n=(sign=='+' ? PSVAL+n : (sign=='-' ? PSVAL-n : n));
            if (n) pushvar(PSVAL,&psstack); else n=popvar(&psstack);
            setsize(n);
            winc=0;
            break;
          }
                   
          case '*' :	/* expand string variable */
          {
            unsigned char x,y,*h,*ins;
            
            ins=s-1;
            if (*++s=='(') { x = *++s; y = *++s; }
            else { x = *s; y = '\0'; }
            h=(unsigned char*)malloc(strlen(s+1)+1);
            strcpy(h,s+1);
            strcpy(ins,getstr(x,y));
            strcat(ins,h);
            free(h);
            s=ins-1;
            winc=0;
            break;
          }

          case '(' :	/* expand special character */
          {
            unsigned char x,y,*h,*ins;
            
            ins=s-1;
            x = *++s; y = *++s;
            h=(unsigned char*)malloc(strlen(s+1)+1);
            strcpy(h,s+1);
            strcpy(ins,specialchar(x,y));
            strcat(ins,h);
            free(h);
            s=ins-1;
            winc=0;
            break;
          }

          case 'n' :	/* expand numeric register */
          {
            unsigned char x,y,*h,*ins,inc;
            
            ins=s++-1;
            if (*s=='-' || *s=='+') inc = *s++; else inc=' ';
            if (*s=='(') { x = *++s; y = *++s; }
            else { x = *s; y = '\0'; }
            h=(unsigned char*)malloc(strlen(s+1)+1);
            strcpy(h,s+1);
            strcpy(ins,getnumreg(x,y,inc));
            strcat(ins,h);
            free(h);
            s=ins-1;
            winc=0;
            break;
          }

        }
        state=0;
        break;
      }
    }
    if (noinc) noinc--; else w+=winc;
    s++; 
  }
  return w;
}
