/* trap.c - processes traps and page breaks */

#include <stdio.h>

#define TRAP_C

#include "mroff.h"

public int CURPAG;
public int PLVAL;

/* the following part deals with position traps */

typedef struct
{
  char c1,c2;
  int pos;
  int invoked;
} POS_TRAP;

/* all traps are sorted by their position */
private POS_TRAP pos_trap[POS_TRAPNO];
private int no_pos_traps;

private void breakpage()
{
  int i;

  fprintf(outfp,"u\n");
  outfp=(selectpage(CURPAG) ? stdout : nullfp);
  vderase();
  /* each page is independent, important for -o option */
  putfont(FONTVAL);
  for (i=0; i<no_pos_traps; i++) pos_trap[i].invoked=FALSE;
  YPOS=PSVAL;
}

public void checkpos()
{
  int i;
  char *ln=".??";

  i=0;
  while (i<no_pos_traps && pos_trap[i].pos<YPOS+VSVAL && pos_trap[i].invoked) i++;
  if (i!=no_pos_traps && pos_trap[i].pos<YPOS+VSVAL)
  {
    ln[1]=pos_trap[i].c1; ln[2]=pos_trap[i].c2;
    pos_trap[i].invoked=TRUE;
    execmac(ln);
    i++;
  }
  if (YPOS>=PLVAL) { CURPAG++; breakpage(); }
}

/* .ne n */
public void need(s) char *s;
{
  int i,pos,ne;

  s+=3;
  while (*s==' ') s++;
  ne=posarg(s,'v',0);
  if (pos==INVALID || pos==NOVALUE) mrofferror("invalid distance","",0,USERERROR);
  i=0;
  while (i<no_pos_traps && (pos_trap[i].pos<YPOS+VSVAL || pos_trap[i].invoked)) i++;
  if (i==no_pos_traps) pos=PLVAL; else pos=pos_trap[i].pos;
  if (pos-YPOS<ne) YPOS=pos;
  checkpos();
}

private void add_pos_trap(pos,x,y) int pos; char x,y;
{
  int i,j;

  if (no_pos_traps==POS_TRAPNO) mrofferror("too many position traps","",
  0,INTERNALERROR);
  i=0; while (i<no_pos_traps && pos_trap[i].pos<=pos) i++;
  for (j = ++no_pos_traps; j>i; j--) pos_trap[j]=pos_trap[j-1];
  pos_trap[i].pos=pos; pos_trap[i].c1=x; pos_trap[i].c2=y;
  pos_trap[i].invoked=FALSE;
}

/* .wh N x{y} */
public void trappos(s) char *s;
{
  char x,y;
  int pos;
  
  s+=3;
  while (*s==' ') s++;
  pos=posarg(s,'v',PLVAL);
  if (pos==INVALID || pos==NOVALUE) mrofferror("no implemented","",0,USERERROR);
  while (*s && *s!=' ') s++;
  while (*s==' ') s++;  
  if ((x = *s++)=='\0') mrofferror("no trap name","",0,0);
  else
  {
    y = *s++; if (y==' ') y='\0';
    while (*s==' ') s++;
    add_pos_trap(pos,x,y);
  }
}

/* .bp n */
public void dopagebreak(s) char *s;
{
  int pg;

  if (*s!=C2VAL) dobreak();
  pg=numarg(s,CURPAG);
  if (pg!=NOVALUE && pg<1) mrofferror("invalid page number",s,0,0);
  else
  {
    if (pg!=NOVALUE && pg>=1) CURPAG=pg; else CURPAG++;
    breakpage();
  }
}

/* .pl n */
public void pagelength(s) char *s;
{
  int pl;
  
  pl=posarg(s+3,'v',PLVAL);
  if (pl==INVALID || pl<72) mrofferror("unvalid page length",s,0,1);
  PLVAL=pl;
}

private char ENDMACRO[4];

/* .em x{y} */
public void endmacro(s) char *s;
{
  char x,y;
  int pos;
  
  s+=3;
  while (*s==' ') s++;
  if (*s) sprintf(ENDMACRO,".%c%c",*s,*(s+1)); else *ENDMACRO='\0';
}

public void doend()
{
  /* do no position traps after end of input reached */
  no_pos_traps=0;
  if (*ENDMACRO) execmac(ENDMACRO);
}

/* The following code deals with input line traps */

typedef struct
{
  char c1,c2;
  int line;
} IN_TRAP;

private IN_TRAP in_trap;

private void add_in_trap(x,y,li) char x,y; int li;
{
  in_trap.c1=x; in_trap.c2=y; in_trap.line=li;
}

public void checkin()
{
  char *ln=".??";
  
  if (in_trap.c1)
  {
    if (in_trap.line==1)
    {
      ln[1]=in_trap.c1;
      ln[2]=in_trap.c2;
      execmac(ln);
      in_trap.c1='\0';
    }
    else in_trap.line--;
  }
}

/* .it N x{y} */
public void trapin(s) char *s;
{
  char x,y;
  int pos;
  
  pos=numarg(s,0);
  if (pos==INVALID || pos==NOVALUE) mrofferror("not implemented","",0,USERERROR);
  s+=3;
  while (*s==' ') s++;
  while (*s && *s!=' ') s++;
  while (*s==' ') s++;  
  if ((x = *s++)=='\0') mrofferror("no input trap name","",0,0);
  else
  {
    y = *s++;
    add_in_trap(x,y,pos);
  }
}

public void trap_init()
{
  CURPAG=1;
  PLVAL=756; /* 10.5 inch */
  no_pos_traps=0;
  in_trap.c1='\0';
  *ENDMACRO='\0';
}
