/* string.c - make, expand and remove string variables */

#include <stdio.h>

#define STRING_C

#include "mroff.h"

typedef struct
{
  char c1,c2;
  char *str;
} STRING;

private STRING strings[STRINGNO];

/* .ds x str   or .ds xy str   with optional doublequote */
public void defstr(s) char *s;
{
  STRING *look;
  char x,y;
  int num=0;
  
  s+=3;
  while (*s==' ') s++;
  if ((x = *s++)=='\0') { mrofferror("no string name","",0,0); return; }
  if (*s!=' ' && *s!='\t') y = *s++; else y='\0';
  while (*s==' ') s++;
  if (*s=='"') s++;
  look=strings;
  while (num<STRINGNO && look->c1!='\0')
  {
    /* release old contents for redefing a string variable */
    if (look->c1==x && look->c2==y) { free(look->str); break; }
    look++; num++;
  }
  if (num==STRINGNO) mrofferror("no more space for string variables",s,
  0,INTERNALERROR);
  look->c1=x; look->c2=y;
  look->str=(char*)malloc(strlen(s)+1);
  strcpy(look->str,s);
}

public char *getstr(x,y) char x,y;
{
  STRING *look;
  int num=0;
  
  look=strings;
  while (num<STRINGNO && (look->c1!=x || look->c2!=y)) { look++; num++; }
  if (num==STRINGNO) return "";
  return look->str;
}

public void string_init()
{
  int i;
  
  for (i=0; i<STRINGNO; i++)
  {
    strings[i].c1=strings[i].c2='\0';
    strings[i].str=NULL;
  }
}
