/* stack.c - handels stack variables like needed for .in or .ft */

#include <stdio.h>

#define STACK_C

#include "mroff.h"

/* Initialize a stack variable, so that a following pop always returns the
   initial value. */
public void initstack(val,stack) int val; STACK *stack;
{
  stack->stackptr=0;
  stack->entry[0]=val;
}

/* Push a value on the stack.  If there is not enough space, shift the
   oldest value out.  Maybe I should return an error for this situation
   but it never caused a problem in the first roff I wrote. */
public void pushvar(value,stack) int value; STACK *stack;
{
  int i;

  if (stack->stackptr==STACKSIZE-1)
  for (i=0; i<STACKSIZE-1; i++) stack->entry[i]=stack->entry[i+1];
  else (stack->stackptr)++;
  stack->entry[stack->stackptr]=value;
}

/* Pop a value from a stack.  The stack never will be empty.  popvar() always
   returns the oldest element in this situation. */
public int popvar(stack) STACK *stack;
{
  int val;

  val=stack->entry[stack->stackptr];
  if (stack->stackptr) (stack->stackptr)--;

  return val;
}
