/* special.c - processes requests for special characters */

#include <stdio.h>

#define SPECIAL_C

#include "mroff.h"

typedef struct
{
  char c1,c2,*s;
} SPECTAB;

private SPECTAB table[] =
{
  /* this characters are in all roman and italic fonts */
  'A', 'e', "\200",
  'a', 'e', "\201",
  'O', 'e', "\202",
  'o', 'e', "\203",
  'U', 'e', "\204",
  'u', 'e', "\205",
  's', 's', "\206",

  /* this characters are in the special/mathematic font */
  'd', 'e', "\\fS\041\\fP",
  'p', 'c', "\\fS\042\\fP",
  'b', 'u', "\\fS\043\\fP",
  'f', 's', "\\fS\044\\fP",
  'l', 'c', "\\fS\045\\fP",
  'c', 'i', "\\fS\046\\fP",
  's', 'r', "\\fS\047\\fP",
  'l', 'e', "\\fS\050\\fP",
  'r', 'e', "\\fS\051\\fP",
  'a', 's', "\\fS\052\\fP",
  '+', '-', "\\fS\053\\fP",
  '-', '+', "\\fS\054\\fP",
  'm', 'u', "\\fS\055\\fP",
  'd', 'o', "\\fS\056\\fP",
  'd', 'i', "\\fS\057\\fP",
  '!', '=', "\\fS\060\\fP",
  '=', '=', "\\fS\061\\fP",
  '<', '=', "\\fS\062\\fP",
  '>', '=', "\\fS\063\\fP",
  'p', 't', "\\fS\064\\fP",
  'a', 'p', "\\fS\065\\fP",
  's', 'b', "\\fS\066\\fP",
  'c', 'u', "\\fS\067\\fP",
  's', 'p', "\\fS\070\\fP",
  'c', 'a', "\\fS\071\\fP",
  'm', 'o', "\\fS\072\\fP",
  '-', '>', "\\fS\073\\fP",
  'u', 'a', "\\fS\074\\fP",
  '<', '-', "\\fS\075\\fP",
  'd', 'a', "\\fS\076\\fP",
  'i', 's', "\\fS\077\\fP",
  'i', 'c', "\\fS\100\\fP",
  'i', 'f', "\\fS\101\\fP",
  's', 'c', "\\fS\102\\fP",
  'd', 'g', "\\fS\103\\fP",
  'd', 'd', "\\fS\104\\fP",
  'e', 'x', "\\fS\105\\fP",
  'M', 'U', "\\fS\106\\fP",
  'S', 'U', "\\fS\107\\fP",
  
  '\0', '\0', "Z"
};

public char *specialchar(x,y) char x,y;
{
  SPECTAB *look;
  
  look=table;
  while (look->c1 && (look->c1!=x || look->c2!=y)) look++;
  return (look->s);
}

