/* request.c - process a request */

#include <stdio.h>

#define REQUEST_C

#include "mroff.h"

/* return one character as argument like needed dor .ad */
public char chararg(s) char *s;
{
  s+=3;
  while (*s==' ') s++;
  return *s;
}

public int numarg(s,def) char *s; int def;
{
  char *ln,sign;
  int v;

  expand(s);  
  sign=' ';
  s+=3;
  while (*s==' ') s++;
  ln=s;
  if (*s=='-' || *s=='+') sign = *s++;
  if (*s<='9' && *s>='0') v=atoi(ln); else return NOVALUE;
  if (sign=='+') return (def+v);
  else if (sign=='-') return (def-v);
  else return v;
}

/* read a position and return a value in dots */
public int posarg(s,dir,pos) char *s,dir; int pos;
{
  char sign;
  int a,c;
  
  expand(s);
  while (*s==' ') s++;
  sign = *s; if (sign=='-' || sign=='+') s++;
  a=0;
  if (*s<='9' && *s>='0') while (*s<='9' && *s>='0') a=a*10+*s++-'0';
  else if (*s=='\0') return NOVALUE; else return INVALID;
  c=1;
  if (*s=='.')
  {
    s++;
    while (*s<='9' && *s>='0') { a=a*10+*s++-'0'; c*=10; }
  }
  if (*s=='\0') *s=dir;
  switch (*s)
  {
    case 'i' : a=(int)(((long)a*72L)/(long)c); break;
    case 'p' : a=(int)((long)a/(long)c); break;
    case 'c' : a=(int)(((long)a*7200L)/((long)c*254L)); break;
    case 'P' : a=(int)(((long)a*12L)/(long)c); break;
    case 'm' : a=(int)(((long)a*(long)PSVAL)/(long)c); break;
    case 'n' : a=(int)(((long)a*(long)PSVAL)/(long)(2*c)); break;
    case 'v' : a=(int)(((long)a*(long)VSVAL)/(long)c); break;
    default : return INVALID;
  }
  if (sign=='+') return (pos+a);
  else if (sign=='-') return (pos-a);
  else return a;
}  

/* this is what we are doing with comments */
private void donothing()
{}

/* structure of one request entry in the request table */
typedef struct
{
  char id1,id2;
  void (*fun)(/* char *s; */);
} ENTRY;

private ENTRY reqtab[] =
{
  { 'b','r', dobreak },
  { 'n','f', nofill },
  { 'f','i', dofill },
  { 'a','d', adjust },
  { 'n','a', noadjust },
  { 'c','e', center },
  { 't','i', tempindent },
  { 'i','n', indent },
  { 's','p', dospace },
  { 'p','o', pageoffset },
  { 'v','s', vertspace },
  { 'l','s', linespace },
  { 'l','l', linelength },
  { 'r','m', rightmargin },
  { 't','l', title },
  { 't','a', dotab },
  { 't','c', dotc },
  { 'b','p', dopagebreak },
  { 'p','l', pagelength },
  { 'f','t', doft },
  { 'p','s', dops },
  { 'd','s', defstr },
  { 'n','r', defreg },
  { '\\','"', donothing },
  { 'd','e', dode },
  { 'w','h', trappos },
  { 'i','t', trapin },
  { 'e','m', endmacro },
  { 's','o', source },
  { 'm','k', mark },
  { 'r','t', markreturn },
  { 'i','f', doif },
  { 'n','e', need },
  { 'r','d', doread },
  { 'd','i', put2div },
  { '\0','\0', NULL }
};

public void request(s) char *s;
{
  ENTRY *search;
  
  search=reqtab;
  while (search->id1)
  {
    if (search->id1==s[1] && search->id2==s[2]) { (search->fun)(s); break; }
    search++;
  }
  if (search->id1=='\0') mrofferror("unknown request",s,0,0);
}
