/* numreg.c - deals width numeric registers */

#include <time.h>
#include <stdio.h>

#define NEMREG_C

#include "mroff.h"

/* user definable registers */
typedef struct
{
  char c1,c2;
  int format,value,inc;
} NUMREG;

private NUMREG numreg[NUMREGNO];

private NUMREG *findreg(x,y) char x,y;
{
  NUMREG *look;
  int num;
  
  look=numreg; num=0;
  while (num<NUMREGNO && (look->c1!=x || look->c2!=y)) { look++; num++; }
  return (num==NUMREGNO ? NULL : look);
}

private NUMREG *creatreg()
{
  NUMREG *look;
  int num;
  
  look=numreg; num=0;
  while (num<NUMREGNO && look->c1!='\0') { look++; num++; }
  if (num==NUMREGNO) mrofferror("no more space for number registers","",0,
  INTERNALERROR);
  return look;
}

/* .nr x{y} {+|-} value {autoincrement} */
public void defreg(s) char *s;
{
  char x,y,sign;
  int value,increment;
  NUMREG *num;
  
  s+=3;
  while (*s==' ') s++;
  if ((x = *s++)=='\0') { mrofferror("no registers name","",0,0); return; }
  if (*s!=' ' && *s!='\t') y = *s++; else y='\0';
  while (*s==' ') s++;
  width(s); /* expand calls of registers to their values */
  if (*s=='-' || *s=='+') sign = *s++; else sign=' ';
  if (*s<'0' || *s>'9') { mrofferror("no value",s,0,0); return; }
  value=atoi(s);
  while (*s>='0' && *s<='9') s++;
  while (*s==' ') s++;
  if (*s)
  {
    if (*s<'0' || *s>'9') { mrofferror("unvalid increment",s,0,0); return; }
    increment=atoi(s);
  }
  else increment=NOVALUE;
  if (num=findreg(x,y))
  {
    switch (sign)
    {
      case '+': num->value+=value; break;
      case '-': num->value-=value; break;
      default: num->value=value; break;
    }
    if (increment!=NOVALUE) num->inc=increment;
  }
  else
  {
    num=creatreg();
    num->c1=x; num->c2=y;
    num->value=value;
    num->inc=(increment==NOVALUE ? 1 : increment);
  }
}

typedef struct
{
  char c1,c2;
  int *value;
} READONLY;

private int month, year, weekday, monthday;

private READONLY readreg[] =
{
  { '%', '\0', &CURPAG },
  { 'm', 'o', &month },
  { 'y', 'r', &year },
  { 'd', 'w', &weekday },
  { 'd', 'y', &monthday },
  { '\0', '\0', NULL }
};

/* look for readonly numeric register variable */
private NUMREG *findvar(x,y) char x,y;
{
  static NUMREG num;
  READONLY *look;
  
  look=readreg;
  while (look->c1 && (look->c1!=x || look->c2!=y)) look++;
  if (look->c1)
  {
    num.c1=x; num.c2=y; num.inc=0; num.value = *(look->value);
    return &num;
  }
  else return NULL;
}

/* returns a string containing the registers contents in the specified
   format and increments registers if neccesary */
public char *getnumreg(x,y,doinc) char x,y; int doinc;
{
  static char numstr[10];
  NUMREG *num;
  
  /* warning: next line needs short circuit evaluation */
  if ((num=findreg(x,y)) || (num=findvar(x,y)))
  {
    sprintf(numstr,"%d",num->value);
    if (doinc=='+') (num->value) += (num->inc);
    else if (doinc=='-') (num->value) -= (num->inc);
    return numstr;
  }
  else
  {
    char n[3];
    
    n[0]=x; n[1]=y; n[2]='\0';
    mrofferror("undefined numeric register",n,0,0);
    return "";
  }
}

/* initialize this module */
public void numreg_init()
{
  int i;
  struct tm *t;
  time_t clock;
    
  for (i=0; i<NUMREGNO; i++) numreg[i].c1=numreg[i].c2='\0';
  clock=time(NULL);
  t=gmtime(&clock);
  month=t->tm_mon+1;
  year=t->tm_year;
  weekday=t->tm_wday+1;
  monthday=t->tm_mday;
}
