#include <local/bool.h>

#define private static
#define public

/* I use mmac because tmac is for MINIX nroff and the macro libraries are
   not compatible */
#define MACPATH "/usr/lib/mmac/mmac."
#define FONTPATH "/usr/lib/hfont/"

#define MAXLINE	4096		/* buffer size */
#define	COMMAND	'.'		/* all commands starts with this */
#define INVALID	(-32768)	/* unvalid argument */
#define NOVALUE (-32767)	/* no argument given */
#define MINUS 127		/* hyphen character code */

#define USERERROR 1		/* Exitcode caused by wrong parameters */
#define INTERNALERROR 4		/* Exitcode caused by internal error */

#define STACKSIZE 8
typedef struct
{
  int entry[STACKSIZE], stackptr;
} STACK;

#define POS_TRAPNO 10		/* Number of traps */
#define STRINGNO 20		/* Number of string variables */
#define NUMREGNO 20		/* Number of user definable number registers */
#define MACRONO 50		/* Number of macros definitions */
#define DIVERSIONS 4		/* Number of diversion files */

#ifndef MROFF_C
extern FILE *outfp;
extern FILE *nullfp;
extern void pbstr(/* char *s; */);
extern char *getline();
extern void source(/* char *s; */);
extern void doread(/* char *s; */);
extern bool selectpage(/* int n; */);
extern char CCVAL,C2VAL;
extern char LINE[];
extern char pages[];
#endif

#ifndef REQUEST_C
extern char chararg(/* char *s; */);
extern int numarg(/* char *s; int def; */);
extern int posarg(/* char *s,dir; int pos; */);
extern void command(/* char *s; */);
#endif

#ifndef SPECIAL_C
extern char *specialchar(/* char x,y; */);
#endif

#ifndef FILL_C
extern void text(/* char *line; */);
extern void addwrd(/* char *s; */);
extern int tabpos(/* int x; */);
extern void dotab(/* char *s; */);
extern void dotc(/* char *s; */);
extern void dobreak();
extern void adjust(/* char *s; */);
extern void noadjust();
extern void dofill();
extern void nofill();
extern void center(/* char *s; */);
extern void tempindent(/* char *s; */);
extern void indent(/* char *s; */);
extern void dospace(/* char *s; */);
extern void pageoffset(/* char *s; */);
extern void linespace(/* char *s; */);
extern void vertspace(/* char *s; */);
extern void linelength(/* char *s; */);
extern void rightmargin(/* char *s; */);
extern void title(/* char *s; */);
extern void mark(/* char *s; */);
extern void markreturn(/* char *s; */);
extern void need(/* char *s; */);
extern void fill_init();
extern int PSVAL; extern STACK psstack;
extern int VSVAL;
extern int XPOS,YPOS;
extern char ADVAL;
extern int FILL;
#endif

#ifndef WIDTH_C
extern int width(/* char *s; */);
#endif

#ifndef FONT_C
extern int *widths;
extern void putfont(/* int n; */);
extern void changewidths(/* int n; */);
extern void setfont(/* int n; */);
extern void storefonts();
extern void restorefonts();
extern void setsize(/* int n; */);
extern void doft(/* char *s; */);
extern void dops(/* char *s; */);
extern void font_init();
extern int FONTVAL; extern STACK ftstack;
#endif

#ifndef ERROR_C
extern void mrofferror(/* char *arg1,*arg2; int err,ex; */);
#endif

#ifndef TRAP_C
extern int CURPAG;
extern int PLVAL;
extern void trappos(/* char *s; */);
extern void trapin(/* char *s; */);
extern void dopagebreak(/* char *s; */);
extern void pagelength(/* char *s; */);
extern void checkpos();
extern void checkin();
extern void endmacro(/* char *s; */);
extern void doend();
extern void trap_init();
#endif

#ifndef STACK_C
extern void initstack(/* int val; STACK *stack; */);
extern void pushvar(/* int value; STACK *stack; */);
extern int popvar(/* STACK *stack; */);
#endif

#ifndef STRING_C
extern void defstr(/* char *s; */);
extern char *getstr(/* char x,y; */);
extern void string_init();
#endif

#ifndef NUMREG_C
extern void defreg(/* char *s; */);
extern char *getnumreg(/* char x,y; int doinc; */);
#endif

#ifndef MACRO_C
extern void dode(/* char *s; */);
extern void expand(/* char *s; */);
extern int execmac(/* char *s; */);
extern void dumpmacros();
#endif

#ifndef IF_C
extern void doif(/* char *s; */);
#endif

#ifndef DIVERSION_C
extern void put2div(/* char *name; */);
extern void closedivs();
extern void divers_init();
#endif

#ifndef DEVICE_C
extern void vdopen();
extern void vdfont(/* char *s; int p; */);
extern void vderase();
extern void vdclose();
#endif
