/* macro.c - definition and use of macros */

#include <stdio.h>

#define MACRO_C

#include "mroff.h"

/* expand numeric registers, string variables and double escapes */
public void expand(s) unsigned char *s;
{
  int state;

  state=0;
  while (*s)
  {
    switch (state)
    {
      case 0:
      {
        if (*s==CCVAL) state=1;
        break;
      }
      case 1:
      {
        switch (*s)
        {
          case '\\': 
          {
            unsigned char *h;
	    
            h=(unsigned char*)malloc(strlen(s)+1);
            strcpy(h,s);
            strcpy(--s,h);
            free(h);
            break;
          }

          case '"': *--s='\0'; s--; break;
                   
          case '*' :	/* expand string variable */
          {
            unsigned char x,y,*h,*ins;
            
            ins=s-1;
            if (*++s=='(') { x = *++s; y = *++s; }
            else { x = *s; y = '\0'; }
            h=(unsigned char*)malloc(strlen(s+1)+1);
            strcpy(h,s+1);
            strcpy(ins,getstr(x,y));
            strcat(ins,h);
            free(h);
            s=ins-1;
            break;
          }

          case '(' :	/* expand special character */
          {
            unsigned char x,y,*h,*ins;
            
            ins=s-1;
            x = *++s; y = *++s;
            h=(unsigned char*)malloc(strlen(s+1)+1);
            strcpy(h,s+1);
            strcpy(ins,specialchar(x,y));
            strcat(ins,h);
            free(h);
            s=ins-1;
            break;
          }

          case 'n' :	/* expand numeric register */
          {
            unsigned char x,y,*h,*ins,inc;

            ins=s++-1;
            if (*s=='-' || *s=='+') inc = *s++; else inc=' ';
            if (*s=='(') { x = *++s; y = *++s; }
            else { x = *s; y = '\0'; }
            h=(unsigned char*)malloc(strlen(s+1)+1);
            strcpy(h,s+1);
            strcpy(ins,getnumreg(x,y,inc));
            strcat(ins,h);
            free(h);
            s=ins-1;
            break;
          }

        }
        state=0;
        break;
      }

    }
    s++;
  }
}

typedef struct
{
  char c1,c2;
  char *mac;
} MACRO;

private MACRO macro[MACRONO];

private MACRO *findmac(x,y) char x,y;
{
  MACRO *look;
  int num;
  
  look=macro; num=0;
  while (num<MACRONO && (look->c1!=x || look->c2!=y)) { look++; num++; }
  return (num==MACRONO ? NULL : look);
}

private MACRO *creatmac()
{
  MACRO *look;
  int num;
  
  look=macro; num=0;
  while (num<MACRONO && look->c1!='\0') { look++; num++; }
  if (num==MACRONO) mrofferror("no more space for macros","",0,
  INTERNALERROR);
  return look;
}

/* .de x{y}
    abc
   ..
*/   
public void dode(s) char *s;
{
  char x,y;
  static char buf[MAXLINE];
  MACRO *mac;
  
  s+=3;
  while (*s==' ') s++;
  if ((x = *s++)=='\0') { mrofferror("no macro name","",0,0); return; }
  y = *s;
  *buf='\0';
  /* warning: next line needs short circuit evaluation */
  while (getline() && (LINE[0]!='.' || LINE[1]!='.'))
  {
    if (LINE[0]=='.' && LINE[1]=='\\' && LINE[2]=='"') continue;
    expand(LINE);
    strcat(buf,LINE); strcat(buf,"\n");
  }
  if (mac=findmac(x,y))
  {
    mrofferror("macro redefinition","",0,0);
    free(mac->mac);
  } else mac=creatmac();
  mac->c1=x; mac->c2=y;
  mac->mac=(char *)malloc(strlen(buf)+1);
  strcpy(mac->mac,buf);
}

/* if such a macro exists then execute it */
public int execmac(s) char *s;
{
  char x,y,*exp,*from,*to,*cp,*arg[10],tc,buf[MAXLINE],*bufp;
  int num,state;
  MACRO *mac;
  
  x = *++s; if ((y = *++s)==' ') y='\0'; else s++;
  if (mac=findmac(x,y))
  {
    arg[0]=arg[1]=arg[2]=arg[3]=arg[4]=arg[5]=arg[6]=arg[7]=arg[8]=arg[9]=NULL;
    while (*s==' ') s++;
    expand(s);
    /* \$0 is the whole line of arguments */
    arg[0]=(char*)malloc(strlen(s)+1); strcpy(arg[0],s);
    for (num=1; num<=9; num++)
    {
      /* an argument can be quoted by a double quote */
      if (*s=='"') { tc='"'; s++; } else tc=' ';
      arg[num]=s;
      while (*s && *s!=tc) s++; if (*s) *s++='\0';
      while (*s==' ') s++;
    }
    to=exp=(char*)malloc(MAXLINE); /* you can't push back more bytes! */
    from=mac->mac;
    state=0;
    while (*from)
    {
      switch (state)
      {
        case 0: if (*from==CCVAL) state=1; else *to++ = *from; break;
        case 1:
        {
          if (*from=='$') state=2;
          else
          {
            *to++='\\';
            *to++ = *from;
            state=0;
          }
          break;
        }
        case 2:
        {
          if (*from>'9' && *from<'0') mrofferror("corrupt macro argument",from,0,INTERNALERROR);
          if (cp=arg[*from-'0']) while (*cp) *to++ = *cp++;
          state=0;
          break;
        }
      }
      from++;
    }
    *to='\0';
    pbstr(exp);
    free(exp);
    free(arg[0]);
    return TRUE;
  }
  else return FALSE;
}

public void dumpmacros()
{
  int i;
  
  fprintf(stderr,"Listing of all defined macros:\n\n");
  for (i=0; i<MACRONO; i++)
  if (macro[i].c1)
  {
    fprintf(stderr,".%c%c",macro[i].c1,macro[i].c2);
    fprintf(stderr,"\n%s..\n\n",macro[i].mac);
  }
}

public void macro_init()
{
  int i;
  
  for (i=0; i<MACRONO; i++) macro[i].c1='\0';
}
