/* font.c - changes font and computes new widths for each character
   Attention: in some lines, XPOS means the x position times 10.  This is
   ugly code, but faster and smaller than flaoting point arithmetic.
   It is necessary, because the resolution of one point is not enough.
   widths always contains the width of each character times 10
*/

#include <errno.h>
#include <stdio.h>

#define FONT_C

#include "mroff.h"

#define FONTNO 5
#define MAXCHARS 122

public int *widths;

/* read a letter definition from a hershey font file and return its width.
This is only used in loadwidths() */
private int getsize(fp) FILE *fp;
{
  char ln[85],*s;
  int count, width;

  if (fgets(ln,85,fp)==NULL) return -1;
  count= (ln[5]==' ' ? 0 : ln[5]-'0');
  count=10*count+(ln[6]==' ' ? 0 : ln[6]-'0');
  count=10*count+ln[7]-'0';
  width= ln[9]-ln[8];
  s=ln+10;
  while (--count)
  {
    if (*s=='\n') { s=ln; if (fgets(ln,85,fp)==NULL) return -1; }
    s+=2;
  }
  return width;
}

typedef struct
{
  char name[20];
  int orig_widths[MAXCHARS];
  int widths[MAXCHARS];
} FONT;

/* load the widths of a font into a private buffer.  This will be done during
   init time of mroff.  Later font changes only use these original width data
   we read from the files.
*/
private void loadwidths(f,font) char *f; FONT *font;
{
  FILE *fp;
  int i,*widths,w;
  char fontname[100];
  
  widths=font->orig_widths;
  strcpy(font->name,f);
  strcpy(fontname,FONTPATH); strcat(fontname,f);
  if ((fp=fopen(fontname,"r"))==NULL)
  mrofferror("can't open font",f,errno,USERERROR);
  for (i=0; i<MAXCHARS; i++)
  {
    w=getsize(fp);
    if (w>=0) *widths++=w; else break;
  }
  fclose(fp);
}

private FONT font[FONTNO];
public int FONTVAL; public STACK ftstack;

/* compute the size for each letter of this font */
private void resizefont(fontnum) int fontnum;
{
  FONT *f;
  FILE *fp;
  int i,M;
  
  f= &(font[fontnum]);
  M = 30;
  for (i=0; i<MAXCHARS; i++)
  f->widths[i] = (f->orig_widths[i] * 10L * (long)PSVAL) / M;
}

/* set some global values, so that font n will be used from now on */
public void changewidths(n) int n;
{
  widths = &(font[n].widths[0]);
  FONTVAL=n;
}

/* tell the device what font it should use */
public void putfont(n) int n;
{
  char f[100];
  
  strcpy(f,FONTPATH); strcat(f,font[n].name);
  vdfont(f,PSVAL);
}

public void setfont(n) int n;
{
  changewidths(n);
  putfont(n);
}

/* sometimes, I change fonts while computing various things, but these
   changes are only for getting some values.  In the real formatting
   phase, I need the original values to get right outputs.  Therefore
   I decided to use a non-stacked save/restore for the fonts.  It is not
   the best solution, but the only point where I broke fundamental rules
   of structured programming (I hope so, improvements are welcome).
*/

private int *sto_widths;
private int sto_no,sto_ps;
private FONT sto_font[FONTNO];
private STACK sto_ftstack, sto_psstack;

public void storefonts()
{
  int i;

  sto_widths=widths;
  sto_no=FONTVAL;
  sto_ftstack=ftstack;
  sto_ps=PSVAL;
  sto_psstack=psstack;
  for (i=0; i<FONTNO; i++) sto_font[i]=font[i];
}

public void restorefonts()
{
  int i;

  widths=sto_widths;
  FONTVAL=sto_no;
  ftstack=sto_ftstack;
  PSVAL=sto_ps;
  psstack=sto_psstack;
  for (i=0; i<FONTNO; i++) font[i]=sto_font[i];
}

/* change size of all fonts */
public void setsize(ps) int ps;
{
  int i;

  PSVAL=ps;
  for (i=0; i<FONTNO; i++) resizefont(i);
}

/* .ft f  or .ft N */
public void doft(s) char *s;
{
  char fs[4];
  
  s+=3; while (*s==' ') s++;
  sprintf(fs,"\\f%c",*s);
  addwrd(fs);
}

/* .ps n */
public void dops(s) char *s;
{
  int ps;
  char a[10];
  
  ps=numarg(s,PSVAL);
  if (ps!=NOVALUE && ps<3) mrofferror("invalid fontsize",s,0,0);
  else
  {
    sprintf(a,"\\s%d\\&",(ps==NOVALUE ? 0 : ps));
    addwrd(a);
  }
}

public void font_init()
{
  FILE *mroffrc;
  char *getenv(),homerc[100],name[100];
  int size,i;
  
  FONTVAL=0;
  initstack(FONTVAL,&ftstack);

  strcpy(homerc,getenv("HOME"));
  strcat(homerc,"/.mroffrc");
  if (mroffrc=fopen(".mroffrc","r"))
  {
    i=0;
    while (fscanf(mroffrc,"%s",name)!=EOF && i<FONTNO)
    {
      loadwidths(name,&(font[i]));
      resizefont(i);
      i++;
    }
    fclose(mroffrc);
  }
  else if (mroffrc=fopen(homerc,"r"))
  {
    i=0;
    while (fscanf(mroffrc,"%s",name)!=EOF && i<FONTNO)
    {
      loadwidths(name,&(font[i]));
      resizefont(i);
      i++;
    }
    fclose(mroffrc);
  }
  else
  {
    loadwidths("roman.s",&(font[0]));
    resizefont(0);
    loadwidths("roman.d",&(font[1]));
    resizefont(1);
    loadwidths("italic.d",&(font[2]));
    resizefont(2);
    loadwidths("special.s",&(font[3]));
    resizefont(3);
    loadwidths("roman.s",&(font[4]));
    resizefont(4);
  }
  changewidths(0);
}
