/* fill.c - fill and print lines
   Attention: in some lines, XPOS means the x position times 10.  This is
   ugly code, but faster and smaller than flaoting point arithmetic.
   It is necessary, because the resolution of one point is not enough.
*/

#include <stdio.h>

#define FILL_C

#include "mroff.h"

private int INVAL; private STACK instack;
private int POVAL; private STACK postack;
private int TIVAL;
private int LLVAL; private STACK llstack;
private int LTVAL; private STACK ltstack;
private int LSVAL; private STACK lsstack;
private int RMVAL; private STACK rmstack;
private int CEVAL;

public int VSVAL; private STACK vsstack;
public int PSVAL; public STACK psstack;
public int FILL;
public char ADVAL;
public int XPOS;
public int YPOS;

private int tabstop[20];
private int tabno;

public int tabpos(x) int x;
{
  int n;
  
  n=0;
  while (n<tabno && x>=tabstop[n]) n++;
  return (n==tabno ? x : tabstop[n]);
}

/* .ta */
public void dotab(s) char *s;
{
  s+=3;
  tabno=0;
  while (TRUE)
  {
    tabstop[tabno]=posarg(s,'m',0);
    if (tabstop[tabno]!=INVALID && tabstop[tabno]!=NOVALUE)
    tabstop[tabno++]+=POVAL; else break;
    while (*s && *s==' ') s++;
    while (*s && *s!=' ') s++;
  }
}

private char TCVAL[20];

/* .tc */
public void dotc(s) char *s;
{
  s+=3;
  while (*s==' ') s++;
  strcpy(TCVAL,s);
}

/* counts holes in a string, but does not count hard spaces */
private int holes(s) char *s;
{
  int state,n;
  
  state=0; n=0;
  while (*s)
  {
    switch (state)
    {
      case 0: if (*s==CCVAL) state=1; else if (*s==' ') { state=2; n++; } s++; break;
      case 1: state=0; s++; break;
      case 2: if (*s!=' ') state=0; else s++; break;
    }
  }
  return n;
}

private char wrdqueue[MAXLINE];

/* adjust and print a string */
private void put(s) unsigned char *s;
{
  int sz,noinc,fillup,fillpos,fillextra,holno,state,linewidth;
  unsigned char *trunc;

  checkpos();
  /* delete trailing blanks */
  trunc=s+strlen(s)-1;
  while (trunc>=s && *trunc==' ') *trunc--='\0';
  if (*s=='\0') { YPOS+=LSVAL; return; }
  /* ok, we have a non empty string in the output queue */
  storefonts();
  linewidth=width(s)/10;
  restorefonts();
  fillup=0; fillpos=0;
  XPOS=POVAL+INVAL+TIVAL;
  if (ADVAL=='b' && CEVAL==0 && FILL)
  {
    fillextra=RMVAL-TIVAL-INVAL-linewidth;
    holno=holes(s);
    fillpos=fillextra % holno;
    fillup=fillextra / holno;
  }
  else if (ADVAL=='c' || CEVAL) XPOS=POVAL+(RMVAL-linewidth)/2;
  else if (ADVAL=='r') XPOS=POVAL+RMVAL-linewidth;
  fprintf(outfp,"m%d %d\nt",XPOS,YPOS);
  state=0; noinc=0; XPOS*=10; fillup*=10; /* switch to higher precision */
  while (*s)
  {
    switch (state)
    {
      case 0:
      {
        if (*s==' ') { s++; state=1; break; }
        if (*s==CCVAL) { s++; state=3; break; }
        putc(*s, outfp);
        if (noinc) { fprintf(outfp, "\nm%d %d\nt",XPOS/10,YPOS); noinc=0; }
        else XPOS+=widths[*s-' '];
        s++;
        break;
      }
      case 1:
      {
        XPOS+=widths[' '-' ']+fillup;
        if (fillpos) { fillpos--; XPOS+=10; }
        if (*s==' ') { state=2; s++; }
        else { fprintf(outfp,"\nm%d %d\nt",XPOS/10,YPOS); state=0; }
        break;
      }
      case 2:
      {
        XPOS+=widths[' '-' '];
        if (*s!=' ')
        {
          fprintf(outfp,"\nm%d %d\nt",XPOS/10,YPOS);
          state=0;
        } else s++;
        break;
      }
      case 3:
      {
        switch (*s)
        {
          case '\\': putc('\\',outfp); XPOS+=widths['\\'-' ']; break;
          case 'e': putc(CCVAL,outfp); XPOS+=widths[CCVAL-' ']; break;
          case '%': putc('-',outfp); XPOS+=widths['-'-' ']; break;
          case '-': putc(MINUS,outfp); XPOS+=widths[MINUS-' ']; break;
          case '\'': putc('\'',outfp); XPOS+=widths['\''-' ']; break;
          case '`': putc('`',outfp); XPOS+=widths['`'-' ']; break;
          case ' ': putc(' ',outfp); XPOS+=widths[' '-' ']; break;
          case '|': fprintf(outfp,"\nm%d %d\nt",(XPOS+=10*PSVAL/6)/10,YPOS); break;
          case '^': fprintf(outfp,"\nm%d %d\nt",(XPOS+=10*PSVAL/12)/10,YPOS); break;
          case '0': fprintf(outfp,"\nm%d %d\nt",(XPOS+=widths['0'-' '])/10,YPOS); break;
          case '&': break;
          case 'z': noinc=1; break;
          case 'u': fprintf(outfp,"\nm%d %d\nt",XPOS/10,YPOS-=PSVAL/2); break;
          case 'd': fprintf(outfp,"\nm%d %d\nt",XPOS/10,YPOS+=PSVAL/2); break;
          
          case 't':
          {
            if (ADVAL=='l' || ((ADVAL=='b' || ADVAL=='r') && !FILL))
            {
              int tcx,right,tcwidth;
              
              if (*TCVAL)
              {
                tcx=XPOS;
                tcwidth=width(TCVAL);
                right=tabpos(XPOS/10)*10-tcwidth;
                while (tcx<=right)
                {
                  fprintf(outfp,"%s\nm%d %d\nt",TCVAL,tcx/10,YPOS);
                  tcx+=tcwidth;
                }
              }
              fprintf(outfp,"\nm%d %d\nt",(XPOS=tabpos(XPOS/10)*10)/10,YPOS);
            }
            break;
          }
          
          case 'f':
          {
            putc('\n',outfp);
            switch (*++s)
            {
              case 'R' : pushvar(FONTVAL,&ftstack); setfont(0); break;
              case 'B' : pushvar(FONTVAL,&ftstack); setfont(1); break;
              case 'I' : pushvar(FONTVAL,&ftstack); setfont(2); break;
              case 'S' : pushvar(FONTVAL,&ftstack); setfont(3); break;
              case 'P' : setfont(popvar(&ftstack)); break;
              case '0' :
              case '1' :
              case '2' :
              case '3' :
               case '4' : pushvar(FONTVAL,&ftstack); setfont(*s-'0'); break;
            }
            putc('t',outfp);
            break;
          }
          
          case 's' :
          {
            int n;
            char sign;
            
            sign=' '; n=0;
            if (*(s+1)=='+' || *(s+1)=='-') sign = *++s;
            while (*(s+1)<='9' && *(s+1)>='0') n=n*10+*++s-'0';
            n=(sign=='+' ? PSVAL+n : (sign=='-' ? PSVAL-n : n));
            putc('\n',outfp);
            if (n) pushvar(PSVAL,&psstack); else n=popvar(&psstack);
            setsize(n);
            setfont(FONTVAL);
            putc('t',outfp);
            break;
          }

        }
        state=0;
        s++;
        break;
      }
    }
  }
  putc('\n',outfp);
  YPOS+=LSVAL;
  TIVAL=0;
  XPOS/=10; /* back to normal precision */
}

/* get a word from input queue and return success */
private char *getwrd(line) char *line;
{
  static char wrdbuf[MAXLINE];
  char *wrd,*get;
  char c,state;

  if (*line=='\0') return NULL;
  wrd=wrdbuf;
  get=line;
  state=0;
  while (state<4)
  {
    c = *get++;
    if (c)
    {
      switch (state)
      {
        case 0: if (c!=' ') state=2; break;
        case 1: if (c=='%') state=5; else state=2; break;
        case 2: if (c=='\\') state=1; else if (c==' ') state=3; break;
        case 3: if (c!=' ') state=4;
      }
      if (state!=4) *wrd++ = c; else --get;
    } else state=6;
  }
  if (wrd!=wrdbuf)
  {
    if (*(wrd-1)=='.' || *(wrd-1)=='?' || *(wrd-1)=='!') { *wrd++=' '; *wrd++=' '; }
    if (state!=5 && *(wrd-1)!=' ') *wrd++=' ';
  }
  *wrd='\0';
  /* delete the word from input queue */
  wrd=line;
  if (state!=6) while (*get!='\0') *wrd++ = *get++;
  *wrd='\0';
  return (wrdbuf);
}

/* add any escape code of width 0 */
public void addwrd(s) char *s;
{
  strcat(wrdqueue,s);
}

/* add a new word to the output queue and print a line when it is full */
private void putwrd(s) char *s;
{
  int w,hyph,maxwidth;

  storefonts();
  maxwidth=RMVAL-INVAL-TIVAL;
  XPOS=POVAL+INVAL+TIVAL;
  w=width(wrdqueue)/10;
  if (wrdqueue[strlen(wrdqueue)-1]=='%') { hyph=TRUE; w-=width("\\%")/10; }
  else hyph=FALSE;
  XPOS+=w;
  if (width(s)/10+w > maxwidth)
  {
	/* width has ugly side effects, so do restorefonts before output */
    restorefonts();
    put(wrdqueue);
    *wrdqueue='\0';
    strcpy(wrdqueue,s);
  }
  else
  {
    restorefonts();
   if (hyph) strcpy(wrdqueue+strlen(wrdqueue)-2,s);
  else strcat(wrdqueue,s);
}
}

private char *invalpos="invalid position";

/* .br */
public void dobreak()
{
  int oldadjust;
  
  oldadjust=ADVAL;
  if (ADVAL=='b') ADVAL='l';
  if (*wrdqueue) { put(wrdqueue); *wrdqueue='\0'; }
  ADVAL=oldadjust;
}

/* .ad x */
public void adjust(s) char *s;
{
  char c;

  dobreak();
  c=chararg(s);
  if (c=='l' || c=='r' || c=='b' || c=='c') ADVAL=c;
  else if (c=='n') ADVAL=='b';
  else if (c!='\0') mrofferror("invalid adjust mode",s,0,0);
}

/* .na */
public void noadjust()
{
  dobreak();
  ADVAL='l';
}

/* .fi */
public void dofill()
{
  dobreak();
  FILL=TRUE;
}

/* .nf */
public void nofill()
{
  dobreak();
  FILL=FALSE;
}

/* .ce n */
public void center(s) char *s;
{
  int v;
  
  v=numarg(s,0);
  if (v==INVALID || v<0) mrofferror("invalid number",s,0,0);
  else { dobreak(); CEVAL=v; }
}

/* .ti n */
public void tempindent(s) char *s;
{
  int ti;
  
  ti=posarg(s+3,'m',0);
  if (ti==INVALID) mrofferror(invalpos,s,0,0);
  else TIVAL=ti;
}

/* .in n */
public void indent(s) char *s;
{
  int in;
  
  in=posarg(s+3,'m',INVAL);
  if (in==INVALID) mrofferror(invalpos,s,0,0);
  else if (in==NOVALUE) INVAL=popvar(&instack);
  else { pushvar(INVAL,&instack); INVAL=in; }
}

/* .sp {|}n */
public void dospace(s) char *s;
{
  int sp,abs;
  
  if (*s!=C2VAL) dobreak();
  s+=3; while (*s==' ') s++;
  if (*s=='|') { abs=TRUE; s++; } else abs=FALSE;
  sp=posarg(s,'v',0);
  if (sp==NOVALUE) { abs=FALSE; sp=LSVAL; }
  else if (sp==INVALID) { mrofferror(invalpos,s,0,0); return; }
  else if (sp<0) 
  if (abs) sp+=PLVAL; else { mrofferror(invalpos,"",0,0); return; }
  if (abs) YPOS=sp; else YPOS+=sp;
  checkpos();
}

/* .po */
public void pageoffset(s) char *s;
{
  int po;
  
  po=posarg(s+3,'m',POVAL);
  if (po==NOVALUE) POVAL=popvar(&postack);
  else if (po==INVALID || po<0) mrofferror(invalpos,s,0,0);
  else { pushvar(POVAL,&postack); POVAL=po; }
}

/* .vs n */
public void vertspace(s) char *s;
{
  int vs;
  
  vs=posarg(s+3,'v',VSVAL);
  if (vs==NOVALUE) VSVAL=popvar(&vsstack);
  else if (vs==INVALID || vs<0) mrofferror("invalid number",s,0,0);
  else
  {
    LSVAL=(int)(((long)LSVAL*(long)vs)/(long)VSVAL);
    pushvar(VSVAL,&vsstack);
    VSVAL=vs;
  }
}

/* .ls n */
public void linespace(s) char *s;
{
  int ls;
  
  ls=posarg(s+3,'v',LSVAL);
  if (ls==NOVALUE) LSVAL=popvar(&lsstack);
  else if (ls==INVALID || ls<0) mrofferror("invalid number",s,0,0);
  else { pushvar(LSVAL,&lsstack); LSVAL=ls; }
}

/* .ll M */
public void linelength(s) char *s;
{
  int ll;
  
  ll=posarg(s+3,'m',LLVAL);
  if (ll==NOVALUE) LLVAL=popvar(&llstack);
  else if (ll==INVALID || ll<=0) mrofferror("invalid size",s,0,0);
  else { pushvar(LLVAL,&llstack); LLVAL=ll; }
  if (LLVAL<RMVAL) RMVAL=LLVAL;
}

/* .rm n */
public void rightmargin(s) char *s;
{
  int rm;
  
  rm=posarg(s+3,'m',RMVAL);
  if (rm==NOVALUE) RMVAL=popvar(&rmstack);
  else if (rm==INVALID || rm<=0) mrofferror("invalid right margin",s,0,0);
  else { pushvar(RMVAL,&rmstack); RMVAL=rm; }
}

/* .lt n */
public void titlelength(s) char *s;
{
  int lt;
  
  lt=posarg(s+3,'m',LTVAL);
  if (lt==NOVALUE) LTVAL=popvar(&ltstack);
  else if (lt==INVALID || lt<=0) mrofferror("invalid size",s,0,0);
  else { pushvar(LTVAL,&ltstack); LTVAL=lt; }
}

/* .tl 'a'b'c' */
public void title(s) char *s;
{
  char delim, a[MAXLINE], b[MAXLINE], c[MAXLINE];
  char *ap=a, *bp=b, *cp=c;
  int xold,yold,adold,rmold,inold,llold;

  s+=3;
  while (*s==' ') s++;
  expand(s);
  delim = *s++;
  if (delim=='\0') { mrofferror("unvalid title argument",s,0,0); return; } 
  while (*s && *s!=delim) *ap++ = *s++;
  if (*s) s++;
  while (*s && *s!=delim) *bp++ = *s++;
  if (*s) s++;
  while (*s && *s!=delim) *cp++ = *s++;
  *ap = *bp = *cp = '\0';
  xold=XPOS; yold=YPOS; adold=ADVAL; rmold=RMVAL; inold=INVAL; llold=LLVAL;
  RMVAL=LLVAL; INVAL=0; LLVAL=LTVAL;
  ADVAL='l'; put(a);
  XPOS=xold; YPOS=yold;
  ADVAL='c'; put(b);
  XPOS=xold; YPOS=yold;
  ADVAL='r'; put(c);
  ADVAL=adold; RMVAL=rmold; INVAL=inold; LLVAL=llold;
}

private STACK markstack;

/* .mk */
public void mark(s) char *s;
{
  pushvar(YPOS,&markstack);
}

/* .rt */
public void markreturn(s) char *s;
{
  YPOS=popvar(&markstack);
}

public void text(line) char *line;
{
  char *w;

  checkin();
  if (CEVAL)
  {
    strcat(wrdqueue,line);
    put(wrdqueue); *wrdqueue='\0';
    CEVAL--;
  }
  else if (line[0]=='\0') { dobreak(); YPOS+=LSVAL; }
  else if (!FILL) 
  {
    strcat(wrdqueue,line); 
    put(wrdqueue); *wrdqueue='\0';
  }
  else while ((w=getwrd(line))!=NULL) putwrd(w);
}

/* This defaults are ok for DIN A4 and 12 inch paper */
public void fill_init()
{
  int i;	

  *wrdqueue='\0';
  *TCVAL='\0';
  tabno=16;
  for (i=0; i<tabno;) tabstop[i] = ++i*36;
  INVAL=0;			/* No indentation */
  initstack(INVAL,&instack);
  POVAL=72;			/* 1 inch page offset */
  initstack(POVAL,&postack);
  TIVAL=0;			/* no temporary indent */
  LLVAL=432;			/* linelength 6 inch */
  initstack(LLVAL,&llstack);
  LTVAL=LLVAL;			/* title line length */
  initstack(LTVAL,&ltstack);
  RMVAL=LLVAL;			/* right margin at linelength-pageoffset */
  initstack(RMVAL,&rmstack);
  PSVAL=10;			/* 10 dot font */
  initstack(PSVAL,&psstack);
  VSVAL=12;			/* vertical space between line baselines */
  initstack(VSVAL,&vsstack);
  LSVAL=VSVAL;			/* linespacing */
  initstack(LSVAL,&lsstack);
  initstack(PSVAL,&markstack);	/* mark/return positions */
  FILL=TRUE;			/* fill lines */
  XPOS=INVAL;			/* horizontal position */
  YPOS=PSVAL;			/* vertical position */
  ADVAL='b';			/* adjust both margins */
  CEVAL=0;			/* number of line to center */
}
