/* diversion.c - open, use and close diversions

   Diversions work not like in troff, they work like in roff4.  When entering
   an .di filename, all lines read from the input are written to this file
   until a .di is read.  mroff can process this file later.  This is the way
   I create automatic tables of contents.  Don't flame me for this way, I use
   it since years.  If you don't like it, change it!
*/   

#include <errno.h>
#include <stdio.h>

#define DIVERSION_C

#include "mroff.h"

typedef struct
{
  char name[50];
  FILE *fp;
} DIVERSION;

private DIVERSION diversion[DIVERSIONS];
private int divno;

/* .di name */
public void put2div(name) char *name;
{
  int i;
  char *ok;
  
  name+=3;
  while (*name==' ') name++;

  for (i=0; i<divno; i++) if (!strcmp(name,diversion[i].name)) break;
  if (i==divno)
  {
    if (divno==DIVERSIONS) mrofferror("too many diversions:",name,0,1);
    divno++;
    strcpy(diversion[i].name,name);
    if ((diversion[i].fp=(fopen(name,"w")))==NULL) mrofferror("can\'t open diversion",name,errno,1);
  }
  while (ok=getline())
  {
    if (LINE[0]==COMMAND && LINE[1]=='d' && LINE[2]=='i') break;
    expand(LINE);
    if (!execmac(LINE)) fprintf(diversion[i].fp,"%s\n",LINE);
  }
  if (ok==NULL) mrofferror("corrupted diversion",name,0,1);
}

/* close all diversion files before exiting */
public void closedivs()
{
  int i;
  
  for (i=0; i<divno; i++) fclose(diversion[i].fp);
}

public void divers_init()
{
  divno=0;
}
