/* device independent output pager for interactive devices
   use: pre <input | devicedriver
*/

#include <sgtty.h>
#include <stdio.h>

/* temporary file for one page */
#define PAGEFILE "/usr/tmp/preview"

int x_scroll,y_scroll;
FILE *pagefile;

/* get one page of mroff output */
int getpage()
{
  char line[255];
  int res;
  
  res=0;
  pagefile=fopen(PAGEFILE,"w");
  while (fgets(line,255,stdin)!=NULL)
  {
    if (line[0]!='o' && line[0]!='q') fputs(line,pagefile);
    if (line[0]=='o') fputs("e\n",pagefile);
    if (line[0]=='u') { res=1; break; }
  }
  fclose(pagefile);
  return (res);
}

/* show a page with specified scroll values */
void showpage()
{
  char line[255];
  int x1,y1,x2,y2;

  pagefile=fopen(PAGEFILE,"r");
  while (fgets(line,255,pagefile))
  switch(line[0])
  {
    case 'm' :
    {
      sscanf(&line[1],"%d %d",&x1,&y1);
      printf("m%d %d\n",x1+x_scroll,y1+y_scroll);
      break;
    }
    default : fputs(line,stdout); break;
  }
  fclose(pagefile);
  fflush(stdout);
}

FILE *terminal;
struct sgttyb oldattr,newattr;

/* open terminal file for interactive use */
void opencmd()
{
  terminal=fopen("/dev/tty","r");
  gtty(fileno(terminal),&oldattr);
  gtty(fileno(terminal),&newattr);
  newattr.sg_flags &= ~ECHO;
  newattr.sg_flags |= RAW;
  stty(fileno(terminal),&newattr);
}

/* reset terminal to original state */
void closecmd()
{
  stty(fileno(terminal),&oldattr);
  fclose(terminal);
}

/* process commands, i.e. scroll a page */
int docmd()
{
  int c=0;

  x_scroll=y_scroll=0;
  while (c!=' ')
  {
    showpage();
    c=getc(terminal);
    switch (c)
    {
      case EOF:
      case 'q': return 0; break;
      case 'j': y_scroll-=72; break;
      case 'k': y_scroll=(y_scroll==0 ? 0 : y_scroll+72); break;
      case 'l': x_scroll-=72; break;
      case 'h': x_scroll=(x_scroll==0 ? 0 : x_scroll+72); break;
      case '\n':
      case '\r': y_scroll=(y_scroll==0 ? -360 : 0); break;
    }
  }
  return 1;
}

main()
{
  int more1=1,more2=1;

  opencmd();
  printf("o\n");
  while (more1 && more2)
  {
    if (more1=getpage()) more2=docmd();
  }
  printf("q\n");
  closecmd();
  unlink(PAGEFILE);
}
