/* mroffconv - Umlautkonvertierung:
   IBM zu roff4
   -a ASCII deutsch zu roff4
   -t roff4 zu IBM
*/

#include <stdio.h>

#define NORMAL 1
#define BACKSLASH 2
#define BRACKET 3
#define IS_A 4
#define IS_O 5
#define IS_U 6
#define IS_a 7
#define IS_o 8
#define IS_u 9
#define IS_s 10

char newchar[7]=
{ (char)0x8e, (char)0x99, (char)0x9a, (char)0x84, (char)0x94, (char)0x81, (char)0xE1 };

char *oldchar[7]=
{ "\\(A%c", "\\(O%c", "\\(U%c", "\\(a%c", "\\(o%c", "\\(u%c", "\\(s%c" };

#define FROMIBM 1
#define FROMASCII 2
#define TOIBM 3

main(argc,argv) int argc; char **argv;
{
  char c;
  int state=NORMAL, mode=FROMIBM;

  if (argc==2) if (argv[1][0]=='-')
  switch (argv[1][1])
  {
    case 'a': mode=FROMASCII; break;
    case 't': mode=TOIBM; break;
    default :
    fprintf(stderr,"mroffconv [-at]\n");
    fprintf(stderr,"    translates IBM \"Umlaute\" to mroff\n");
    fprintf(stderr,"    -a from german ASCII to mroff\n");
    fprintf(stderr,"    -t from mroff to IBM\n");
    exit(1);
  }
  while ((c=getc(stdin))!=EOF)
  {
    if (mode==FROMIBM) switch (c)
    {
      case '' : printf("\\(ae"); break;
      case '' : printf("\\(AE"); break;
      case '' : printf("\\(ue"); break;
      case '' : printf("\\(UE"); break;
      case '' : printf("\\(oe"); break;
      case '' : printf("\\(OE"); break;
      case '' : printf("\\(ss"); break;
      default  : putchar(c); break;
    }
    else if (mode==FROMASCII)
    switch (c)
    {
      case '{' : printf("\\(ae"); break;
      case '[' : printf("\\(AE"); break;
      case '}' : printf("\\(ue"); break;
      case ']' : printf("\\(UE"); break;
      case '\\' : printf("\\(OE"); break;
      case '|' : printf("\\(oe"); break;
      case 0x7e : printf("\\(ss"); break;
      case 0x60 : printf("\\"); break;
      default  : putchar(c); break;
    }
    else if (mode==TOIBM)
    switch (state)
    {
      case NORMAL:    if (c=='\\') state=BACKSLASH; else putchar(c); break;

      case BACKSLASH: 
      if (c=='(') state=BRACKET; else { putchar('\\'); putchar(c); }
      break;

      case BRACKET:
      switch (c)
      {
        case 'A' : state=IS_A; break;
        case 'a' : state=IS_a; break;
        case 'O' : state=IS_O; break;
        case 'o' : state=IS_o; break;
        case 'U' : state=IS_U; break;
        case 'u' : state=IS_u; break;
        case 's' : state=IS_s; break;
        default : state=NORMAL; printf("\\(%c",c); break;
      } break;

      case IS_A:
      case IS_O:
      case IS_U: 
      if (c=='E') putchar(newchar[state-IS_A]);
      else printf(oldchar[state-IS_A],c);
      state=NORMAL;
      break;

      case IS_a:
      case IS_o:
      case IS_u: 
      if (c=='e') putchar(newchar[state-IS_A]);
      else printf(oldchar[state-IS_A],c);
      state=NORMAL;
      break;

      case IS_s: 
      if (c=='s') putchar(newchar[IS_s-IS_A]);
      else printf(oldchar[IS_s-IS_A],c);
      state=NORMAL;
      break;

      default : putchar(c); state=NORMAL; break;
    }
  }
}


