/*{{{  notes*/
/* mparse.c - parse documents in mroff syntax for various purposes

   Used flags:

   MPREP for getting a mroff document spell check preparing program
   LOWERCASE for getting lowercase output

   MPP contains the basic functions for any mroff document preprocessors
*/
/*}}}  */
/*{{{  work which has not done yet*/
/*
arguments ::= { quotedarg | arg }
quotedarg ::= '\"' arg '\"'
arg ::= { letter | nonquote }
nonquote ::= any character without a double quote
*/
/*}}}  */
/*{{{  #include's*/
#include <ctype.h>
#include <stdio.h>
#include <local/bool.h>
/*}}}  */

char linebuf[512],*s;

/*{{{  #ifdef MPREP*/
#ifdef MPREP
#ifdef LOWERCASE
#define outtext(c) putchar(tolower(c))
#else
#define outtext(c) putchar(c)
#endif
#define outspec(c)
#endif
/*}}}  */
/*{{{  #ifdef MPP*/
#ifdef MPP
extern bool translate(/* char *word; */);

void fail(word) char *word;
{
  fprintf(stderr,"Can't translate '%s'\nLine: %s\n",word,linebuf);
}

char transbuf[512],*t=transbuf;

void outtext(c) char c;
{
  *t++ = c;
}

void outspec(c) char c;
{
  if (t!=transbuf)
  {
    *t++ = '\0';
    if (translate(transbuf)) printf("%s",transbuf);
    t=transbuf;
  }
  putchar(c);
}

#endif
/*}}}  */

/*{{{  nextchar: get next character and return success of this operation*/
int nextchar()
{
  if (*s=='\0') return 0;
  s++;
  return 1;
}
/*}}}  */

/*{{{  escapeseq ::= '\\' numreg | stringconst | anyescape*/
/* I don't echo the backslash, because special did it when it failed to match
   the special rule.  Not the best way, but who cares.
*/
int escapeseq()
{
  if (*s!='\\') return 0;
  nextchar();
  switch (*s)
  {
    case '*' :
    case 'n' : outspec(*s); nextchar(); if (*s=='(') { outspec('('); nextchar(); }
    outspec(*s); nextchar(); break;

    default: outspec(*s); nextchar();
  }
  return 1;
}
/*}}}  */
/*{{{  nonletter := nonescape | escapeseq*/
void nonletter()
{
  if (!escapeseq()) { outspec(*s); nextchar(); }
}
/*}}}  */
/*{{{  special ::= softhyphen | font | size | specialchar*/
/* This rule is context-sensitive, because not all special characters are
   accepted as a letter, see the return codes.
*/
int special()
{
  char *olds;

  if (*s!='\\') return 0;
  olds=s;
  nextchar();
  outspec('\\');
  switch (*s)
  {
    /*{{{  softhyhen*/
    case '%': outspec('%'); nextchar(); return 1;
    /*}}}  */

#if MPP
    /*{{{  print next character with width null*/
    case 'z': outspec('z'); nextchar(); return 1;
    /*}}}  */
#endif

    /*{{{  font sequence*/
    case 'f': /* font ::= 'f' anychar */
    {
      outspec('f'); nextchar(); outspec(*s); nextchar();
      return 1;
    }
    /*}}}  */

    /*{{{  size sequence*/
    case 's': /* size ::= [ '+' | '-' ] { digit } */
    {
      outspec('s');
      nextchar();
      if (*s=='-' || *s=='+') nextchar();
      while (*s>='0' && *s<='9') nextchar();
      return 1;
    }
    /*}}}  */

#ifdef MPREP
    /*{{{  special character*/
    case '(':
    {
      nextchar();
      if (((*s=='a' || *s=='A' || *s=='o' || *s=='O' || *s=='u' || *s=='U') && *(s+1)=='e') || (*s=='s' && *(s+1)=='s'))
      {
        outtext('\\'); outtext('(');
        outtext(*s); nextchar(); outtext(*s); nextchar();
        return 1;
      }
      else { nextchar(); nextchar(); return 2; }
    }
    /*}}}  */
#endif
#ifdef MPP
    /*{{{  special character*/
    case '(':
    {
      outspec('(');
      outspec(*s);
      nextchar();
      outspec(*s);
      nextchar();
      return 2;
    }
    /*}}}  */
#endif

    default: s=olds; return 0;
  }
}
/*}}}  */
/*{{{  letter ::= 'a'..'z' | 'A'..'Z' | special*/
int letter()
{
  int x;

  x=special();
  if (x) return 1;
  if (x==0) if ((*s>='a' && *s<='z') || (*s>='A' && *s<='Z'))
  {
    outtext(*s);
    nextchar();
    return 1;
  }
  return 0;
}
/*}}}  */
/*{{{  work ::= letter { letter }*/
void word()
{
  if (letter())
  {
    while (letter());
#ifdef MPREP
    outtext('\n');
#endif
  }
}
/*}}}  */
/*{{{  words ::= { work nonletter }*/
void words()
{
  while (*s) { word(); if (*s) nonletter(); }
}
/*}}}  */
/*{{{  macro ::= macrohead arguments*/
/* arguments not implemented yet */
int macro()
{
  if (*s=='.')
  {
#ifdef MPP
    printf("%s",s);
#endif
    return 1;
  }
  else return 0;
}
/*}}}  */
/*{{{  line ::= macro | words*/
void line()
{
  if (!macro(s)) words(s);
}
/*}}}  */
/*{{{  text ::= { line }*/
void text(fd) FILE *fd;
{
  int l;

  while (fgets(linebuf,sizeof(linebuf),fd))
  {
    if (l=strlen(linebuf)) linebuf[l-1]='\0';
    s=linebuf;
    line();
    outspec('\n');
  }
}
/*}}}  */

/*{{{  main(argc,argv)*/
main(argc,argv) int argc; char **argv;
{
  FILE *in;

  if (argc==2)
  {
    if (!strcmp(argv[1],"-?"))
    {
      fprintf(stderr,"Usage: %s {file}\n");
      exit(0);
    }
    if ((in=fopen(argv[1],"r"))==NULL)
    {
      fprintf(stderr,"%s: unvalid argument\n",argv[0]);
      exit(1);
    }
  }
  else in=stdin;

  text(in);

  if (in!=stdin) fclose(in);
}
/*}}}  */
