/* hindi.c - translates ASCII words in Hindi into Hindi font characters */

/*{{{  #include's*/
#include <string.h>
#include <local/bool.h>
/*}}}  */

#define private static

/*{{{  typedef TRANS*/
typedef struct
{
  char *translit;
  unsigned char letter;
  bool overwrite;
} TRANS;
/*}}}  */

/*{{{  TRANS table[] of all transliterations*/
/* all transliterations are in alphabetical order (Hindi alphabet!) */
private TRANS table[]=
{
  /*{{{  capital letters*/
  "AA", 'B', FALSE,  "Ah", 'K', FALSE,  "A", 'A', FALSE,
  "Bh", 'e', FALSE,  "B", 'd', FALSE,
  "Ce", 'Q', FALSE,  "Ch", 'l', FALSE,  "Cw", 'R', FALSE,
  "Dt", '^', FALSE,  "Dh", '_', FALSE,  "D", 'X', FALSE,
  "EE", 'H', FALSE,  "E", 'G', FALSE,
  "F", 'c', FALSE,
  "Gh", 'O', FALSE,  "Gy", 'q', FALSE,  "G", 'N', FALSE,
  "H", 'n', FALSE,
  "II", 'D', FALSE,  "I", 'C', FALSE,
  "J", 'S', FALSE,  "Jh", 'T', FALSE,
  "Ksh", 'o', FALSE,  "Kh", 'M', FALSE,  "K", 'L', FALSE,
  "L", 'i', FALSE,
  "M", 'f', FALSE,
  "Na", 'U', FALSE,  "Nh", 'Z', FALSE,  "N", 'a', FALSE,
  "OO", 'J', FALSE,  "O", 'I', FALSE,
  "P", 'b', FALSE,
  "Rh", 'Y', FALSE,  "R", 'h', FALSE,
  "Sh", 'k', FALSE,  "S", 'm', FALSE,
  "Trh", 'p', FALSE,  "TT", 'V', FALSE,  "Td", 'W', FALSE,  "Th", ']', FALSE,  "T", '[', FALSE,
  "UU", 'F', FALSE,  "U", 'E', FALSE,
  "V", 'j', FALSE,
  "Y", 'g', FALSE,
  /*}}}  */
  /*{{{  small letters*/
  "aa", 'r', FALSE,  "ad", '\224', TRUE,  "ah", '\231', TRUE,  "am", 'P', FALSE,  "an", '{', TRUE,  "ar", '\225', TRUE,
  "bh", '\213', FALSE,  "b", '\212', FALSE,
  "ce", '\201', FALSE,  "ch", '\220', FALSE,
  "dh", '\206', FALSE,  "dn", '\203', FALSE,
  "ee", 'x', TRUE,  "eh", '\226', TRUE,  "e", 'w', TRUE,
  "f", '\211', FALSE,
  "gh", '\200', FALSE,  "gy", '\222', FALSE, "g", '\177', FALSE,
  "ii", 't', FALSE,  "i", 's', FALSE,
  "j", '\202', FALSE,
  "kh", '~', FALSE,  "k", '}', FALSE,
  "l", '\215', FALSE,
  "m", '\214', FALSE,
  "n", '\207', FALSE,
  "oo", 'z', FALSE,  "o", 'y', FALSE,
  "p", '\210', FALSE,
  "r", '\223', TRUE,  "ri", '\230', FALSE,  "ru", '\227', FALSE,
  "sh", '\217', FALSE,  "s", '\221', FALSE,
  "th", '\205', FALSE,  "t", '\204', FALSE,
  "uu", 'v', TRUE,  "u", 'u', TRUE,
  "v", '\216', FALSE,
  /*}}}  */
  "", '\0'
};
/*}}}  */

/*{{{  bool translate(char *w) - translate word and return success*/
bool translate(w) char *w;
{
  /*{{{  variable declarations*/
  void fail(/* char *word */);
  char word[512], *t=word, *s=w, c;
  TRANS *p;
  int l;
  /*}}}  */

  /*{{{  while not end of input string, consisting of transliteratons*/
  while (*s)
  {
    /*{{{  search transliteration*/
    p=table;
    /* next line uses short circuit evaluation */
    while (p->letter && strncmp(p->translit,s,l=strlen(p->translit))) p++;
    /*}}}  */
    /*{{{  if transliteration exists then process it*/
    if (p->letter)
    {
      /*{{{  process this transliteration*/
      if (p->overwrite)
      /*{{{  write character over its left neighbour*/
      {
        c= *(t-1);
        if (*(t-3)=='z' && *(t-4)=='\\') /* e.g. M\ze and an */
        {
          *(t-1)='\\';
          *t++='z';
          *t++=p->letter;
          *t++=c;
        }
        else /* e.g. M and e */
        {
          *(t-1)='\\';
          *t++='z';
          *t++=p->letter;
          *t++=c;
        }
      }
      /*}}}  */
      else
      /*{{{  append it on the end of line*/
      *t++=p->letter;
      /*}}}  */
      /*}}}  */
      /*{{{  go to the next transliteration*/
      s+=l;
      /*}}}  */
    }
    /*}}}  */
    /*{{{  else complain*/
    else
    {
      fail(s);
      return FALSE;
    }
    /*}}}  */
  }
  /*}}}  */
  /*{{{  replace input string by translation*/
  *t='\0';
  strcpy(w,word);
  /*}}}  */
  return TRUE;
}
/*}}}  */
