/* argpars.c - argument parser for command line paramters */

#define INTEGER 0
#define BOOLEAN 1
#define CHARACTER 2
#define STRING 3

typedef struct
{
  char arg, type;
  int *variable;
} ARG;

/* set an argument.  argp points to the entry in the argument table, which
   fits to *linep.  returns linep which points after the processed argument.
*/
static char *setarg( argp, linep ) ARG *argp; char *linep;
{
  ++linep;

  switch( argp->type )
  {
    case INTEGER:
    {
      *(argp->variable)=atoi(linep);
      while (*linep) linep++;
      break;
    }

    case BOOLEAN: { *(argp->variable) = 1; break; }

    case CHARACTER: { *(argp->variable) = *linep++; break; }

    case STRING:
    {
      char *s;
      
      s = (char*) argp->variable;
      while (*linep) *s++ = *linep++;
      *s='\0';
      break;
    }

  }
  return(linep);
}

/*----------------------------------------------------------
  Liefert einen Zeiger auf den Eintrag der Argumententabelle
  der mit c korrespondiert (oder Null, falls c nicht in der
  Tabelle ist).
*/
static ARG *findarg(c, tabp, tabsize) char c; ARG *tabp; int tabsize;
{
  for (; --tabsize >= 0 ; tabp++ )
  if (tabp->arg == c ) return tabp;

  return NULL;
}

/*----------------------------------------------------------
  Bearbeite Kommandozeilen-Argumente. Hole alle Kommando-
  zeilenschalter aus argv. Liefere ein neues argc.
*/
int argparse(argc,argv,tabp,tabsize) int argc; char **argv; ARG *tabp; int tabsize;
{
  int nargc;
  char **nargv, *p;
  ARG	*argp;

  nargc = 1 ;
  for(nargv = ++argv ; --argc > 0 ; argv++ )
  {
    if( **argv != '-' )
    {
      *nargv++ = *argv ;
      nargc++;
    }
    else
    {
      p = &argv[0][1];

      while(*p)
       if (argp = findarg(*p, tabp, tabsize)) p=setarg(argp,p);
       else break;
    }
  }
  return nargc ;
}

/* Ende von argpars.c */
