/* quick hack of hercules.  This displays a font, each character after
   another.  Exit with q.
*/

#include <stdio.h>

/* -----------------------------------------------------------------------
   hardware dependent things for hercules cards.  do not look at the code,
   we really need grafics support in the console task of the kernel.
*/

/* internal screen buffer */
char screen[0x8000];
int color;

/* clear the internal screen */
void clrscr()
{
  unsigned n;
  char *s=screen;

  for (n=0; n<0x8000; n++) *s++=0;
}

char setp[8]={128,64,32,16,8,4,2,1};
char clrp[8]={127,191,223,239,247,251,253,254};

/* set a dot on the internal screen */
void setdot(x,y) unsigned int x,y;
{
  if (x<720 && y<348)
  {
    if (color) screen[((y&3)<<13) + 90 * (y >> 2) + (x >> 3)] |= setp[x&7];
    else screen[((y&3)<<13) + 90 * (y >> 2) + (x >> 3)] &= clrp[x&7];
  }
}

/* get a dot from the internal screen, maybe we need this function in later
   version.
*/
int getdot(x,y) unsigned int x,y;
{
  if (x<720 && y<348)
  return (screen[((y&3)<<13) + 90 * (y >> 2) + (x >> 3)] & setp[x&7]);
}

#define TEXT_PAGE  0
#define GRAF_PAGE0 1
#define GRAF_PAGE1 2

/* this are the video ports */
#define INDEX_REG  0x3b4
#define DATA_REG   0x3b5
#define MODE_REG   0x3b8
#define CONFIG_REG 0x3bf

/* activate video signal */
#define ACTIVE     8

graficmode(mode) int mode;
{
  static int
  grfval[12]={0x35,0x2d,0x2e,0x7,0x5b,0x02,0x57,0x57,0x2,0x3,0x0,0x0},
  txtval[12]={0x61,0x50,0x52,0xf,0x19,0x06,0x19,0x19,0x2,0xd,0x0,0xc};
  int regsel;

  switch (mode)
  {
    case GRAF_PAGE0 :
    case GRAF_PAGE1 :
    {
      port_out(MODE_REG,(mode==GRAF_PAGE0 ? 0x02 : 0x82));
      for (regsel=0; regsel<12; regsel++)
      {
        port_out(INDEX_REG,regsel);
        port_out(DATA_REG,grfval[regsel]);
      }
      port_out(CONFIG_REG,3);
      port_out(MODE_REG,(mode==GRAF_PAGE0 ? 0x02 : 0x82) | ACTIVE);
      break;
    }

    case TEXT_PAGE:
    {
      port_out(MODE_REG,0x20);
      for (regsel=0; regsel<12; regsel++)
      {
        port_out(INDEX_REG,regsel);
        port_out(DATA_REG,txtval[regsel]);
      }
      port_out(CONFIG_REG,1);
      port_out(MODE_REG,0x20 | ACTIVE);
    }

  }
}

/* copy the internal screen to the video memory */
refreshvideo(mode)
{
  int outfd;

  outfd = open("/dev/mem", 1);
  if (outfd >=0)
  {
    lseek(outfd, (long)(mode == GRAF_PAGE0 ? 0xb0000 : 0xb8000), 0);
    /* write can't handle blocks larger than 32767 bytes */
    write(outfd, screen, 16384);
    write(outfd, screen+16384, 16384);
    close(outfd);
  }
}

int overlay;

/* draws a line in physical coordinates */
void do_line(x1,y1,x2,y2) int x1,y1,x2,y2;
{
  int x,y,z,dx,dy,dz,i1,i2,ox,oy;
  
  dx=x2-x1; if (dx<0) dx = -dx;
  dy=y2-y1; if (dy<0) dy = -dy;
  if (dx+dy==0) return;
  if (x1<x2)
  {
    x=x1; y=y1;
    if (y1>y2) z = -1; else z=1;
  }
  else
  {
    x=x2; y=y2;
    if (y2>y1) z = -1; else z=1;
  }
  if (dx>dy) i2=dx; else i2=dy;
  for (ox=0; ox<=overlay; ox++) for (oy=0; oy<=overlay; oy++) setdot(x+ox,y-oy);
  if (dx==0 || dy==0)
  for (i1=1; i1<=i2; i1++)
  {
    if (dx==0) y+=z; else x++;
    for (ox=0; ox<=overlay; ox++) for (oy=0; oy<=overlay; oy++) setdot(x+ox,y-oy);
  }
  else
  {
    dz=i2 >> 1;
    for (i1=1; i1<=i2; i1++)
    {
      if (dz<dx) { dz+=dy; x++; }
      if (dz>=dx) { dz-=dx; y+=z; }
      for (ox=0; ox<=overlay; ox++) for (oy=0; oy<=overlay; oy++) setdot(x+ox,y-oy);
    }
  }
}

/* The structure of one character is its width, Number of following pairs,
   x,y to start with, and the pairs byself.  These data are stored in ASCII
   into the font files and binary in memory.
*/

#define PENUP		0x7fff

struct pair
{
  int x,y;
};

struct pair vectors[200];

readletter(fp) FILE *fp;
{
  static char ln[85],*s;
  struct pair *font;
  int i,leftmargin;

  font=vectors; 
  fgets(ln,85,fp);
  if (*ln=='\n') fgets(ln,85,fp);
  font->y= (ln[5]==' ' ? 0 : ln[5]-'0');
  font->y=10*font->y+(ln[6]==' ' ? 0 : ln[6]-'0');
  font->y=10*font->y+ln[7]-'0'-2;
  leftmargin='R'-ln[8];
  s=ln+10;
  for (i=1; i<=font->y+1; i++)
  {
    if (*s=='\n') { s=ln; fgets(ln,85,fp); }
    if (*s==' ') font[i].x=PENUP;
    else font[i].x= *s-'R' + leftmargin;
    s++;
    font[i].y= 9 - (*s++-'R');
  }
  return 30;
}

sizeletter(c,b) int c,b;
{
  int count;
  struct pair *font;

  font= &vectors[1];
  count=1+vectors[0].y;
  while (count--)
  {
    if (font->x!=PENUP)
    {
      font->x=(int)(((long)c*(long)font->x)/(long)b);
      font->y=(int)(((long)c*(long)font->y)/(long)b);
    }
    font++;
  }
}

drawletter(x,y) int x,y;
{
  static int next_x, cx, cy, num;
  struct pair *c;
  
  c=vectors; num=c->y; c++;
  cx=x+c->x; cy=y-c->y; c++;
  while (num-->0)
  {
    if (c->x == PENUP) { c++; num--; } else do_line(cx,cy,x+c->x,y-c->y);
    cx=x+c->x; cy=y-c->y; c++;
  }
}

int pixel_inch;

/* Initialize the font 'name' with an pointsize of 'points' and compute overlay
factor for getting filled letters in each size. */
void showletter(fd,points) FILE *fd; int points;
{
  int M;
  
  M=readletter(fd);
  sizeletter(points*pixel_inch,72*M);
  overlay=(int)((points*pixel_inch)/(72*M));
  clrscr();
  drawletter(300,200);
  refreshvideo(GRAF_PAGE1);
}

main(argc,argv) int argc; char **argv;
{
  char name[128];
  int i;
  FILE *fd;
  
  fd=fopen(argv[1],"r");
  pixel_inch=72;
  graficmode(GRAF_PAGE1);
  color=1;

  while (1)
  {
    showletter(fd,100);
    if (getchar()=='q') break;
  }

  graficmode(TEXT_PAGE);
}
