/* procfont.c - device independent functions to read and use the hershey
   fonts.
*/
           
#define VECTORS		5500	/* max. number of vectors per font */
#define MAXCHARS	122	/* number of characters in each font */

/* The structure of one character is its width, Number of following pairs,
   x,y to start with, and the pairs byself.  These data are stored in ASCII
   into the font files and binary in memory.
*/

#define PENUP		0x7fff	/* like a plotter: lift the pen, don't draw */

struct pair
{
   int x,y;
};

/* read a letter from a hershey-font and convert it into vectors.  return value
   is a pointer which points after the last byte of the letter.
*/   
struct pair *rf_char(fp,font) FILE *fp; struct pair font[];
{
  static char ln[85],*s;
  int i,leftmargin;
 
  if (fgets(ln,85,fp)==NULL) return font;
  font->y= (ln[5]==' ' ? 0 : ln[5]-'0');
  font->y=10*font->y+(ln[6]==' ' ? 0 : ln[6]-'0');
  font->y=10*font->y+ln[7]-'0'-2;
  font->x= ln[9]-ln[8];
  leftmargin='R'-ln[8];
  s=ln+10;
  for (i=1; i<=font->y+1; i++)
  {
    if (*s=='\n') { s=ln; if (fgets(ln,85,fp)==NULL) return font; }
    if (*s==' ') font[i].x=PENUP;
    else font[i].x= *s-'R' + leftmargin;
    s++;
    font[i].y= 9 - (*s++-'R');
  }
  return &font[i];
}

struct pair vectors[VECTORS];

/* read a whole hershey-font and convert it into vectors.  return value is the
   size of the font.  this is fixed to 30, but if s.o. know a better way to
   compute this, do it.
*/
int readfont(name) char *name;
{
  FILE *fp;
  struct pair *ch,*width;
  int i;
  
  fp=fopen(name,"r");
  ch=vectors;
  for (i=0; i<MAXCHARS; i++)
  {
    if (i=='M'-' ') width=ch;
    ch=rf_char(fp,ch);
  }
  ch->x=ch->y=PENUP;
  fclose(fp);
  return (30);
}  

/* offset contains the offsets for each character in font */
int offset[MAXCHARS];

/* changes font size and computes offsets */
makefont(c,b) unsigned int c,b;
{
  int num,count,*ofs;
  struct pair *font;

  num=0; font=vectors; ofs=offset;
  while (font->x!=PENUP && font->y!=PENUP)
  {
    *ofs++=num;
    count=1+font->y;
    font->x=(int)(((long)c*(long)font->x)/(long)b);
    font++; num++;
    while (count--)
    {
      if (font->x!=PENUP)
      {
        font->x=(int)(((long)c*(long)font->x)/(long)b);
        font->y=(int)(((long)c*(long)font->y)/(long)b);
      }
      font++; num++;
    }
  }
}

/* x,y are left bottom edge of a character */
int drawchar(x,y,l) int x,y,l;
{
  static int next_x, cx, cy, num;
  static struct pair *c;

  c = &vectors[offset[l]];
  next_x=x+c->x; num=c->y; c++;
  cx=x+c->x; cy=y-c->y; c++;
  while (num-->0)
  {
    if (c->x == PENUP) { c++; num--; } else do_line(cx,cy,x+c->x,y-c->y);
    cx=x+c->x; cy=y-c->y; c++;
  }
  return next_x;
}
