.\"{{{}}}
.ds M M\s-2ROFF\s0
.ds CF 3rd January 1991
.\"{{{  Title and Abstract
.TL
Writing with -ms
.AU
Michael Haardt
.AI
Auf der H\(oern 40
5100 Aachen
Germany
.AB
This document explains how to use the -ms macros.  They are a good help for
writing documents, because they do a lot of work by themselves.  You can
concentrate yourself on writing instead of doing things that your computer
is capable of doing itself,
for example writing a table of contents or numbering chapters and sections.
The following pages are a tutorial for those people, who know already know a
little about the roff family, but who never used them for writing a text.
.AE
.\"}}}
.\"{{{  What are macros?
.NH 1
What are macros?
.\"{{{  A first example of a macro
.PP
Macros are an abbreviation for a group of basic commands.  For example, if you
want to make a paragraph, you just write:
.DS
\&... end of the paragraph.
\&.PP
This is where the new paragraph begins.
.DE
\&.PP represents a group a \*M requests which you do not need to know.  If you are
interested in how such a macro looks like, just have a look at \fI/usr/lib/mmac/mmac.s\fP.
All -ms macros defined are there.  Do not despair, if you do not understand
them.  Using macros is much easier than writing them.
.\"}}}
.\"{{{  Macros with parameters
.PP
Some macros have parameters.  The next example shows a paragraph with a numbered
header.
It is advisable to play around a little with the examples given in this
document in order to get used to \*M.
Just try to type in the next example:
.DS
\&... end of the paragraph.
\&.NH 1
The first numbered header
\&.PP
This is where the new paragraph begins.
.DE
\.NH is a macro which has a one as its parameter.  This macro is very useful,
because it can number chapters, sections, subsections etc. with a depth up to
five levels.  Level 1 means, that it looks like "1. The first...", level 2
will produce "1.1. The first..." and so on.  It also sets the number of
sections to one, if you enter a new chapter and uses a suitable font size for
the header.  .PP ends the header and begins the first paragraph.
.\"}}}
.\"{{{  Text displays
.PP
Now you know enough for writing a little text with the -ms macros.  Sometimes
you do not require \*M to fill the lines and adjust them.  An example are
the examples above: They are indented and not adjusted.  Another example can
be a table.  These things are named text displays and there are two macros
for beginning and ending them:
.DS
\&.DS
\\&... end of the paragraph.
\\&.NH 1
The first numbered header
\\&.PP
This is where the new paragraph begins.
\\&.DE
.DE
The .DE macro have an optional argument.  If you use .DE C, the text display
will be centered.
.\"}}}
.\"{{{  Macros for titlepages
.PP
You might perhaps want
a nice title like on the first page of this document.  It's understood that -ms
has some macros for doing this.  This will be the last example in this chapter,
because you should be able to understand the next chapter which describes all
-ms macros after reading this one.
.DS
\&.TL
Writing with -ms
\&.AU
Michael Haardt
\&.AI
Auf der H\(oern 40
5100 Aachen
Germany
\&.AB
This document explains ...
\&.AE
\&.NH 1
What are macros? ...
.DE
These are the used macros and their meaning:
.DS
\&.TL begins the title and sets some default values for you document
\&.AU is optional and begins the author's name
\&.AI begins the author's institute or adress
\&.AB begins the abstract
\&.AE ends the abstract
.DE
.\"}}}
.\"}}}
.\"{{{  Description of all macros
.NH 1
Description of all macros
.PP
This chapter describes all macros and explains their arguments, if any.
Each macro is used like described above.  You will be able to write texts
a few pages long after reading this chapter.
.IP Macro 1i
Explanation
.IP \&.DT 1i
Default tabs.  Set tab stops each 0.5 inch from 0.5 inch to 6 inch.
.IP \&.TL 1i
Title.  Begins a title with a suitable font etc.
.IP \&.AU 1i
Author.  Begins the author's name.
.IP \&.AI 1i
Author's institute or adress.
.IP \&.AB 1i
Abstract.  An optional argument can be "no" for no
abstract title or "Name of the abstract" for getting this as the new abstract.
The default title is just "ABSTRACT".
.IP \&.AE 1i
Abstract end.
.IP \&.BP 1i
Begin page.  Begins a new page.  Its difference to .bp (mroff manual) is that
it prints headers and footers like on other pages, whereas .bp will not.
.IP \&.SH 1i
Section header.  Begins a section header without a number and does not change
the font.  It must be ended with an paragraph command like .PP or .LL etc.
.IP "\&.NH level" 1i
Numbered header.  Begins a numbered section header with suitable font size.
You can use up to 5 levels.  An X as argument holds the current level instead
of increasing it.
.IP \&.LP 1i
Left block paragraph.  Makes an paragraph where the first line is not indented.
.IP \&.PP 1i
Same as .LP, but the first line will be indented.
.IP "\&.IP tag in" 1i
Indented paragraph.  You can use an optional tag and a optinal measure of
indentation.
.IP \&.QP 1i
Quoted paragraph.  This will indent the left and right margin.  Like all paragraphs,
it will be ended with another paragraph or header macro.
.IP \&.DS 1i
Display start.  An optional argument is C for centering the display.
.IP \&.DE 1i
Display end.  Ends a display beginning with .DS.
.IP \&.XS 1i
Start a table of contents.  It will create a file named contents.ms which
contains a table of contents.  This file must be formatted with \*M.  This
is not a standard -ms macro, so don't use it if portability of your document
is important.
.IP \&.XC 1i
Prints its argument when invoked and puts it into the table of contents too.
It should be used as a prefix for the line which follows .NH.  This is not a
standard -ms macro.
.IP \&.I 1i
If used with an argument, this argument will be printed in italics.  Otherwise,
it switches to italic font until ended by another font macro.
.IP \&.B 1i
Same as .I, but uses the bold font.
.IP \&.R 1i
Switches back to roman text and does not allow any arguments.
.PP
Now you know all -ms macros.  You should try to use them instead of basic
\*M requests, like described in the \*M manual.  If you only use them, your text
should be compatible with most of other roff formatters.  This is important if
you write documents which should be transported to other UNIX systems or which
you want to post in internet etc.  Note that these are not all -ms macros, since
I am still working at a better package.
.\"}}}
.\"{{{  String variables
.NH 1
String variables
.PP
This chapter describes string variables used by -ms, their use and how you can
define your own variables.  You might wonder how you can produce effects
like the capitalization in the word \*M.  This is just a user defined string
variable.  A string variable has a name and will be replaced by its value
whenever you use it.  This is how \*M will be defined:
.DS
\&.ds M M\\s-2ROFF\\s0
.DE
The \\s escape sequence reduces and resets the point size.  Escape sequences
are explained in the \*M manual.  It is called by writing \\*M, because \\*
begins a string variable with a name of one character.  If you want to use
a variable with a two character name, use:
.DS
\&.ds MR M\\s-2ROFF\\s0
.DE
and call it by \\*(MR.  There are a lot of string variables used in -ms.
Their use will allow to changed footers and headers like the table
explains:
.DS
LH left justified part of the header
CH centered part
RH right part
LF left part of the footer
CF centered part
RF right part
.DE
Something like .ds CF " will define the centered part of the footer to an
empty string.  A heading doublequote before the value allows to have heading
blanks.  An \\\\n% will be replaced by the page number.  Some other predefined
variables are:
.DS
DW day of the week, e.g. Mon, Tue etc.
MO month, e.g. January etc.
Dy month and day, e.g. March 4
Yr year, e.g. 1990
dY month, day and year, e.g. March 4, 1990
DY day, month and year, e.g. 4 March 1990
.DE
If this tutorial satisfied its purpose, you should be able to use the -ms macros for
writing your documents without learning everything about \*M.  If not, tell me
what you do not understand or what explanations should be improved.
I shall be most obliged to reply to any queries.
.\"}}}
