.\"{{{}}}
.ds M M\s-2ROFF\s0
.ds CF 8th December 1990
.\"{{{  Title and abstract
.TL
Part 1 : \*M 1.0 Manual
.AU
Michael Haardt
.AI
Auf der H\(oern 40
5100 Aachen
Germany
.AB
\*M is a UNIX troff styled text formatter.  It is very small and should
run on every MINIX implementation.  It has many fonts, point sizes and
many special characters and is a nice system for writing letters,
reports and manuals.  There are \-ms-like macros for documents and a
preprocessor for writing in Hindi (one of the many Indian languages).
This document explains the installation, all basic \*M requests, some
utilities and the Hindi preprocessor.
.AE
.\"}}}
.\"{{{  What is MROFF and its limitations
.\"{{{  What is MROFF
.NH 1
What is \*M?
.PP
\*M is one member of the big family of roff text formatters.
It is neither
one of the many clones who have their origin in Kernighan & Plauger's roff
as described in the book "Software tools" nor a full troff.
I wrote it as an text formatter system which allows use of my own fonts and
is open for extensions.  \*M is the basic tool for a project which is known
as the "Hindi project" in soc.culture.indian (Yes! Here is it!).
For people who don't read my postings in this group, some Indians and I are
working on a flexible and open system which allows Hindi, an Indian
language, to be written on a normal computer system.
I also use it together with MicroEMACS as my favorite word processor.
A preprocessor mprep is provided to allow texts to be checked by the minix
spell checker.
.PP
\*M uses the Hershey fonts,
which means that there are a lot of fonts.  You can develop your own fonts,
although it big work.  The Hershey fonts are vectorized outline fonts.
These fonts are well ??? to dot matrix printers with resolutions less than or
equal to 360 dpi; higher resolutions don't look too nice.
They were developed by Dr. A. V. Hershey.  You should read the COPYRIGHT files
which explain the conditions for copying and using them and \*M.
I got the
original font material via FTP from our local comp.sources.unix archive server.
This is the reason, why the original fonts are not included.
I worked out the \*M fonts by sorting and completing the original fonts.
.PP
\*M requires a hard disk because it and its printer drivers produce large
temporary files which will be very slow with a floppy disk drive.  Unfortunately,
\*M is not very fast even if you use a hard disk.  Perhaps somebody improve the
code without getting into conflict with the brain damaged 64K+64K limit.
.\"}}}
.\"{{{  Its limitations
.SH
Limitations and most important missing features
.PP
This is dealt with here, so that experienced users can now
decide if they want to work with \*M or not.
Expressions can only be constant numeric values, numeric registers or
strings.
Diversion works differently compared to UNIX troff and is less
powerful.  The .if request can only compare strings and has no \\{ and
\\} (begin and end for .if).  The macro handling and variable expansion is a little bit
different.  Not all requests are implemented and some work
different.  The output is not C.A.T. or ditroff, I use a absolutly new
device independent and simple language.  Position and input traps are
less powerful and work not exact like in troff.  There is no automatic
hyphenation.  A language sensitive
preprocessor could be written to do this.  The fonts are the Hershey fonts, not the vfont
format.  Fields are not implemented and there is no tbl, eqn or pic.
Many of the escape sequences are missing and special characters are
implemented with \\x and \\(xy, not with \\'xyz'.  Most of them are
missing.  The fonts include other letter tables than troff.
\fBTo summarize all:  \*M is not UNIX troff and does not try to emulate it.\fP
Are you
still reading this document or have you decided to remove this and send
a few hundred flames? (Please do not flame, you haven't paid for this!)
Ok, this are all disadvantages I know.  If you are still reading
this document, enjoy the next sections.
.\"}}}
.\"}}}
.\"{{{  Compilation and installation
.NH 1
Compilation and Installation
.PP
After you get all the sources for \*M, I suggest that you create the following
directories for it:
.DS
/usr/src/local/mroff with subdirectories
.in +5
doc for documentation and manuals
driver for device drivers
misc for mprep and grafic output pager
mroff for mroff sources byself
.in
.DE
The Makefiles are for PC MINIX 1.5.10 ACK
Compiler.  Check the options in the makefiles (e.g. -F for those with little
memory) and everything should compile without warnings.
.PP
Installing \*M is easy.  Just create dictories named /usr/lib/mmac
for the macro files and /usr/lib/hfont for the fonts.  I suggest something like
/usr/local for the \*M binaries byself, but this depends on your local system.
The hercules driver should have SETUID, so that you can use it even if you are
not logged in as root.
.\"}}}
.\"{{{  Using MROFF
.NH 1
Using \*M
.PP
The next pages explain the features of \*M, but it is assumed that you know
the roff family in general.  If you don't, you should look at a cheap
UNIX guide.  Most of them explain basics of roff.  You should be able to
understand this document after reading them.
.\"{{{  Escape sequences
.NH 2
Escape sequences
.PP
Some functions are invoked by using escape sequences.  Usually, the escape
character is a backslash.  The following escape sequences are implemented:
.if t .ta 1.5i
.DS
\e\e\t- backslash
\\e\t- escape
\\'\t- '
\\`\t- `
\\-\t- minus
\\\t- blank which is part of a word
\\0\t- blank with size of a digit
\\|\t- blank with size 1/6 m
\\^\t- blank with size 1/12 m
\\&\t- blank with size 0
\\%\t- soft hyphen
\\(xx\t- special character xx
\\*x\t- string variable x
\\*(xx\t- string variable xx
\\d\t- move 1/2 m down
\\fx\t- font x
\\fN\t- font no. N
\\nx\t- numeric register x
\\n(xx\t- numeric register xx
\\t\t- tabulator
\\u\t- move 1/2 m up
\\zc\t- print c with size 0
.DE
.if t .DT
.\"}}}
.\"{{{  Basic requests
.NH 2
Basic requests
.PP
These are elementary requests for \*M.  The following requests will use their
previous values, if they are used
without arguments: .in, .po, .ll, .ls, .rm, .vs, .ps and .ft, if you use 'P'.
If you don't want .sp or .bp to cause breaks, you could use 'sp and 'bp.
I use "M" in the following description to describe a measure which can be given
in centimeter, inch, em, en, points or vertical unit and I use "N" to describe
a number which can not be specified in other units.  In most requests, it is
allowed to use +N or -N to increase or reduce the current value.
.PP
These requests are documented to allow the writing and maintenance of macros.
Documents should be, as far as possible written with \-ms or \-man or other
macros, using these requests for special effects.
.\"{{{  Font requests
.NH 3
Font requests
.IP \fBRequest 1i
Explanation\fP
.IP ".ps N" 1i
Point size set to N.  One point is 1/72 inch.  Alternatively imbed \\sN.
Default is 10 point.
.IP ".ft F" 1i
Font changed to F.  Alternatively, imbed \\fF.  F can be R (Roman), B (Bold),
I (Italics), S (Special), 4 (second special) or P for the previous font.
Default is Roman.
.\"}}}
.\"{{{  Page control
.NH 3
Page control
.IP \fBRequest 1i
Explanation\fP
.IP ".pl M" 1i
Page length set to N.  This does not affect other traps set before.
.IP ".bp N" 1i
Begin new page.  The current page is ejected and a new page is begun.  If
N is given, the new page number will be N.
.IP ".po M" 1i
Page offset.  The current left margin is set to M.  Default is 1 inch.  This
is a offset for the \&.in request.
.IP ".ne M" 1i
Need M vertical space.  If the distance to the next trap position or end of
the page, if no traps used, is less than N, a new page is begun.
.IP ".mk" 1i
Mark the current vertical position on an internal stack.
.IP ".rt" 1i
Return to a marked position.
.\"}}}
.\"{{{  Text adjusting
.NH 3
Text adjusting
.IP \fBRequest 1i
Explanation\fP
.IP ".br" 1i
Break.  The filling of the input line currently being collected is stopped
and the line is output with left margin adjustment.  Blank lines also cause
a break.
.IP ".fi" 1i
Fill mode on.  This causes a break.
.IP ".nf" 1i
Fill mode off.  This causes a break.
.IP ".ad c" 1i
Select line adjustment.  c can be one of l (left margin), r (right margin),
b (both margins) or c (centered).  Nofill mode causes left margin adjusting
to be switched on.  Both margins is the default.
.IP ".na" 1i
Same as .ad l.
.IP ".ce N" 1i
Center the next N input text lines.  N=0 switches centering off.
.\"}}}
.\"{{{  Vertical spacing
.NH 3
Vertical spacing
.IP \fBRequest 1i
Explanation\fP
.IP ".vs M" 1i
Set vertical base-line spacing size V.  Do not forget that \&.ps expects a
numeric value which is interpreted as points whereas \&.vs M expacts a measure.
If you want to use point, you mush use \&.vs Mp.
.IP ".ls N" 1i
Line spacing set to N.  N-1 Vs are appended to each output text line.  Default
is 1 V.
.IP ".sp M" 1i
Vertical space M.  \&.sp |M spaces absolute to position M.  \&.sp -M spaces
to M before end of page.
.\"}}}
.\"{{{  Line length and indenting
.NH 3
Line length and indenting
.IP \fBRequest 1i
Explanation\fP
.IP ".ll M" 1i
Line length is set to M.
.IP ".rm M" 1i
Right margin is set to M.  This does not influence the line length, which
determines centering.
.IP ".in M" 1i
Indent is set to M.  The indent is prepended to each output line.
.IP ".ti M" 1i
Temporary indent.  The next output text line will be indented relative to
the current indent.  The resulting total indent may not be negative.  This
does not change the current indent.
.\"}}}
.\"{{{  Macros, strings and traps
.NH 3
Macros, strings and traps
.IP \fBRequest 1i
Explanation\fP
.IP ".de xx" 1i
Define the macro xx.  The contents of the macro begin on the next input line.
The definition is terminated with "..".
.IP ".ds xx string" 1i
.sp
Define a string variable xx containing string.  Any initial doublequote in
string is stripped off to permit initial blanks.
.IP ".wh M xx" 1i
Install a trap to invoke xx at page position M; a negative M will be interpreted
as a distance from the page bottom.
.IP ".it N xx" 1i
Set an input line count trap to invoke the macro xx after N lines of text have
been read.
.IP ".em xx" 1i
The macro xx will be invoked when all input has ended
.\"}}}
.\"{{{  Numeric registers
.NH 3
Numeric registers
.IP \fBRequest 1i
Explanation\fP
.IP ".nr R N n" 1i
The number register is assigned the value N.  The increment for
auto-incrementing is set to n.
.NH 3
Tabs
.IP \fBRequest 1i
Explanation\fP
.IP ".ta M1 M2 ..." 1i
Set tab stops.  The stop values are seperated by spaces.
.IP ".tc c" 1i
The tab repetition character becomes c.
.\"}}}
.\"{{{  Three parts titles
.NH 3
Three part titles
.IP \fBRequest 1i
Explanation\fP
.IP ".tl 'l'c'r'" 1i
The strings l, c and r are left-adjusted, centered and right-adjusted in the
current title length.  Any of the strings may be empty.  The first non-blank
character after \&.tl id used as the string delimiter.  The page number can
be used by \\\\n%, instead of only % like in troff.
.IP ".lt M" 1i
Length of title set to M.  The line length and the title length are independent.
Indents do not influence titles, page offsets do.
.\"}}}
.\"{{{  Diversions and files
.NH 3
Diversions and files
.IP \fBRequest 1i
Explanation\fP
.IP ".di name" 1i
Divert output to file \fIname\fP.  All text read is copied to this file, until
a \&.di occurs.  Macros, string variables and numeric registers are expanded.
This works differently to troff.
The next \&.di name request will append text to the same file.  You can use more
diversions to get files for table of contents, figures etc.
.IP ".so name" 1i
Includes contents of file \fIname\fP.  Includes can be nested.  After the file is included, \*M
continues formatting with the next line after the \&.so request.
.IP ".rd prompt" 1i
\*M stops formatting, shows the optional prompt and you can type in text which
will be ended by a empty line.
This text will be inserted in your document and formatting continues.
.\"}}}
.\"{{{  The .if request
.NH 3
The .if request
.IP \fBRequest 1i
Explanation\fP
.IP ".if Cond Req" 1i
.sp
If Cond is true, execute Req.  Cond can be e,o,n,t.  e is true if the current
pagenumber is even, o if it is odd.  n is always false in \*M, whereas t
is always true.  These switches stand for N\s-2\ROFF\s0 and \*M and are used
to handle differences between these text formatters.  Cond can also be
"string1"string2" and is true when string1 is equal string2.  An ! before
the condition is allowed to negate it.
Req is a \*M request.  Nested \&.if requests are allowed.
.\"}}}
.PP
You should use
macro calls to write your documents, if you don't want to get grey hairs.
Look at the tutorial "Writing with -ms" for learning how you can write simple
documents in a very easy way.
.\"}}}
.\"}}}
.\"{{{  Fonts in MROFF
.NH 1
Fonts in \*M
.PP
You can mount other fonts to the positions R, B, I and S by installing
a file named \fI.mroffrc\fP in your document directory.  If there is no such
file, \*M will look at your home directory and use its default fonts if it
fails again.  .mroffrc just contains the names of the fonts, one per line.
Default is:
.DS
roman.s
roman.d
italic.d
special.s
.DE
The special.s font contains mathematical and other special characters.
It could be expanded, because there are less characters defined than in
other fonts.  You should only use the following table to print its
characters:
.DS
.ta 0.8i 1.5i 1.8i 2.5i 2.8i 3.5i 3.8i 4.5i 4.8i
\(de\t\\(de\t\(pc\t\\(pc\t\(bu\t\\(bu\t\(fs\t\\(fs
\(lc\t\\(lc\t\(ci\t\\(ci\t\(sr\t\\(sr\t\(le\t\\(le
\(re\t\\(re\t\(as\t\\(as\t\(+-\t\\(+-\t\(-+\t\\(-+
\(mu\t\\(mu\t\(do\t\\(do\t\(di\t\\(di\t\(!=\t\\(!=
\(==\t\\(==\t\(<=\t\\(<=\t\(>=\t\\(>=\t\(pt\t\\(pt
\(ap\t\\(ap\t\(sb\t\\(sb\t\(cu\t\\(cu\t\(sp\t\\(sp
\(ca\t\\(ca\t\(mo\t\\(mo\t\(->\t\\(->\t\(ua\t\\(ua
\(<-\t\\(<-\t\(da\t\\(da\t\(is\t\\(is\t\(ic\t\\(ic
\(if\t\\(if\t\(sc\t\\(sc\t\(dg\t\\(dg\t\(dd\t\\(dd
\(ex\t\\(ex\t\(MU\t\\(MU\t\(SU\t\\(SU
.DT
.DE
.PP
If you mount another font at the position S, these characters are no longer
available, because mroff switches automatically to font S and back if you
use them.
.PP
Note that you can refer to the positions R, B, I and S by the numbers 0,1,2 and
3.  There is also a position 4, which has no assigned letter.  It is used
for mounting another special font.  It has roman.s as default font.
.PP
Look at Driver.doc for a complete description of all available fonts.  There
are more informations about them.
.\"}}}
.\"{{{  Spell checking
.NH 1
Spell checking
.PP
You can't use the standard MINIX prep for preparing texts in spell, because
it does not understand all \*M features.  Therefore, I wrote \fImprep\fP.
The new spell shell script looks like:
.DS
mprep $1 | sort -u | comm -23 - /usr/dict/$DICTIONARY
.DE
Note, that I do not use the standard MINIX directory for my dictionaries,
because \fI/usr/dict\fP is more useful.  In my system, there are two dictionaries
named "english" and "german".  Unfortunately, \fIlook\fP does not like multiple
dictionaries, but another shellscript performs a small look which works well:
.DS
grep \\^$1 /usr/dict/$DICTIONARY
.DE
If you want to have better tools for spell checking, you should write them and
post them on internet.
.\"}}}
.\"{{{  Minor utilities
.NH 1
Minor utilities
.PP
\fImroffconv\fP converts "Umlaute".  It is only included it because it was
there.  It is small, uncomfortable and sometimes useful.
.ne 5
.DS
mroffconv translates IBM "Umlaute" to mroff
mroffconv -a from german ASCII to mroff
mroffconv -t from mroff to IBM
.DE
\fIpre\fP is a pager for grafic output from mroff.  It can scroll using the
j and k keys or show the other half screen of a DIN A4 page using Enter.
Space brings you to the next page and q exits the pager.
The following sequence is very useful:
.DS
mroff file >foo
pre <foo | hgc
.DE
You should use foo as a temporary file for getting any warnings or errors from
mroff.  If you are sure that there will be none, you can use one pipe.
The pager is a help for previews, but it could be improved in several
points.
.\"}}}
.BP
