.\"{{{}}}
.\"{{{  Title and abstract
.TL
Part 2 : The Hindi project
.AU
Michael Haardt
Angelica R. Gupta
Monika Pandey
.AB
This chapter describes the Hindi preprocessor, which allows one to write in
Hindi (one of the many Indian languages) with \*M.  It describes the
problems caused by a non-european language and the solutions we found
for them.  It also explains a few things about Hindi in general, which
are known by almost everyone who speaks Hindi, but are probably new for
europeans who are interested in this project.
.AE
.\"}}}
.\"{{{  The Hindi preprocessor
.NH 1
The Hindi preprocessor
.br
.\"{{{  History of the Hindi project
.NH 2
History of the "Hindi project"
.PP
The first thoughts of writing Hindi on our computers came into being in
July 1990.  The general opinion was, that it would be an impossible
feat.  My first step was to create a small download font
to print some Hindi letters and to test various means of obtaining
the input.  At this point, some friends of mine (Indians) realized, that we
could write such a program.  The next step was, that Angelica
and Monika tought me the basics of Hindi.  We considered different ideas
and created the transliteration table for the alphabet and within a few
weeks, we knew how to realize the project in general.  This was the
point when I made a posting in the internet newsgroup
soc.culture.indian.  I asked for similiar projects.  I got a lot of
email and the results showed, that though their were a variety of such
projects under development, none of them was ready to use.  There is a font for T\dE\uX,
but nobody seems to be having and using it.  Some people tried to create
did try own standards, but they didn't try to create an open system.
.PP
Anyway, we completed the printer download font and realized that the
output would be better, if we would use a vectorized font with
proportional spacing.  This, and the fact that there is no usable text
formatter on MINIX, initiated me to write \*M, which uses such fonts.
Its basis are the Hershey fonts which are exactly what was required.
After getting into possession of this
tool, I made the vectorized Hindi font and wrote the preprocessor.  Two
months later, everything was completed.
.\"}}}
.\"{{{  How the preprocessor works
.NH 2
How the preprocessor works
.PP
Hindi is one of the many indian languages.  It is
mostly spoken in north India and like many other indian languages, its
roots are Sanskrit.
That is why, one can find many similiarities with other indian
languages.
.PP
Our first idea was to
define a character map so that each ASCII character would represent a Hindi
letter.  But there are too many Hindi characters and input is very difficult if
this way is used.  Our new solution was to define a Roman name for each letter, by
trying to imitate the melody of it, in roman letters.  We really tried
hard to find good names, but there were some problems:
.IP \(bu
Each name
sounds different in each of the different european languages.
.IP \(bu
Some
letters can be spoken by europeans only with great effort and there are no
good names for them.
.IP \(bu
The name must be free of input conflicts.
SH can be SH or S and H, which results in a conflict.  We tried to
eliminate them, but it might be possible to find some loopholes.
.IP \(bu
The name should be
short.
.PP
Most Hindi letters are divided into two groups: Capital letters
and small letters (both including vowels and consonants).  We have used
upper and lower roman letters to describe capital and small letters,
although this has nothing to do with capital and small.  It does not look
very nice, but only lowercase transliterations are longer and cause too many
conflicts.  Some people suggested to add characters like ~, ' or ! to
reduce input, but the result looks worse than with mixed upper- and lowercase.
The above reasons lead us to the following transliterations:
.DS C
.\"{{{  Vowels, capital
.ne 4
Vowels, capital

A=\f4A\fP  AA=\f4B\fP  I=\f4C\fP  II=\f4D\fP  U=\f4E\fP  UU=\f4F\fP
E=\f4G\fP  EE=\f4H\fP  O=\f4I\fP  OO=\f4J\fP  Ah=\f4K\fP
.\"}}}

.\"{{{  Consonants, capital
.ne 10
Consonants, capital

K=\f4L\fP  Kh=\f4M\fP  G=\f4N\fP  Gh=\f4O\fP  am=\f4P\fP
Ce=\f4Q\fP  Cw=\f4R\fP  J=\f4S\fP  Jh=\f4T\fP  Na=\f4U\fP
TT=\f4V\fP  Td=\f4W\fP  D=\f4X\fP  Rh=\f4Y\fP  Nh=\f4Z\fP
T=\f4[\fP  Th=\f4]\fP  Dt=\f4^\fP  Dh=\f4_\fP  N=\f4a\fP
P=\f4b\fP  F=\f4c\fP  B=\f4d\fP  Bh=\f4e\fP  M=\f4f\fP
Y=\f4g\fP  R=\f4h\fP  L=\f4i\fP  V=\f4j\fP
Sh=\f4k\fP  Ch=\f4l\fP  S=\f4m\fP  H=\f4n\fP
Ksh=\f4o\fP  Trh=\f4p\fP  Gy=\f4q\fP
.\"}}}

.\"{{{  Vowels, small
.ne 4
Vowels, small

aa=\f4r\fP  i=\f4s\fP  ii=\f4t\fP  u=\f4u\fP  uu=\f4v\fP
e=\f4w\fP  ee=\f4x\fP  o=\f4y\fP  oo=\f4z\fP  an=\f4{\fP
.\"}}}

.\"{{{  Consonants, small
.ne 6
Consonants, small

k=\f4}\fP  kh=\f4~\fP  g=\f4\fP  gh=\f4\fP
ce=\f4\fP  j=\f4\fP  dn=\f4\fP
t=\f4\fP  th=\f4\fP  dh=\f4\fP  n=\f4\fP
p=\f4\fP  f=\f4\fP  b=\f4\fP  bh=\f4\fP  m=\f4\fP
l=\f4\fP  v=\f4\fP  sh=\f4\fP  ch=\f4\fP
s=\f4\fP  gy=\f4\fP
.\"}}}

.\"{{{  Special characters
Special characters

r=\f4\fP  ad=\f4\fP  ar=\f4\fP  eh=\f4\fP  ae=\f4\fP  ru=\f4\fP  ri=\f4\fP
.\"}}}
.DE
.PP
This is the table of all letters and their names in alphabetical order.
The Hindi preprocessor \fIhpp\fP translates every word in the text letter by
letter to the mapped Hindi letters in the font.  All requests and escape
sequences remain unchanged.  Do not forget on which position the Hindi font
is mounted or you may get funny results.  Hpp knows that letters like e, ee
or u are written over their left neighbour and produces correct escape
sequences.
.PP
Please send us new translation modules, if you write any.
There are no political or ideological reasons
were linked with the fact that we implemented Hindi!
.\"}}}
.\"}}}
.\"{{{  Our group
.NH 1
Our group
.PP
I would like to describe our group and our hardware, so that you can see
what each of us did and how.  I start with the Hindi project, because it
was the most difficult part of \*M.  Two friends of mine, Angelica R. Gupta
and Monika Pandey made the Hindi alphabet and tought me the basics
of Hindi.  All of us thought a lot about how input should be read
in and did the theoretical work together.
.PP
\*M byself was written and thought of by me from the first to the last line.
I also wrote this document and the other manuals, but Angelica, Monika and
another
friend, Andrew proofread them and suggested a few changes here and there.
Andrew also made a beta test of \*M on his machine.
.PP
His machine is an old IBM compatible XT with a 20 MB winchester drive and 640 KB
RAM.  My own machine is an IBM compatible AT with a 386 processor, a 70 MB winchester
drive and 2 MB RAM.  Both computers are running MINIX 1.5.10 with virtual
consoles and shared text segment upgrades.  Both are running in multiuser(!)
processing with some serial terminals connected and MINIX proved that it is
a good and relyable operating system on our machines.
.sp
Michael Haardt, December 1990
.\"}}}
