.SH
Instructions of device independent code
.LP
All device drivers use a simple device independent language, which can be used
by other programs too.  All instructions are in ASCII, except the argument for
the text instruction, which can use characters of the decimal range from 32
up to 255.  This are all instructions:
.IP o 2i
open and init device
.IP q 2i
update and close device
.IP e 2i
erase drawing area
.IP u 2i
update device (do output)
.IP "ffont size" 2i
load 'font' in 'size' dots
.IP ttext 2i
print text t and set cursor to the end of the text
.IP "mx y" 2i
move to x,y
.IP "lx1 y1 x2 y2" 2i
line x1,y1,x2,y2
.IP "cx y" 2i
continue line to x,y
.LP
All measures are in dots equals 1/72 inch.
The first 95 Characters are US-ASCII characters, with ' and ` as apostrophs and
- as a hyphen.  Character 127 (dec.) is the minus character.  There are some
more characters which are called "Umlaute" in German.  If you don't know
German, just skip this paragraph.  It's clear that there are no "Umlaute" in the
greek fonts.   Some ASCII special characters are missing in the cyrillic font,
because cyrillic has 32 letters instead of 26 in the alphabet.
.DS
128 grosses Ae
129 kleines ae
130 grosses Oe
131 kleines oe
132 grosses Ue
133 kleines ue
134 Eszet
.DE
The following fonts are available, each one with "Umlauten":
.DS
roman.s  - without serifs, single lines
roman.d  - without serifs, double lines
roman.c  - with serifs, double lines
roman.t  - with serifs, triple lines

italic.d - with serifs, double lines
italic.t - with serifs, triple lines
.DE
This are special character or foreign fonts:
.DS
greek.s  - single lines
greek.c  - double lines

cyril.c  - double lines

gothgb.t - triple lines

special.s - single lines

hindi.d - double lines
.DE
The following device drivers are available:
.DS
hgc - Hercules grafics card (software scroll!)

oki120 - Okidata ML 391, 8 pin, 120x60 dpi, epson compatible
oki240 - Okidata ML 391, 8 pin, 240x120 dpi, epson compatible
oki180 - Okidata ML 391, 24 pin, 180x180 dpi, epson compatible
oki360 - Okidata ML 391, 24 pin, 360x360 dpi, epson compatible
.DE
Note that you can improve speed, if you only use 8x12 inch paper.  This allows
to half horizontal width (DOTS_PER_ROW) and to double the number of buffers.
.LP
The oki120 driver produces bad output because of its low resolution.  Most 8 pin
printers allow to use oki240, just try it.
