Path: news.funet.fi!fuug!mcsun!hp4nl!star.cs.vu.nl!ast@cs.vu.nl
From: ast@cs.vu.nl (Andy Tanenbaum)
Newsgroups: comp.os.minix
Subject: New cdiff.c with crcs
Message-ID: <10874@star.cs.vu.nl>
Date: 9 Sep 91 10:06:54 GMT
Sender: news@cs.vu.nl
Organization: Fac. Wiskunde & Informatica, Vrije Universiteit, Amsterdam
Lines: 358

It occurs quite frequently that people send me patches without specifying to
what version the patch is relative.  This causes confusion.  One solution
is to use the version of cdiff below.  It includes crcs in the headers,
making it clear what the input file was and what the output file should be.
I suggest that everyone replace their cdiff with this one (or if you can't
for some reason, to always include crcs by hand).

Andy Tanenbaum (ast@cs.vu.nl)

---------------- shar file.  cut here -----
echo x - cdiff.c
sed '/^X/s///' > cdiff.c << '/'
X/* cdiff - context diff			Author: Larry Wall */
X
X/* Cdiff - turns a regular diff into a new-style context diff
X *
X * Usage: cdiff file1 file2
X */
X
X#define PATCHLEVEL 2
X
X#include <sys/types.h>
X#include <sys/stat.h>
X#include <ctype.h>
X#include <fcntl.h>
X#include <stdlib.h>
X#include <string.h>
X#include <time.h>
X#include <unistd.h>
X#include <stdio.h>
X
Xchar buff[512];
X
XFILE *inputfp, *oldfp, *newfp;
X
Xint oldmin, oldmax, newmin, newmax;
Xint oldbeg, oldend, newbeg, newend;
Xint preoldmax, prenewmax;
Xint preoldbeg, preoldend, prenewbeg, prenewend;
Xint oldwanted, newwanted;
X
Xchar *oldhunk, *newhunk;
Xchar *progname;
Xsize_t oldsize, oldalloc, newsize, newalloc;
X
X_PROTOTYPE(int main, (int argc, char **argv));
X_PROTOTYPE(void dumphunk, (void));
X_PROTOTYPE(char *getold, (int targ));
X_PROTOTYPE(char *getnew, (int targ));
X_PROTOTYPE(void *xmalloc, (size_t size));
X_PROTOTYPE(void *xrealloc, (void *ptr, size_t size));
X
X#define Nullfp (FILE*)0
X#define Nullch (char*)0
X#define ENOUGH 300
X#define CRC_END 12
X
Xint main(argc, argv)
Xint argc;
Xchar **argv;
X{
X  char *old, *new;
X  int context = 3;
X  struct stat statbuf;
X  register char *s;
X  char op;
X  char *newmark, *oldmark;
X  char sysbuf1[ENOUGH], sysbuf2[ENOUGH];
X  int len;
X  char *line;
X  int i, fdcrc1, fdcrc2;
X
X  progname = argv[0];
X  oldalloc = 512;
X  oldhunk = (char *)xmalloc(oldalloc);
X  newalloc = 512;
X  newhunk = (char *)xmalloc(newalloc);
X
X  for (argc--, argv++; argc; argc--, argv++) {
X	if (argv[0][0] != '-') break;
X
X	if (argv[0][1] == 'c') context = atoi(argv[0] + 2);
X  }
X
X  if (argc != 2) {
X	fprintf(stderr, "Usage: cdiff old new\n");
X	exit(1);
X  }
X  old = argv[0];
X  new = argv[1];
X
X  sprintf(buff, "diff %s %s", old, new);
X  inputfp = popen(buff, "r");
X  if (!inputfp) {
X	fprintf(stderr, "Can't execute diff %s %s\n", old, new);
X	exit(1);
X  }
X  oldfp = fopen(old, "r");
X  if (!oldfp) {
X	fprintf(stderr, "Can't open %s\n", old);
X	exit(1);
X  }
X  newfp = fopen(new, "r");
X  if (!newfp) {
X	fprintf(stderr, "Can't open %s\n", new);
X	exit(1);
X  }
X
X  /* Build a command to feed to system() to compute the crcs. */
X  strcpy(sysbuf1, "exec crc ");
X  strcat(sysbuf1, old);
X  strcat(sysbuf1, ">tmp.old");	/* sysbuf1 = crc file >tmp.old */
X  strcpy(sysbuf2, "exec crc ");
X  strcat(sysbuf2, new);
X  strcat(sysbuf2, ">tmp.new");	/* sysbuf2 = crc file >tmp.new */
X  system(sysbuf1);
X  system(sysbuf2);
X  fdcrc1 = open("tmp.old", O_RDONLY);
X  fdcrc2 = open("tmp.new", O_RDONLY);
X  sysbuf1[0] = '\0';
X  sysbuf2[0] = '\0';
X  read(fdcrc1, sysbuf1, ENOUGH);
X  read(fdcrc2, sysbuf2, ENOUGH);
X  sysbuf1[CRC_END] = '\0';
X  sysbuf2[CRC_END] = '\0';
X  close(fdcrc1);
X  close(fdcrc2);
X  unlink("tmp.old");
X  unlink("tmp.new");
X
X  fstat(fileno(oldfp), &statbuf);
X  printf("*** %s  crc=%s\t%s", old, sysbuf1, ctime(&statbuf.st_mtime));
X  fstat(fileno(newfp), &statbuf);
X  printf("--- %s  crc=%s\t%s", new, sysbuf2, ctime(&statbuf.st_mtime));
X
X  preoldend = -1000;
X
X  while (fgets(buff, sizeof buff, inputfp) != Nullch) {
X	if (isdigit(*buff)) {
X		oldmin = atoi(buff);
X		for (s = buff; isdigit(*s); s++);
X		if (*s == ',') {
X			s++;
X			oldmax = atoi(s);
X			for (; isdigit(*s); s++);
X		} else {
X			oldmax = oldmin;
X		}
X		if (*s != 'a' && *s != 'd' && *s != 'c') {
X			fprintf(stderr, "Unparseable input: %s\n", s);
X			exit(1);
X		}
X		op = *s;
X		s++;
X		newmin = atoi(s);
X		for (; isdigit(*s); s++);
X		if (*s == ',') {
X			s++;
X			newmax = atoi(s);
X			for (; isdigit(*s); s++);
X		} else {
X			newmax = newmin;
X		}
X		if (*s != '\n' && *s != ' ') {
X			fprintf(stderr, "Unparseable input: %s\n", s);
X			exit(1);
X		}
X		newmark = oldmark = "! ";
X		if (op == 'a') {
X			oldmin++;
X			newmark = "+ ";
X		}
X		if (op == 'd') {
X			newmin++;
X			oldmark = "- ";
X		}
X		oldbeg = oldmin - context;
X		oldend = oldmax + context;
X		if (oldbeg < 1) oldbeg = 1;
X		newbeg = newmin - context;
X		newend = newmax + context;
X		if (newbeg < 1) newbeg = 1;
X
X		if (preoldend < oldbeg - 1) {
X			if (preoldend >= 0) {
X				dumphunk();
X			}
X			preoldbeg = oldbeg;
X			prenewbeg = newbeg;
X			oldwanted = newwanted = 0;
X			oldsize = newsize = 0;
X		} else {	/* we want to append to previous hunk */
X			oldbeg = preoldmax + 1;
X			newbeg = prenewmax + 1;
X		}
X
X		for (i = oldbeg; i <= oldmax; i++) {
X			line = getold(i);
X			if (!*line) {
X				oldend = oldmax = i - 1;
X				break;
X			}
X			len = strlen(line) + 2;
X			if (oldsize + len + 1 >= oldalloc) {
X				oldalloc *= 2;
X				oldhunk = (char *)xrealloc(oldhunk, oldalloc);
X			}
X			if (i >= oldmin) {
X				strcpy(oldhunk + oldsize, oldmark);
X				oldwanted++;
X			} else {
X				strcpy(oldhunk + oldsize, "  ");
X			}
X			strcpy(oldhunk + oldsize + 2, line);
X			oldsize += len;
X		}
X		preoldmax = oldmax;
X		preoldend = oldend;
X
X		for (i = newbeg; i <= newmax; i++) {
X			line = getnew(i);
X			if (!*line) {
X				newend = newmax = i - 1;
X				break;
X			}
X			len = strlen(line) + 2;
X			if (newsize + len + 1 >= newalloc) {
X				newalloc *= 2;
X				newhunk = (char *)xrealloc(newhunk, newalloc);
X			}
X			if (i >= newmin) {
X				strcpy(newhunk + newsize, newmark);
X				newwanted++;
X			} else {
X				strcpy(newhunk + newsize, "  ");
X			}
X			strcpy(newhunk + newsize + 2, line);
X			newsize += len;
X		}
X		prenewmax = newmax;
X		prenewend = newend;
X	}
X  }
X
X  if (preoldend >= 0) {
X	dumphunk();
X  }
X  return(pclose(inputfp) == 0 ? 0 : 2);
X}
X
Xvoid dumphunk()
X{
X  int i;
X  char *line;
X  int len;
X
X  for (i = preoldmax + 1; i <= preoldend; i++) {
X	line = getold(i);
X	if (!line) {
X		preoldend = i - 1;
X		break;
X	}
X	len = strlen(line) + 2;
X	if (oldsize + len + 1 >= oldalloc) {
X		oldalloc *= 2;
X		oldhunk = (char *)xrealloc(oldhunk, oldalloc);
X	}
X	strcpy(oldhunk + oldsize, "  ");
X	strcpy(oldhunk + oldsize + 2, line);
X	oldsize += len;
X  }
X  for (i = prenewmax + 1; i <= prenewend; i++) {
X	line = getnew(i);
X	if (!line) {
X		prenewend = i - 1;
X		break;
X	}
X	len = strlen(line) + 2;
X	if (newsize + len + 1 >= newalloc) {
X		newalloc *= 2;
X		newhunk = (char *)xrealloc(newhunk, newalloc);
X	}
X	strcpy(newhunk + newsize, "  ");
X	strcpy(newhunk + newsize + 2, line);
X	newsize += len;
X  }
X  printf("***************\n");
X  if (preoldbeg >= preoldend) {
X	printf("*** %d ****\n", preoldend);
X  } else {
X	printf("*** %d,%d ****\n", preoldbeg, preoldend);
X  }
X  if (oldwanted) {
X	printf("%s",oldhunk);
X  }
X  oldsize = 0;
X  *oldhunk = '\0';
X  if (prenewbeg >= prenewend) {
X	printf("--- %d ----\n", prenewend);
X  } else {
X	printf("--- %d,%d ----\n", prenewbeg, prenewend);
X  }
X  if (newwanted) {
X	printf("%s",newhunk);
X  }
X  newsize = 0;
X  *newhunk = '\0';
X}
X
Xchar *getold(targ)
Xint targ;
X{
X  static int oldline = 0;
X
X  while (fgets(buff, sizeof buff, oldfp) != Nullch) {
X	oldline++;
X	if (oldline == targ) return buff;
X  }
X  return Nullch;
X}
X
Xchar *getnew(targ)
Xint targ;
X{
X  static int newline = 0;
X
X  while (fgets(buff, sizeof buff, newfp) != Nullch) {
X	newline++;
X	if (newline == targ) return buff;
X  }
X  return Nullch;
X}
X
Xvoid *xmalloc(size)
Xsize_t size;
X{
X  void *ptr;
X
X  ptr = malloc(size);
X  if (ptr == NULL) {
X	fprintf(stderr, "%s: out of memory\n", progname);
X	exit(1);
X  }
X  return(ptr);
X}
X
Xvoid *xrealloc(ptr, size)
Xvoid *ptr;
Xsize_t size;
X{
X  ptr = realloc(ptr, size);
X  if (ptr == NULL) {
X	fprintf(stderr, "%s: out of memory\n", progname);
X	exit(1);
X  }
X  return(ptr);
X}
/
