/*****************************************************************
  |  Program: unbundle
  |    accept input from a device and write to stdout
  |----------------------------------------------------------------
  |  Arguments:
  |   1) device name
  |   2) block size in bytes or k
  |  Version: 1.6
  |  Last modified: 3/6/87
  |  Modified 87-12-28 by Tapani Lindgren <nispa@hutcs.hut.fi>
  |----------------------------------------------------------------
  |  Copyright 1986,87 by Bill Davidsen. This code may be used for
  |  personal or commercial purposes. It may be freely distributed
  |  in source form providing this notice is kept intact.
  ****************************************************************/

#include "bundle.h"

usage()
{ /* bad calling sequence */
  fprintf (stderr, "Usage:\n  unbundle [ device [ bufsize ]]\n");
  exit (1);
}

main (argc, argv)
     int  argc;
     char *argv[];
{
  char *devname;
  char *buf, *malloc ();
  int  bufsize, dn, mnum = 1, ch, readsize;
  static char *SCCSid = "@(#)unbundle 1.6";
  long getsize ();		/* size of buffer */
  FILE *tty, *fopen();

  if (argc > 3) usage();
  
  /* try to open the device */
  if (argc > 1) devname = argv[1]; else devname = DEF_DNAME;
  dn = open (devname, 0);
  if (dn < 0)
    { /* open failed */
      fprintf (stderr, "%s: can't open device %s\n", argv[0], devname);
      exit (1);
    }
  close (dn); /* so I can reopen */
  
  /* allocate the buffer */
  if (argc > 2) bufsize = getsize (argv[2]); else bufsize = DEF_BSIZE;
  debug ("Bufsize: %d\n", bufsize);
  if (bufsize < 1) usage();
  
  buf = malloc (bufsize);
  if (buf == NULL)
    { /* can't allocate the buffer */
      fprintf (stderr, "Can't allocate %d byte buffer\n", bufsize);
      exit (1);
    }

  /* open the terminal for prompt */
  tty = fopen ("/dev/tty", "r+");
  if (tty == NULL)
    { /* mystery failure */
      fprintf (stderr, "Unable to open /dev/tty for prompt\n");
      exit (1);
    }
  
  for (;;)
    { /* get a fresh mount and read it */
      fprintf (stderr, "\007Mount media #%d on %s and press RETURN: ",
	       mnum++, devname);
      read(0, &ch, 1); 

      dn = open (devname, 0);
      
      while (readsize = read (dn, buf, bufsize)) {
	write (1, buf, readsize);
	}
      close (dn);
    }
}

/*
  |  Procedure:  getsize
  |-
  |  Convert the size string to bytes. If the last character is
  |  'k', multiply by 1024
  */

long
  getsize (string)
char *string;
{
  register int  len = strlen (string);
  register long val = atol (string);
  
  if (string[len - 1] == 'k')
    val *= 1024;
  
  return val;
}




