/* read a profile file in directory dir. by H. Salomons */

#include <string.h>
#include <stdio.h>

#define MAX_PATH 256
#define MAX_STRG 256

extern char * strsave();

int         getprofile(list, result, max_args, dir, pname)
    char      **list;
    int        *result;
    int         max_args;
    char       *dir;
    char       *pname;
{
    FILE       *fdes;
    char        buffer[MAX_STRG];
    char        name[MAX_PATH];
    char       *cp;
    char       *sp;
    int         i = *result;

    if (dir != (char *) 0)
	sprintf(name, "%s/%s", dir, pname);
    else
	strcpy(name, pname);

    if ((fdes = fopen(name, "r")) != (FILE *) 0)
    {
	while (fgets(buffer, MAX_STRG, fdes) != (char *) 0)
	{
	    sp = buffer;
	    if (*sp == '#')
		continue;	  /* comment line */
	    for (cp = buffer; *cp; cp++)
	    {
		if (strchr("\n\t ", *cp) != (char *) 0)
		{
		    *cp = '\0';
		    if (cp > sp)
		    {
#ifdef DEBUG_PROFILE
			fprintf(stderr, "argument %d '%s'\n", i, sp);
#endif
			list[i] = strsave(sp);
#ifdef DEBUG_PROFILE
			fprintf(stderr, "argument %d '%s'\n", i, list[i]);
#endif
			if (i < max_args)
		    	    i++;
		    }
		    sp = cp + 1;
		}
	    }
	}
	fclose(fdes);
    	* result = i;
    }
#ifdef DEBUG_PROFILE
    for (i = 0; i < * result; i++)
        fprintf(stdout, "%d: %lx '%s'\n", i, list[i], list[i]);
#endif
    return (*result);
}
