
/* Written by:  John Diamant  04/15/1987
   Contributed to the public domain

   This was written for the AST MegaPlus card, but it probably works for the
   other AST cards.

   Should be called in /etc/rc as follows:  "date `astclock`" where path
   information has been deleted.  This only works within the range inputtable
   by date (what happens in 2000?) and will be a few seconds off because of
   the time to call date after astclock returns its answer.  The algorithm
   is also only tested within the years specifiable by date in MS-DOS (the
   way the clock is set on the board), which means 1980-2099.  Since I had
   virtually no documentation for the clock chip, I could only figure out
   the representation for the dates I could set */

#include <stdio.h>
#define CLOCK_PORT 0x2C0
#define SECOND 2
#define MINUTE 3
#define HOUR 4
#define DAY 6
#define MONTH 7
#define Y1 8
#define Y2 9
#define Y3 10

main()
{
	int month, day, year, hour, minute, second;

	port_in(CLOCK_PORT + SECOND, &second);
	port_in(CLOCK_PORT + MINUTE, &minute);
	port_in(CLOCK_PORT + HOUR, &hour);
	port_in(CLOCK_PORT + DAY, &day);
	port_in(CLOCK_PORT + MONTH, &month);
	port_in(CLOCK_PORT + Y3, &year);
	year += 80;

	printf("%02x%02x%02d%02x%02x%02x", month, day, year, hour, minute,
		 second); 
}
