.\" Copyright (c) 1989 Y.Tagawa
.\" This is Freeware
.\"
.\"	@(#)lharc.n	1.00	(Y.Tagawa) 9/22/89
.TH LHARC N "September 22, 1989" "" "LHarc UNIX Users Manual"
.SH "NAME"
LHarc \- Archiver with efficient compression method
.SH "SYNOPSIS"
.B lharc
{
.B key
}[
.B options
] archive_file
[ name ... ]
.SH "DESCRIPTION"
.I LHarc
is an archiver which incorporates efficient compression algorithm.
The author exploited more better compression method by combining
LZHUF method with adaptive huffman method, thus incorporating it
into his archiver.
Its original version was developed under MS-DOS.
.I "LHarc UNIX"
is a derivative work which provides archive compatibility on UNIX.
.PP
LHarc expects name of archive file in 
.I archive_file.
If specified file does not exist, LHarc automatically appends
.I ".lzh"
to the argument then tries again.
Though there are no apparent rule, it will be recommended to append
.I ".lzh"
as their suffix.
Only when it has
.I ".com"
or
.I ".exe"
as its suffix, LHarc examines if it is
.IR SFX (SelF-eXtract)
archive created by MS-DOS 
.I LHarc
then acts appropiately.
However,
.I "LHarc UNIX"
cannot create any SFX archive.
In case addition/deletion was done upon SFX archive,
it creates newer archive with 
.I ".lzh"
as its suffix. Any SFX information will be truncated.
.PP
The first argument
.I key
denotes one of the following:
.TP 8
.B a
addition. Append specified files
.I " name
on the archive. In case
.I " name
was a directory, LHarc will append arbitrary files under 
.I " name.
.TP 8
.B "x or e"
extraction.
LHarc extracts those files specified by
.I " name
, or, if no files were specified, extracts all files in the archive.
.TP 8
.B "l or v"
listing.
LHarc lists archived files (i.e. contents of archive) specified by
.I " name.
With no argument, LHarc lists all files in the archive.
.B " v
instructs LHarc to list the contents of archive in detail.
.TP 8
.B u
update.
LHarc adds files specified by
.I " name,
comparing each file with corresponding one in the archive.
It adds if newer, or if the file doesn't exist in the archive.
With no name specified, LHarc updates the archive by scanning
every corresponding files.
.TP 8
.B d
delete.
Delete specified files in the archive, with
.I " name.
.TP 8
.B m
move.
After storing files with name
.I " name,
LHarc removes them.
This is equivalent to specify 'ad' for
.I key
and 
.I option.
.TP 8
.B c
create.
Discard contents of archive, then creates new archive,
storing files designated by
.I " name.
.TP 8
.B p
print.
Output files specified by
.I " name,
or whole contents (with no explicit specification),
on standard output.
.PP
Additional attributes can be specified with
.I " options
described below.
.TP 8
.B q
quiet.
Suppress messages.
.TP 8
.B v
verbose.
Display verbose message.
.TP 8
.B n
no execution.
This option was provided to ascertain what LHarc will do.
.TP 8
.B f
force.
On extraction, don't ask even if named file already exists.
Old files will be removed quietly.
When storing archive, LHarc specifies 'm' and 'd' option
automatically, thus avoiding query in case there are some
difficulty to remove modules.
.TP 8
.B t
text mode.
Convert newline-code, to maintain portability with MS-DOS LHarc.
.TP 8
.B g
Make archive information to be [generic].
If you consider archive compatibility, don't specify directories
on addition. Existence of pathnames in the archive would not be
recommended. LHarc ignores uppercase/lowercase in [generic] mode,
although they are shown in lowercase, using 'l' or 'v' command.
.TP 8
.B d
Remove files after they were archived.
Note that files will be discarded when used togher with 'u'
command and corresponding file in the archive is newer.
.PP
.SH "FILES "
.ta \w'*.com *.exe    'u
*.lzh		- extension of archive, by default
.br
*.bak	- backup files
.br
/tmp/lh*	- temporary files
.br
*.com *.exe	- MS-DOS SFX files
.PP
.SH "SEE ALSO"
tar(1), ar(1), compress(1)
.SH "DISTRIBUTION"
.PP
The current author makes no restriction under the following condition:
.IP 1.
Copyright notice is maintained.
.IP 2.
As for contents of distribution,
.RS
.IP a.
All files in the standard distribution (e.g. source code, documents,
guide to programmers) must exist in re-distribution.
If they were modified, modification must be indicated apparently.
.IP b.
If any kind of valuable programs, information were added within
re-distribution, distributor must make effort to include them.
In such case, decent documents stating its additional value must
be prepared.
.IP c.
Do not distribute LHarc in binary only. (This also mentions to
added programs/information).
.RE
.IP 3.
You must make effort to distribute newest version (but it's not
your duty).
.IP 4.
No insurance is made upon those defects/losses by the use or the
existence of this program.
.IP 5.
The current author has no duty to correct mistakes, if any, in
this program.
.IP 6.
Part of this program, or whole program may be incorporated
into other program. In such case, the resulting program is not allowed
to be called LHarc.
.IP 7.
For commercial purpose, in addition to above conditions, following
conditions are also applied.
.RS
.IP a.
Commercial use, mainly consists of this program, is prohibited.
.IP b.
In case the business partner was judged to be improper to
use this program, don't distribute this program.
.IP c.
To use LHarc as a resort of installation, do not restrict
the partner to use this program. In this case, commercial
user must do the job. All damages caused by the installation
are attributed to the commercial user.
.IP d.
For commercial purpose, commercial user must support this program.
.RE
.PP
.SH "ACKNOWLEDGEMENTS"
Thanks to Haruhiko Okumura for his development of LZARI method,
on which LZHUF was based. Thanks to Haruhiko Miki for LArc,
and thanks to Yasuaki Yoshizaki for his derivative work from
LArc, thus making up LZHUF method and MS-DOS LHarc.
Thanks to many people who concerned development of LHarc,
Kazuaki Ishibashi for his forwarding mail (between commercial BBS'),
all beta testers who reported various results, and who forwarded
these information, Koichiro Mori.

This manual was translated by Youki Kadobayashi
(youki@mercury.ics.osaka-u.ac.jp). Although I made possible
effort I could, there may be mistakes or queer expression.
Feel free to correct my mistakes, I will appreciate your feedback.

You can distribute this English version of manual page, under the
same condition with the one described above.
