/*
 * WMAIL -	MicroWalt Extended Mail Agent.
 *		This is the MicroWalt Mail Agent; which is derived
 *		from  the  "Mini-Mail" written by Peter S. Housel.
 *
 *		I N T E R A C T I O N    M O D U L E
 *
 * Author:	Fred van Kempen, MicroWalt Corporation
 */
#include <sys/types.h>
#include <errno.h>
#include <ctype.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include "wmail.h"


extern int errno;			/* missing from errno.h" */


/* Send a reply to a message. */
static int do_reply(let, which)
LETTER *let;
int which;
{
  char *who[2];

  if (which == TRUE) who[0] = let->sender2;
    else who[0] = let->sender1;
  who[1] = (char *)NULL;
  strcpy(addr_cc, "");
  strcpy(addr_bcc, "");
  sprintf(subject, "Re: %s", let->subject);

  printf("\nFrom: %s %-24.24s\n", sender, xtime());
  printf("To: %s\n", who[0]);
  printf("Subject: %s\n", subject);

  if (do_send(who, (char *)NULL, FALSE) == -1) {
	printf("*** Reply: delivery for \"%s\" failed.\n", who[0]);
  }
}


/* Execute a shell (or a command only). */
static void do_shell(command)
char *command;
{
  int status, pid;

  if ((pid = fork()) == 0) {
	setuid(old_uid);	/* security! */
	setgid(old_gid);
	umask(oldmask);

	if (*command == '\0') execl(rc_shell, rc_shell, (char *)NULL);
	  else execl(rc_shell, rc_shell, "-c", command, (char *)NULL);
	printf("*** Shell: cannot execute \"%s\"\n", rc_shell);
	clr_exit(127);
  } else {
	  if (pid > 0) 
		while (wait(&status) != pid)
			    ;
	    else printf("*** Shell: cannot fork().\n");
  }
}


/* Go to a specific letter. */
LETTER *goto_letter(num)
register int num;
{
  register LETTER *let;

  let = firstlet;
  while (let != NIL_LET) {
	if (let->seqno == num) return(let);
	let = let->next;
  }
  return(NIL_LET);
}


/* Skip the header of the current message. */
static off_t skiphead()
{
  char skbuf[1024];
  off_t count;

  count = (off_t) 0;
  while (fgets(skbuf, 1024, boxfp) != (char *)NULL) {
	count += (off_t) strlen(skbuf);
      	if (skbuf[0] == '\n') break;
  }
  return(count);
}


/* Save the current letter to a disk-file. */
void savelet(let, savefile, withhead)
LETTER *let;
char *savefile;
int withhead;
{
  char fname[PATHLEN];
  off_t curr, limit, oldpos;
  register char *bp;
  FILE *savefp;
  int c, temp;

  bp = savefile;
  while (*bp && *bp != '\n') bp++;
  *bp = '\0';

  if (rc_folder != (char *)NULL) {
	if (*savefile == '/' || *savefile == '.') strcpy(fname, savefile);
	  else sprintf(fname, "%s/%s/%s", home, rc_folder, savefile);
  } else {
	if (*savefile == '/' || *savefile == '.') strcpy(fname, savefile);
	  else sprintf(fname, "%s/%s", home, savefile);
  }

  /* Check if we may write to that file. */
  if (allowed(fname, 02) == FALSE) {
	printf("*** Save: permission for \"%s\" denied\n", fname);
	return;
  }

  /* We may, go ahead! */
  if ((savefp = fopen(fname, "a")) == (FILE *)NULL) {
	printf("*** Save: cannot save to \"%s\"\n", fname);
	return;
  }

  temp = umask(oldmask);	/* set previous umask() */

  oldpos = ftell(boxfp);
  fseek(boxfp, (curr = let->location), SEEK_SET);
  limit = (let->next != NIL_LET) ? let->next->location : -1L;

  if (withhead == 0) curr += skiphead();	/* skip the message header */
  while(curr != limit && (c = fgetc(boxfp)) != EOF) {
	fputc(c, savefp);
      	++curr;
  }
  fflush(savefp);
  fseek(boxfp, oldpos, SEEK_SET);

  if ((ferror(savefp) != 0) | (fclose(savefp) != 0)) {
	printf("*** Save: write error\n");
  }

  umask(temp);		/* set previous umask() */

  chown(fname, old_uid, old_gid);
}


/* Give a list of possible Interact Commands. */
static void do_help()
{
  printf("\n   ** W-MAIL Commands **\n\n");
  printf("?\tThis help\n");
  printf("!\tShell Command Escape\n");
  printf("-\tPrevious letter\n");
  printf("+\tNext letter\n");
  printf("<ENTER>\tTake next letter, and show it\n");
  printf("d\tDelete current letter\n");
  printf("f\tForward a letter\n");
  printf("F\tForward a letter (quoted)\n");
  printf("h\tDisplay a summary of letters\n");
  printf("n\tSame as ENTER\n");
  printf("p\tPrint a letter again\n");
  printf("q\tQuit, update mailbox\n");
  printf("r\tReply to the current letter (with Reply-To:)\n");
  printf("R\tReply to SENDER of current letter\n");
  printf("s\tSave current letter\n");
  printf("t\tType a letter, no paging\n");
  printf("u\tUn-delete a letter\n");
  printf("w\tSave letter without header\n");
  printf("x\tExit, do not update mailbox\n");
  printf("z\tDisplay next page of summary\n");
  printf("\n");
}


/* Give a summary of letters. */
static void summary(nextlet)
int nextlet;
{
  register LETTER *let;
  register int startno;

  startno = (nextlet - 1) / 20 * 20 + 1;
  for (let = firstlet; let->seqno < startno; let = let->next) ;
  while (let != NIL_LET && let->seqno < startno + 20 && let->seqno &&
         let->seqno <= numlet) {
	printf("%c%c%2.2d %-17.17s  %-12.12s %4.4d/%-7.7ld%.30s\n",
		(nextlet == let->seqno) ? '>': ' ',
		(let->status == DELETED) ? '*': ' ',
 		let->seqno, 
		let->real_name, 
		let->date, 
		let->no_lines,
		let->no_chars,
		let->subject
	);
	let = let->next;
  }
  if (numlet >= startno + 20)
	printf("%d more message(s)\n", numlet - startno - 19);
}


/* Interactively process the mail-box. */
void interact()
{
  char input[512];
  LETTER *let, *templet;
  int interrupted = FALSE;
  char *savefile, *sp;
  int temp, nextlet;
  int first;

  if (firstlet == NIL_LET) {
	printf("No mail for %s.\n", sender);
      	return;
  }

  printf("W-MAIL %s.  Type ? for Help.\n", Version);
  printf("\"%s\": %d message(s)\n", mailbox, numlet);

  let = firstlet;		/* Set first letter. */
  first = TRUE;			/* signal "first letter" */

  summary(1);			/* Show a summary of all the letters. */

  while(TRUE) {
	nextlet = let->seqno;

       	if (!quitmode) {
		interrupted = setjmp(printjump);
		signal(SIGINT, onint);
       	}

      	if (interrupted == TRUE) printf("\n");
      	printf(rc_prompt, let->seqno);
	curletno = let->seqno;

      	fflush(stdout);

      	if (gets(input, 512) == (char *)NULL) break;

      	if (!quitmode) signal(SIGINT, SIG_IGN);

	/*
	 * Look at the first valid character of the command line.
	 * We should use messages intervals as well....
	 */
	sp = input;
	while (*sp == ' ' || *sp == '\t') sp++;

      	switch(*sp++) {
		case '!':	/* Shell escape. */
			while (*sp == ' ' || *sp == '\t') sp++;
			do_shell(sp);
			break;
		case '?':	/* Type some help. */
			do_help();
			break;
		case '-':	/* Show previous letter. */
			if (let->prev != NIL_LET) let = let->prev;
			  else printf("Top of mailbox\n");
			break;
		case '+':	/* Show next letter. */
			if (let->next != NIL_LET) let = let->next;
			  else printf("At EOF\n");
			break;
		case '\0':	/* Move to next letter and show current. */
		case 'n':
			if (first == FALSE) {
				if (let->next == NIL_LET) {
					printf(rc_prompt, let->seqno);
					printf("At EOF\n");
				} else let = let->next;
			} else first = FALSE;
			if (!interrupted) {
				if (let->status != DELETED) let->status = READ;
		    		printlet(let, stdout);
			}
			break;
		case 'd':	/* Delete current letter. */
			let->status = DELETED;
			if (let->next != NIL_LET) let = let->next;
			needupdate = TRUE;
			break;
		case 'f':	/* Forward current letter. */
			while (*sp == ' ' || *sp == '\t') sp++;
			do_forward(let, FALSE, sp);
			break;
		case 'F':	/* Forward current letter (quoted). */
			while (*sp == ' ' || *sp == '\t') sp++;
			do_forward(let, TRUE, sp);
			break;
		case 'h':	/* Show letter summary */
			summary(nextlet);
			break;
		case 'p':	/* Print a letter. */
			if (!interrupted) printlet(let, stdout);
			break;
		case 'q':	/* Update mailbox and quit. */
			return;
		case 'r':	/* Reply to a message (use Reply-To:). */
			do_reply(let, FALSE);
			break;
		case 'R':	/* Reply to SENDER of a message. */
			do_reply(let, TRUE);
		case 's':	/* Save message to disk. */
			savefile = sp;
			while (*savefile == ' ' || *savefile == '\t')
								savefile++;
			if (*savefile == '\0') savefile = rc_mbox;
			savelet(let, savefile, TRUE);
			break;
		case 't':	/* Type (no paging) current letter. */
			temp = printmode;
			printmode = TRUE;
			if (!interrupted) printlet(let, stdout);
			printmode = temp;
			break;
		case 'u':	/* Un-delete a letter. */
			while (*sp == ' ' || *sp == '\t') sp++;
			if (isdigit(*sp)) {
				templet = goto_letter(atoi(sp));
				if (templet != NIL_LET) {
					templet->status &= ~DELETED;
			   	} else printf("No message number %s\n", sp);
			} else {
				templet = let;
				templet->status &= ~DELETED;
			}
			printf("Un-deleted message %d\n", templet->seqno);
			break;
		case 'w':	/* Write (without header) message to disk. */
			savefile = sp;
			while (*savefile == ' ' || *savefile == '\t')
								savefile++;
			if (*savefile == '\0') savefile = rc_mbox;
			savelet(let, savefile, FALSE);
			break;
		case 'x':	/* Abort, do not update mailbox. */
			clr_exit(0);
		case 'z':	/* Display next summary page */
			temp = (nextlet - 1) / 20 * 20 + 21;
			if (temp <= numlet)
				while (let->seqno != temp) let = let->next;
			  else let = firstlet;
			nextlet = let->seqno;
			summary(nextlet);
			break;
		default:
			if (isdigit(*--sp)) {
				templet = goto_letter(atoi(sp));
				if (templet != NIL_LET) {
					let = templet;
					printlet(let, stdout);
			   	} else printf("No message number %s\n", sp);
			} else printf("Unknown command\n");
			break;
  	}
  }   
}
