/*
 * WMAIL -	MicroWalt Extended Mail Agent.
 *		This is the MicroWalt Mail Agent; which is derived
 *		from  the  "Mini-Mail" written by Peter S. Housel.
 *
 *		A L I A S   E X P A N S I O N   M O D U L E
 *
 * Author:	Fred van Kempen, MicroWalt Corporation
 */
#include <sys/types.h>
#include <pwd.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "wmail.h"


/*
 * This is the alias expansion routine.
 * It takes the string from "src", and breaks it up into
 * separated addresses.  If the addresses are aliases,
 * they will be expanded.  The resulting addresses will
 * be stuffed into "dst" (separated by commas), and in
 * the "addr" array.
 * The new index of 'addr' will be returned.
 */
int exp_alias(src, dst, adi, addr)
char *src;
char *dst;
int adi;
char *addr[];
{
  char buff1[1024];
  char buff2[1024];
  char *vec[MAXRCPT];				/* array of addresses */
  char *ap, *sp, *xp;
  int idx;

  if (*src == '\0') return(adi);		/* no address list */
  strcpy(buff1, src);
  src = buff1;

  /* Split the "src" string into separate addresses. */
  idx = 0;
  sp = src;
  while (sp != (char *)NULL) {
	vec[idx++] = src;
	sp = strchr(src, ',');
	if (sp == (char *)NULL) sp = strchr(src, ' ');
	if (sp != (char *)NULL) {
		*sp++ = '\0';
		while (*sp == ' ' || *sp == '\t') sp++;
		src = sp;
	}
  }
  vec[idx] = (char *)NULL;

  /*
   * We now have an array of addresses; loop over it.
   * Copy the addressees to the addr[] table, while expanding
   * possible aliases on the fly.  Also, create a string "dst"
   * which will be used in the To:, Cc: or Bcc: fields.
   */
  idx = 0;
  while (vec[idx] != (char *)NULL) {
	ap = rc_alias(vec[idx]);		/* is this an alias? */
	if (ap != (char *)NULL) {
		if (strchr(ap, ' ') != (char *)NULL) {
			strcpy(buff2, ap);
			ap = buff2;
			while ((sp = strchr(ap, ' ')) != (char *)NULL) {
				*sp++ = '\0';
				if (addr != (char **)NULL) {
					xp = (char *)malloc(strlen(ap) + 2);
					if (xp == (char *)NULL) {
						fprintf(stderr, "Out of memory.\n");
						exit(-1);
					}
					strcpy(xp, ap);
					addr[adi++] = xp;
				}
				if (dst != (char *)NULL) {
					strcat(dst, ap);
					strcat(dst, ", ");
				}
				ap = sp;
			}
			if (addr != (char **)NULL) {
				xp = (char *)malloc(strlen(ap) + 2);
				if (xp == (char *)NULL) {
					fprintf(stderr, "Out of memory.\n");
					exit(-1);
				}
				strcpy(xp, ap);
				addr[adi++] = xp;
			}
			if (dst != (char *)NULL) {
				strcat(dst, ap);
				strcat(dst, ", ");
			}
		} else {
			if (addr != (char **)NULL) {
				xp = (char *)malloc(strlen(ap) + 2);
				if (xp == (char *)NULL) {
					fprintf(stderr, "Out of memory.\n");
					exit(-1);
				}
				strcpy(xp, ap);
				addr[adi++] = xp;
			}
			if (dst != (char *)NULL) {
				strcat(dst, ap);
				strcat(dst, ", ");
			}
		}
	} else {
		if (addr != (char **)NULL) {
			xp = (char *)malloc(strlen(vec[idx]) + 2);
			if (xp == (char *)NULL) {
				fprintf(stderr, "Out of memory.\n");
				exit(-1);
			}
			strcpy(xp, vec[idx]);
			addr[adi++] = xp;
		}
		if (dst != (char *)NULL) {
			strcat(dst, vec[idx]);
			strcat(dst, ", ");
		}
	}
	idx++;
  }

  /* Terminate the message list. */
  if (addr != (char **)NULL) addr[adi] = (char *)NULL;

  return(adi);
}


#ifdef SELFMAIN
static void usage()
{
  fprintf(stderr, "Usage: alias user ...\n");
  exit(-1);
}


/* If this is also the "alias" program... */
int main(argc, argv)
int argc;
char **argv;
{
  char buff[128];
  char *addrs[MAXRCPT];
  int num;
  struct passwd *pw;

  if (argc == 1) usage();
  argv++;

  pw = getpwuid(getuid());

  sprintf(buff, "%s/%s", SYSDIR, SYSMAILRC);
  rc_read(buff);

  sprintf(buff, "%s/%s", pw->pw_dir, MAILRC);
  rc_read(buff);

  num = 0;
  addrs[0] = (char *)NULL;

  while (*argv != (char *)NULL) {
	num = exp_alias(*argv, (char *)NULL, num, addrs);
	argv++;
  }

  argv = addrs;
  while (*argv != (char *)NULL) {
	printf("%s\n", *argv);
	argv++;
  }
  exit(num);
}
#endif
