/*
 * WMAIL -	MicroWalt Extended Mail Agent.
 *		This is the MicroWalt Mail Agent; which is derived
 *		from  the  "Mini-Mail" written by Peter S. Housel.
 *
 *		D E F I N I T I O N S
 *
 * Author:	Fred van Kempen, MicroWalt Corporation
 */
#include <setjmp.h>


#ifdef _MINIX
#	define VERSION	  "3.63/MINIX (11/05/90)"
#	define DROPNAME      "/usr/spool/mail/%s"	/* User Mailbox */
#	define LOCKNAME	"/usr/spool/mail/%s.lock"	/* lockfile for box */
#	define SYSDIR	               "/usr/lib"	/* for wmailrc */
#	define EEDITOR		        "/bin/ed"	/* line editor */
#	define VEDITOR		 "/usr/bin/mined"	/* visual editor */
#endif

#ifdef _UNIX
#	define VERSION	   "3.63/UNIX (11/05/90)"
#	define DROPNAME            "/usr/mail/%s"	/* User Mailbox */
#	define LOCKNAME	      "/usr/mail/%s.lock"	/* lockfile for box */
#	define SYSDIR		       "/usr/lib"	/* for wmailrc */
#	define EEDITOR		    "/usr/bin/ex"	/* line editor */
#	define VEDITOR		    "/usr/bin/vi"	/* visual editor */
#endif

#define MAILRC				".mailrc"	/* user mail config */
#define SYSMAILRC			"wmailrc"	/* system mail config */
#define SHELL				"/bin/sh"	/* escape shell */
#define SIGNATURE                    ".signature"	/* .sig file */
#define PROMPT                           "[%d]& "	/* comm. prompt */

#define MAILTEMP		"/tmp/mailXXXXXX"	/* temp. file */
#define COPYTEMP		"/tmp/mcpyXXXXXX"	/* temp update file */
#define DEADLETTER                  "dead.letter"	/* error mail save */
#define RMAIL	                 "/usr/bin/rmail"	/* Internet Mailer */
#define SAVEFILE                           "mbox"	/* default mailsave */

#define RC_SHELL			"shell"
#define RC_PROMPT			"prompt"
#define RC_EEDIT			"eeditor"
#define RC_VEDIT			"veditor"
#define RC_ASKSUB			"asksub"
#define RC_NOASKSUB			"noasksub"
#define RC_AUTOSIG			"autosig"
#define RC_NOAUTOSIG			"noautosig"

#ifndef PATHLEN
#	define PATHLEN	128
#endif

#ifndef TRUE
#	define FALSE	  0
#	define TRUE	  1
#endif

#define LOCKWAIT	  5		/* seconds to wait after collision */
#define LOCKTRIES	  4		/* maximum number of collisions */
#define MAXRCPT		100		/* maximum number of recipients */
#define LINELEN		512

#define UNREAD		  1		/* 'not read yet' status */
#define DELETED		  2		/* 'deleted' status */
#define READ		  3		/* 'has been read' status */


typedef struct _letter{
  struct _letter *prev;			/* linked letter list: prev letter */
  struct _letter *next;			/* linked letter list: next letter */
  off_t		 location;		/* location within mailbox file */
  int 		 status;		/* letter status */
  int 		 seqno;			/* letter number */
  char 		 *subject;		/* subject of message */
  char 		 *sender1;		/* Reply-To: or From: sender */
  char		 *sender2;		/* From: sender */
  char 		 *real_name;		/* real name of sender of message */
  char 		 date[32];		/* date of message */
  int 		 no_lines;		/* number of lines in message */
  off_t 	 no_chars;		/* number of characters in message */
} LETTER;
#define NIL_LET	(LETTER *)NULL


extern char *Version;
extern int old_uid, old_gid;		/* "real" ID's of caller */
extern int remote;			/* use RMAIL to deliver (if any) */
extern int loclink;			/* LMAIL: local delivery only! */
extern int printmode;			/* print-and-exit mode */
extern int immediate;			/* send remote immediately! */
extern int quitmode;			/* take interrupts */
extern int usedrop;			/* read the maildrop (no -f given) */
extern int verbose;			/* pass "-v" flag on to mailer */
extern int needupdate;			/* need to update mailbox */
extern int sayall;			/* include line with all recipients */
extern int checkonly;			/* only chack if there is mail */
extern char home[PATHLEN];		/* user's home dir */
extern char sender[PATHLEN];		/* who sent the message? */
extern char forward[PATHLEN];		/* who is the message forwarded to? */
extern char addressee[PATHLEN];		/* current recipient */
extern char recipients[PATHLEN];	/* also to... users */
extern char addr_cc[PATHLEN];		/* Carbon Copy addressee */
extern char addr_bcc[PATHLEN];		/* Blank CC addressee */
extern char mailbox[PATHLEN];		/* user's mailbox/maildrop */
extern char subject[PATHLEN];		/* subject of message */
extern char tempfn[PATHLEN];		/* temporary file */
extern FILE *infp;			/* current message input file */
extern FILE *boxfp;			/* mailbox file */
extern char *progname;			/* program name */
extern jmp_buf printjump;		/* for quitting out of letters */
extern LETTER *firstlet, *lastlet;	/* message pointers for readbox() */
extern int curletno;			/* holds number of current message */
extern int numlet, seqno;		/* number of active letters */
extern unsigned oldmask;		/* saved umask() */ 

/* W-MAIL Configuration Variables (.mailrc). */
extern int rc_asksub;			/* BOOL: ask for Subject: line */
extern int rc_autosig;			/* BOOL: add .signature automatically */
extern int rc_askcc;			/* BOOL: ask for Cc: line */
extern int rc_askbcc;			/* BOOL: ask for Bcc: line */
extern int rc_copies;			/* number of copies to record */
extern char *rc_signature;		/* name of .signature file */
extern char *rc_folder;			/* mail folder */
extern char *rc_record;			/* traffic recording file */
extern char *rc_mbox;			/* file for dumping messages */
extern char *rc_shell;			/* shell program */
extern char *rc_prompt;			/* WMAIL prompt */
extern char *rc_eedit;			/* LINE editor */
extern char *rc_vedit;			/* VISUAL editor */


/* Function Prototypes. */
#if _MSDOS
#       define  _PROTOTYPE(function, params)    function params
#       define  _VOIDSTAR       void *
#       define  _VOID           void
#       define  _CONST          const
#       define  _VOLATILE       volatile
#       define _SIZET           size_t
#else
#ifndef _ANSI_H
#       include <ansi.h>
#endif  /* _ANSI_H */
#endif  /* _MSDOS */

_PROTOTYPE( void clr_exit, (int num) );
_PROTOTYPE( void onint, (void) );
_PROTOTYPE( char *basename, (char *name) );
_PROTOTYPE( int allowed, (char *name, int mode) );
_PROTOTYPE( void showlet, (LETTER *let) );
_PROTOTYPE( void printlet, (LETTER *let, FILE *tofp) );
_PROTOTYPE( void printall, (void) );
_PROTOTYPE( void dead_letter, (void) );
_PROTOTYPE( char *find_string, (LETTER *let, char *text) );
_PROTOTYPE( void interact, (void) );
_PROTOTYPE( void send_remote, (char *name) );
_PROTOTYPE( FILE *edit_mail, (char *msg, int quote) );
_PROTOTYPE( LETTER *goto_letter, (int num) );
_PROTOTYPE( int chk_box, (char *boxname) );
_PROTOTYPE( int do_send, (char *vec[], char *msg, int quote) );
_PROTOTYPE( void do_forward, (LETTER *let, int quote, char *addr) );
_PROTOTYPE( char *xtime, (void) );
_PROTOTYPE( char *rc_alias, (char *aname) );
_PROTOTYPE( void rc_read, (char *rc_name) );
_PROTOTYPE( int exp_alias, (char *src, char *dst, int num, char **addr) );

