/*
 * UUXQT-	UUCP Command File Execute
 * 		This program searches for work files in the spool directory
 *		and executes them.  Work files 	have a X. prefix.  It is
 *		executed by 'uucico', 'cron', or 'at'.
 *		Note, that the error recovery part needs a lot 	of work, as
 *		does the execution permission stuff.  Currently, all commands
 *		can be executed, which is a fair security hole!
 *
 * Version:	1.7	02/17/90
 *
 * Author:	Copyright (c) 1985, 1986, 1987 by Richard H. Lamb
 * 		Changes are Public Domain by S. R. Sampson
 *
 * History:
 * 		Fred van Kempen (waltje@minixug.hobbynet.nl)
 *			- Added 'R'-line in commandfile (REPLY to USER)
 *			- Added '#'-line in commandfile (COMMENT)
 *			- Added 'default' statement in parser.
 *			- Added 'exec' prefix in system() call.
 *			- Adapted to MSS 10/04/89
 *			- Adapted to POSIX (MINIX 1.5)
 *			- Fixed umask() problem (did not unlink files)
 *			- Added status-replies.
 */
#include <sys/types.h>
#include <dirent.h>		/* defines directory stuff */
#include <limits.h>		/* defines NAME_MAX */
#include <pwd.h>
#include <string.h>
#include <time.h>
#include <stdio.h>
#include "uucp.h"

#define MAXLINE         256


static char *version = "@(#) uuxqt 1.7 (02/17/90)";


char line[MAXLINE+5];			/* current line in C-file */
char Cfilename[NAME_MAX+1];		/* name of current C-file */
char input[MAXLINE+1];			/* name of input file */
char output[MAXLINE+1];			/* name of output file */
char filename[NAME_MAX+1];		/* name of filename to use */
char command[MAXLINE+1];		/* command to be executed */
char host[16];				/* hostname of caller */
char user[32];				/* username of caller */
char erruser[32];			/* user to send reports to */
char *spooldir = SPOOLDIR;		/* to save some string space */
long stamp;


/*
 *      mfgets (modified K&R fgets)
 *
 *      Same as fgets() only this version deletes '\n'
 */
static char *mfgets(s, n, iop)
register char *s;
register int n;
register FILE *iop;
{
  register int c;
  register char *cs;

  cs = s;
  while (--n > 0 && (c = getc(iop)) != EOF)  {
  	if (c == '\n')  {
        	*cs = '\0';
                break;
        } else
                *cs++ = c;
  }
  return((c == EOF && cs == s) ? (char *)NULL : s);
}


void sendmail(user, host, subj, st, file)
char *user, *host, *subj;
int st;
char *file;
{
  char tmp[255];
  char sub[255];

  /* Check if input file exists. */
  if (access(file, 0) == -1) return;

  /* What was the problem? */
  if (subj == (char *)NULL)
	sprintf(sub, "Remote execution failed: exit status was %d", st);
    else strcpy(sub, subj);

  sprintf(tmp, "mail -i%s -s'%s'%s!%s", file, sub, host, user);
  system(tmp);  
}


int main(argc, argv)
int argc;
char **argv;
{
  char ltime[32];
  struct dirent  *dir;
  struct passwd *pw;
  FILE *fdC, *log;
  DIR *dd;
  register char *p;
  int inull, onull, st;

  chdir(spooldir);		/* change to spool directory */
  umask(0177);			/* set protection mask to rw------- */

  if ((dd = opendir(spooldir)) == (DIR *)NULL) exit(1);

  while ((dir = readdir(dd)) != (struct dirent *)NULL) {
	if (strncmp(dir->d_name, "X.", 2)) continue;

        strncpy(Cfilename, dir->d_name, 14);

        if ((fdC = fopen(Cfilename, "r")) == (FILE *)NULL) continue;

        inull = onull = 1;

        while (mfgets(line, MAXLINE, fdC) != (char *)NULL) switch (line[0]) {
		case '#':	/* comment-line */
			break;
                case 'C':
                        strcpy(command, &line[2]);
                        break;
		case 'R':	/* reply to USER if errors! */
			strcpy(erruser, &line[2]);
			break;
                case 'F':	/* set filename */
                        sprintf(filename, "%s/%s", spooldir, &line[2]);
                        p = filename;
                        while ((*p != ' ') && *p) p++;
                        *p = '\0';
                        break;
                case 'I':	/* set STDIN-file */
                        sprintf(input, "%s/%s", spooldir, &line[2]);
                        inull = 0;
                        break;
                case 'O':	/* set STDOUT-file */
                        sprintf(output, "%s/%s", spooldir, &line[2]);
                        onull = 0;
                        break;
                case 'U':	/* set USER-name */
                        strcpy(user, &line[2]);
                        p = user;
                        while ((*p != ' ') && *p) p++;
                        *p++ = '\0';
                        strcpy(host, p);
                        break;
		default:
			break;
        }

        fclose(fdC);

        if (inull) strcpy(input, "/dev/null");

        if (onull) strcpy(output, "/dev/null");	

	/*
	 * We now have all information needed to execute the command.
	 * At this time, we should check if the calling system may in-
	 * deed execute the command.  For now, we assume all is OK and
 	 * we execute the command.
	 */
        sprintf(line,"exec %s <%s >%s", command, input, output);

        if ((log = fopen(XQTLOG, "a")) != (FILE *)NULL) {
        	time(&stamp);
                strcpy(ltime, ctime(&stamp));
                ltime[strlen(ltime) - 1] = '\0';

                fprintf(log, "%s %s@%s: \"%s\"\n",
                	ltime, user, host, line);

                fclose(log);
        }

	st = system(line);

	/*
	 * We just executed the command.
	 * Check to see if all went OK.  If not, send the caller a report
	 * to tell him what went wrong.
	 * If any output was generated by the command, send it back to the
	 * caller as electronic mail.
	 */
	if (st == 0) {
		unlink(Cfilename);
                if (!inull) unlink(input);
                if (!onull) {
			/* Send output back to caller. */
			sendmail(user, host, "UUCP execution output", st, output);
			unlink(output);
		}
	} else {
		sendmail(user, host, NULL, st, input);
	}
  }

  closedir(dd);
}
