/*
 * UMAIL -	MINIX Remote Domain-addressing Mail Router
 *
 *		This version of RMAIL handles message-headers in a much
 *		more "standard" way. It can handle bang-addresses, plus
 *		the new-style Internet addressing (user@host.domain).
 *		It is called by programs as "Mail" and "Uuxqt".
 *
 *	    	A D R E S S   C O N V E R S I O N   M O D U L E
 *
 * 		Convert addresses into manageable chunks.
 *
 * 		We understand the following notations:
 *
 *		1. user@host.domain	--> waltje@minixug.UUCP
 *	
 *		2. host!user		--> minixug!waltje
 *	
 *		3. user			--> waltje
 *
 * Return TRUE (1) if OK, or FALSE (0) if an error was encountered.
 *
 * Author:	F. van Kempen, waltje@minixug.hobbynet.nl
 *
 * Revisions:
 *		11/07/89 FvK	Edited a little for the new MSS.
 *		12/16/89 FvK	Cleanup.
 *		12/30/89 FvK	Adapted for POSIX (MINIX 1.5)
 *		02/17/90 FvK	Cleaned for release.
 */
#include <sys/types.h>
#include <string.h>
#include <stdio.h>
#include "umail.h"


/*
 * Convert address 'adr' into more manageable chunks.
 * Stuff the output into 'mailaddr' (the final user)
 * and 'mailcmd' (the mailer command to use).
 * Return NILBOX if an error ocurred.
 */
BOX *convert(adr)
char *adr;
{
  static BOX box;
  char temp[1024];
  register char *bp, *sp, *cp;
  register ROUTE *rp;
  register HOST *hp;

  strcpy(mailaddr, adr);
  box.domain[0] = box.host[0] = '\0';
  box.user[0] = temp[0] = '\0';

  /*
   * Rule 1: Check for user@host.domain
   */
  sp = strrchr(mailaddr, '@');
  if (sp != (char *)NULL) {
	*sp++ = '\0';
	strcpy(box.user, mailaddr);
	strcpy(temp, sp);	
	strlwr(temp);		/* convert domain to lower case: RFC822 */

	/*
	 * Rule 1A: Now check for "." in the domain part.
	 * 	    This indicates that a host name was given.
	 */
	sp = strchr(temp, '.');		/* syntax host.domain ?? */
	if (sp == (char *)NULL) {	/* no, onlky 'host' part */
		hp = gethost(temp);	/* is this a local host? */
		if (hp != NILHOST) {	/* yes! */
			strcpy(box.host, temp);
			box.domain[0] = '\0';
			return(&box);
		} else {		/* no, must be a domain.... */
			strcpy(box.domain, temp);
			box.host[0] = '\0';
			return(&box);
	  	}
	} else {			/* domain and host given! */
		*sp++ = '\0';
		strcpy(box.host, temp);
		strcpy(box.domain, sp);
		return(&box);
	}
  }

  /*
   * Rule 2: Check for host!user
   */
  sp = strchr(mailaddr, '!');
  if (sp != (char *)NULL) {
	*sp++ = '\0';
	strcpy(box.host, mailaddr);
	strcpy(box.user, sp);
	return(&box);
  }

  /*
   * Rule 3: Must be local user.
   */
  strcpy(box.user, mailaddr);
  box.host[0] = '\0';
  box.domain[0] = '\0';
  return(&box);
}

