# include <stdio.h>
# include <sgtty.h>

unsigned long timebase, time();
struct sgttyb oldtty;

/* Called at startup time to set up console I/O, ... */
ioinit()
{
    struct sgttyb ttybuf;

    ioctl(1,TIOCGETP,&ttybuf);
    oldtty = ttybuf;
    ttybuf.sg_flags &= ~ECHO;
    ttybuf.sg_flags |= CBREAK;
/**
    ioctl(1,TIOCSETP,&ttybuf);
**/
    time( &timebase );
}

iostop() {
    ioctl(1, TIOCSETP, &oldtty );
    while(ifaces != NULLIF){
	if(ifaces->stop != NULLFP)
	    (*ifaces->stop)(ifaces);
	ifaces = ifaces->next;
    }
}

short clksec()
{
    return( time(0) - timebase );
}

FILE *
tmpfile() {
    char nam[ 100 ];

    sprintf( nam, "t%x%lX", getpid(), time(0) );
    return( fopen( nam, "w+" ) );
}

static istate = 1;
short disable() {
    int tmp;
    tmp = istate;
    istate = 0;
    if( tmp )
	printf("disabling\n");
    return tmp;
}

restore( s )
int s;
{
    istate = s;
    printf("restore %d\n", s );
}

eihalt() {
    puts("eihalt\n");
    pause();
}
